/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection.aliases;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.intellij.plugins.markdown.injection.aliases.AdditionalFenceLanguageSuggester;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageAliases;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0007J \u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/injection/aliases/CodeFenceLanguageGuesser;", "", "<init>", "()V", "customProviders", "", "Lorg/intellij/plugins/markdown/injection/CodeFenceLanguageProvider;", "getCustomProviders", "()Ljava/util/List;", "suggestersPointName", "", "suggestersExtensionPoint", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lorg/intellij/plugins/markdown/injection/aliases/AdditionalFenceLanguageSuggester;", "guessLanguageForInjection", "Lcom/intellij/lang/Language;", "value", "findLanguage", "registeredLanguages", "", "guessLanguage", "intellij.markdown"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCodeFenceLanguageGuesser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFenceLanguageGuesser.kt\norg/intellij/plugins/markdown/injection/aliases/CodeFenceLanguageGuesser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class CodeFenceLanguageGuesser {
    @NotNull
    public static final CodeFenceLanguageGuesser INSTANCE = new CodeFenceLanguageGuesser();
    @NotNull
    private static final String suggestersPointName = "org.intellij.markdown.additionalFenceLanguageSuggester";
    @NotNull
    private static final ExtensionPointName<AdditionalFenceLanguageSuggester> suggestersExtensionPoint = ExtensionPointName.Companion.create("org.intellij.markdown.additionalFenceLanguageSuggester");

    private CodeFenceLanguageGuesser() {
    }

    @NotNull
    public final List<CodeFenceLanguageProvider> getCustomProviders() {
        return CodeFenceLanguageProvider.EP_NAME.getExtensionList();
    }

    @JvmStatic
    @Nullable
    public static final Language guessLanguageForInjection(@NotNull String value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Language language = CodeFenceLanguageGuesser.guessLanguage(value);
        if (language != null) {
            Language language2;
            Language it = language2 = language;
            boolean bl = false;
            object = LanguageUtil.isInjectableLanguage((Language)it) ? language2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final Language findLanguage(String value, Collection<? extends Language> registeredLanguages) {
        Object v1;
        String entry;
        block3: {
            String string = CodeFenceLanguageAliases.INSTANCE.findRegisteredEntry(value);
            if (string == null) {
                string = value;
            }
            entry = string;
            Iterable iterable = registeredLanguages;
            for (Object t : iterable) {
                Language it = (Language)t;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getID(), (String)entry, (boolean)true)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        Language registered = v1;
        if (registered != null) {
            return registered;
        }
        Sequence additionalSuggesters = CollectionsKt.asSequence((Iterable)suggestersExtensionPoint.getExtensionList());
        return (Language)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)additionalSuggesters, arg_0 -> CodeFenceLanguageGuesser.findLanguage$lambda$1(entry, arg_0)));
    }

    private final Language findLanguage(String value) {
        Collection collection = Language.getRegisteredLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages(...)");
        Collection registeredLanguages = collection;
        Language exactMatch = this.findLanguage(value, registeredLanguages);
        if (exactMatch != null) {
            return exactMatch;
        }
        int index = StringsKt.lastIndexOf$default((CharSequence)value, (char)' ', (int)0, (boolean)false, (int)6, null);
        while (index != -1) {
            String nameWithoutCustomizations;
            Intrinsics.checkNotNullExpressionValue((Object)value.substring(0, index), (String)"substring(...)");
            Language language = this.findLanguage(nameWithoutCustomizations, registeredLanguages);
            if (language != null) {
                return language;
            }
            index = StringsKt.lastIndexOf$default((CharSequence)value, (char)' ', (int)RangesKt.coerceAtLeast((int)(index - 1), (int)0), (boolean)false, (int)4, null);
        }
        return null;
    }

    @JvmStatic
    private static final Language guessLanguage(String value) {
        for (CodeFenceLanguageProvider provider : INSTANCE.getCustomProviders()) {
            Language lang = provider.getLanguageByInfoString(value);
            if (lang == null) continue;
            return lang;
        }
        String string = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String name = string;
        return INSTANCE.findLanguage(name);
    }

    private static final Language findLanguage$lambda$1(String $entry, AdditionalFenceLanguageSuggester it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.suggestLanguage($entry);
    }
}

