\name{MergeLabelMapFilter}
\alias{MergeLabelMapFilter}
\title{MergeLabelMapFilter}
\Rdversion{1.1}
\docType{class}
\description{
Merges several Label Maps.
MergeLabelMapFilter}
\details{
This filter takes one or more input Label Map and merges them.
SetMethod() can be used to change how the filter manage the labels from the
different label maps. KEEP (0): MergeLabelMapFilter do its best to keep the label unchanged, but if a label is already
used in a previous label map, a new label is assigned. AGGREGATE (1):
If the same label is found several times in the label maps, the label
objects with the same label are merged. PACK (2): MergeLabelMapFilter relabel all the label objects by order of processing. No conflict can
occur. STRICT (3): MergeLabelMapFilter keeps the labels unchanged and raises an exception if the same label
is found in several images.
This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
ShapeLabelObject , RelabelComponentImageFilter
MergeLabelMapFilter for the procedural interface
MergeLabelMapFilter}
%C++ includes: sitkMergeLabelMapFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4, const Image &image5):}{}
\item{Image Execute(const std::vector< Image > &images):}{
Execute the filter on the input images
}
\item{MethodType GetMethod() const:}{
Set/Get the method used to merge the label maps
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ MergeLabelMapFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetMethod(MethodType Method):}{
Set/Get the method used to merge the label maps
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~MergeLabelMapFilter():}{
Destructor
}
}
}
