\name{StatisticsImageFilter}
\alias{StatisticsImageFilter}
\title{StatisticsImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Compute min, max, variance and mean of an Image .
StatisticsImageFilter}
\details{
StatisticsImageFilter computes the minimum, maximum, sum, sum of squares, mean, variance
sigma of an image. The filter needs all of its input image. It behaves
as a filter with an input and output. Thus it can be inserted in a
pipeline with other filters and the statistics will only be recomputed
if a downstream filter changes.
This filter is automatically multi-threaded and can stream its input
when NumberOfStreamDivisions is set to more than one. Statistics are independently computed for each streamed and threaded region then
merged.
Internally a compensated summation algorithm is used for the
accumulation of intensities to improve accuracy for large images.
See:
itk::StatisticsImageFilter for the Doxygen on the original ITK class.
StatisticsImageFilter}
%C++ includes: sitkStatisticsImageFilter.h
\section{Methods}{
\describe{
\item{void Execute(const Image &image):}{
Execute the filter on the input image
}
\item{double GetMaximum() const:}{
Return the computed Maximum.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetMean() const:}{
Return the computed Mean.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetMinimum() const:}{
Return the computed Minimum.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetSigma() const:}{
Return the computed Standard Deviation.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetSum() const:}{
Return the compute Sum.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetVariance() const:}{
Return the computed Variance.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{ StatisticsImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~StatisticsImageFilter():}{
Destructor
}
}
}
