/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.common;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesCommonBuiltins;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PThreadState;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToJavaNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.common.NativeCExtSymbol;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.exception.PythonExitException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.io.PrintWriter;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.graalvm.collections.Pair;

public abstract class CExtCommonNodes {
    @CompilerDirectives.TruffleBoundary
    public static void fatalError(Node location, PythonContext context, TruffleString prefix, TruffleString msg, int status) {
        CExtCommonNodes.fatalErrorString(location, context, prefix != null ? prefix.toJavaStringUncached() : null, msg.toJavaStringUncached(), status);
    }

    @CompilerDirectives.TruffleBoundary
    public static void fatalErrorString(Node location, PythonContext context, String prefix, String msg, int status) {
        PrintWriter stderr = new PrintWriter(context.getStandardErr());
        stderr.print("Fatal Python error: ");
        if (prefix != null) {
            stderr.print(prefix);
            stderr.print(": ");
        }
        if (msg != null) {
            stderr.print(msg);
        } else {
            stderr.print("<message not set>");
        }
        stderr.println();
        stderr.flush();
        if (status < 0) {
            PosixSupportLibrary posixLib = PosixSupportLibrary.getUncached();
            PosixSupport posixSupport = context.getPosixSupport();
            posixLib.abort(posixSupport);
        }
        throw new PythonExitException(location, status);
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class EnsureExecutableNode
    extends Node {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(CExtContext.class);

        public static Object executeUncached(Object callable, NativeCExtSymbol descriptor) {
            return CExtCommonNodesFactory.EnsureExecutableNodeGen.getUncached().execute(null, callable, descriptor);
        }

        public abstract Object execute(Node var1, Object var2, NativeCExtSymbol var3);

        @Specialization(guards={"descriptor == cachedDescriptor", "withPanama(inliningTarget) == cachedWithPanama", "!isExecutable(lib, callable)"}, limit="3")
        static Object doBind(Node inliningTarget, Object callable, NativeCExtSymbol descriptor, @Cached(value="descriptor") NativeCExtSymbol cachedDescriptor, @Cached(value="withPanama(inliningTarget)") boolean cachedWithPanama, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached UnwrapForeignPointerNode unwrapForeignPointerNode, @Cached.Shared @CachedLibrary(limit="1") SignatureLibrary signatureLib, @Cached(value="createFactory(descriptor)") DirectCallNode nfiSignatureFactory) {
            Object funPtr = unwrapForeignPointerNode.execute(inliningTarget, callable);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(PythonUtils.formatJString("Binding %s (signature: %s) to NFI signature %s", callable, descriptor.getName(), descriptor.getSignature()));
            }
            return signatureLib.bind(nfiSignatureFactory.call(new Object[0]), funPtr);
        }

        @Specialization(guards={"lib.isExecutable(callable)"})
        static Object doNothing(Object callable, NativeCExtSymbol descriptor, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib) {
            return callable;
        }

        @Specialization(replaces={"doBind", "doNothing"})
        static Object doGeneric(Node inliningTarget, Object callable, NativeCExtSymbol descriptor, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached UnwrapForeignPointerNode unwrapForeignPointerNode, @Cached.Shared @CachedLibrary(limit="1") SignatureLibrary signatureLib, @Cached(inline=false) IndirectCallNode nfiSignatureFactory) {
            PythonContext pythonContext = PythonContext.get(inliningTarget);
            if (!lib.isExecutable(callable)) {
                if (!pythonContext.isNativeAccessAllowed()) {
                    LOGGER.severe(PythonUtils.formatJString("Attempting to bind %s to an NFI signature but native access is not allowed", callable));
                }
                Object funPtr = unwrapForeignPointerNode.execute(inliningTarget, callable);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(PythonUtils.formatJString("Binding %s (signature: %s) to NFI signature %s", callable, descriptor.getName(), descriptor.getSignature()));
                }
                return signatureLib.bind(nfiSignatureFactory.call(EnsureExecutableNode.getCallTarget(pythonContext, descriptor), new Object[0]), funPtr);
            }
            return callable;
        }

        private static Source getSource(PythonLanguage language, boolean panama, NativeCExtSymbol descriptor) {
            CompilerAsserts.neverPartOfCompilation();
            assert (descriptor.getSignature() != null && !descriptor.getSignature().isEmpty());
            String src = (panama ? "with panama " : "") + descriptor.getSignature();
            return language.getOrCreateSource(EnsureExecutableNode::buildNFISource, Pair.create((Object)src, (Object)descriptor.getName()));
        }

        @CompilerDirectives.TruffleBoundary
        private static CallTarget getCallTarget(PythonContext pythonContext, NativeCExtSymbol descriptor) {
            Source source = EnsureExecutableNode.getSource(pythonContext.getLanguage(), pythonContext.getOption(PythonOptions.UsePanama), descriptor);
            return pythonContext.getEnv().parseInternal(source, new String[0]);
        }

        @NeverDefault
        static DirectCallNode createFactory(NativeCExtSymbol descriptor) {
            CompilerAsserts.neverPartOfCompilation();
            return DirectCallNode.create((CallTarget)EnsureExecutableNode.getCallTarget(PythonContext.get(null), descriptor));
        }

        @NonIdempotent
        static boolean withPanama(Node inliningTarget) {
            return PythonContext.get(inliningTarget).getOption(PythonOptions.UsePanama);
        }

        @Idempotent
        static boolean isExecutable(InteropLibrary lib, Object object) {
            return lib.isExecutable(object);
        }

        private static Source buildNFISource(Object key) {
            Pair srcAndName = (Pair)key;
            return Source.newBuilder((String)"nfi", (CharSequence)((String)srcAndName.getLeft()), (String)((String)srcAndName.getRight())).internal(true).build();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class UnwrapForeignPointerNode
    extends Node {
        public abstract Object execute(Node var1, Object var2);

        @Specialization(limit="3")
        static Object doOther(Object pointerObject, @CachedLibrary(value="pointerObject") InteropLibrary lib) {
            if (lib.isPointer(pointerObject)) {
                try {
                    return new NativePointer(lib.asPointer(pointerObject));
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            assert (CApiTransitions.isBackendPointerObject(pointerObject));
            return pointerObject;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CoerceNativePointerToLongNode
    extends Node {
        public static long executeUncached(Object pointerObject) {
            return CExtCommonNodesFactory.CoerceNativePointerToLongNodeGen.getUncached().execute(null, pointerObject);
        }

        public abstract long execute(Node var1, Object var2);

        @Specialization
        static long doLong(Long l) {
            return l;
        }

        @Specialization
        static long doNativePointer(NativePointer nativePointer) {
            return nativePointer.asPointer();
        }

        @Specialization(guards={"!isNativePointer(pointerObject)"}, limit="3")
        static long doOther(Object pointerObject, @CachedLibrary(value="pointerObject") InteropLibrary lib) {
            return PythonUtils.coerceToLong(pointerObject, lib);
        }

        static boolean isNativePointer(Object pointerObject) {
            return pointerObject instanceof NativePointer;
        }
    }

    @GenerateInline(value=false)
    public static abstract class GetIndexNode
    extends Node {
        public abstract int execute(Object var1, Object var2);

        @Specialization
        static int doIt(Object self, Object indexObj, @Bind Node inliningTarget, @Cached InlinedBranchProfile indexLt0Branch, @Cached PyNumberAsSizeNode asSizeNode, @Cached TpSlotLen.CallSlotLenNode callLenNode, @Cached TpSlots.GetObjectSlotsNode getObjectSlotsNode) {
            int index = asSizeNode.executeExact(null, inliningTarget, indexObj);
            if (index < 0) {
                indexLt0Branch.enter(inliningTarget);
                TpSlots slots = getObjectSlotsNode.execute(inliningTarget, self);
                if (slots.sq_length() != null) {
                    int len = callLenNode.execute(null, inliningTarget, slots.sq_length(), self);
                    index += len;
                }
            }
            return index;
        }

        public static GetIndexNode create() {
            return CExtCommonNodesFactory.GetIndexNodeGen.create();
        }
    }

    public static abstract class AsFixedNativePrimitiveNode
    extends CExtToNativeNode {
        private final int targetTypeSize;
        private final int signed;

        protected AsFixedNativePrimitiveNode(int targetTypeSize, boolean signed) {
            this.targetTypeSize = targetTypeSize;
            this.signed = PInt.intValue(signed);
        }

        @Specialization
        Object doGeneric(Object value, @Cached AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(value, this.signed, this.targetTypeSize, true);
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class AsNativeCharNode
    extends CExtToNativeNode {
        public abstract byte executeByte(Object var1);

        @Specialization
        static byte doGeneric(Object value, @Bind Node inliningTarget, @Cached EncodeNativeStringNode encodeNativeStringNode, @Cached PRaiseNode raiseNode) {
            byte[] encoded = encodeNativeStringNode.execute(StandardCharsets.UTF_8, value, StringLiterals.T_STRICT);
            if (encoded.length != 1) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
            }
            return encoded[0];
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class NativeUnsignedPrimitiveAsPythonObjectNode
    extends CExtToJavaNode {
        @Specialization(guards={"n >= 0"})
        static int doUnsignedIntPositive(int n) {
            return n;
        }

        @Specialization(replaces={"doUnsignedIntPositive"})
        static long doUnsignedInt(int n) {
            if (n < 0) {
                return (long)n & 0xFFFFFFFFL;
            }
            return n;
        }

        @Specialization(guards={"n >= 0"})
        static long doUnsignedLongPositive(long n) {
            return n;
        }

        @Specialization(guards={"n < 0"})
        static Object doUnsignedLongNegative(long n, @Bind PythonLanguage language) {
            return PFactory.createInt(language, PInt.longToUnsignedBigInteger(n));
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class NativeUnsignedShortNode
    extends CExtToJavaNode {
        @Specialization
        static int doUnsignedIntPositive(int n) {
            return n & 0xFFFF;
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class NativeUnsignedByteNode
    extends CExtToJavaNode {
        @Specialization
        static int doUnsignedIntPositive(int n) {
            return n & 0xFF;
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class NativePrimitiveAsPythonCharNode
    extends CExtToJavaNode {
        @Specialization
        static TruffleString doByte(byte b, @Cached.Shared(value="fromInt") @Cached TruffleString.FromIntArrayUTF32Node fromIntArrayNode, @Cached.Shared(value="switchEnc") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            return switchEncodingNode.execute((AbstractTruffleString)fromIntArrayNode.execute(new int[]{b}), PythonUtils.TS_ENCODING);
        }

        @Specialization
        static TruffleString doShort(short i, @Cached.Shared(value="fromInt") @Cached TruffleString.FromIntArrayUTF32Node fromIntArrayNode, @Cached.Shared(value="switchEnc") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            return switchEncodingNode.execute((AbstractTruffleString)fromIntArrayNode.execute(new int[]{i}, 0, 1), PythonUtils.TS_ENCODING);
        }

        @Specialization
        static TruffleString doLong(long l, @Cached TruffleString.FromLongNode fromLongNode) {
            return fromLongNode.execute(l, PythonUtils.TS_ENCODING, true);
        }

        @Specialization(replaces={"doByte", "doShort", "doLong"}, limit="1")
        static Object doGeneric(Object n, @CachedLibrary(value="n") InteropLibrary lib, @Cached.Shared(value="fromInt") @Cached TruffleString.FromIntArrayUTF32Node fromIntArrayNode, @Cached.Shared(value="switchEnc") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            if (lib.fitsInShort(n)) {
                try {
                    return switchEncodingNode.execute((AbstractTruffleString)fromIntArrayNode.execute(new int[]{lib.asShort(n)}, 0, 1), PythonUtils.TS_ENCODING);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class NativePrimitiveAsPythonBooleanNode
    extends CExtToJavaNode {
        @Specialization
        static Boolean doBoolean(Boolean b) {
            return b;
        }

        @Specialization
        static Object doByte(byte b) {
            return b != 0;
        }

        @Specialization
        static Object doShort(short i) {
            return i != 0;
        }

        @Specialization
        static Object doLong(long l) {
            return l != 0L;
        }

        @Specialization(replaces={"doBoolean", "doByte", "doShort", "doLong"}, limit="1")
        static Object doGeneric(Object n, @CachedLibrary(value="n") InteropLibrary lib) {
            if (lib.fitsInLong(n)) {
                try {
                    return lib.asLong(n) != 0L;
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class StringAsPythonStringNode
    extends CExtToJavaNode {
        @Specialization
        static TruffleString doJavaString(String value, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(value, PythonUtils.TS_ENCODING);
        }

        @Specialization
        static TruffleString doTruffleString(TruffleString value) {
            return value;
        }

        @Specialization(guards={"interopLib.isNull(value)"}, limit="3")
        static Object doGeneric(Object value, @CachedLibrary(value="value") InteropLibrary interopLib) {
            return PNone.NONE;
        }

        @Specialization
        static TruffleString doNative(Object value, @Cached CExtNodes.FromCharPointerNode fromPtr) {
            return fromPtr.execute(value);
        }
    }

    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    @GenerateInline(value=false)
    public static abstract class AsNativePrimitiveNode
    extends Node {
        public final int toInt32(Object value, boolean exact) {
            return (Integer)this.execute(value, 1, 4, exact);
        }

        public final int toUInt32(Object value, boolean exact) {
            return (Integer)this.execute(value, 0, 4, exact);
        }

        public final long toInt64(Object value, boolean exact) {
            return (Long)this.execute(value, 1, 8, exact);
        }

        public final long toUInt64(Object value, boolean exact) {
            return (Long)this.execute(value, 0, 8, exact);
        }

        public abstract Object execute(byte var1, int var2, int var3, boolean var4);

        public abstract Object execute(int var1, int var2, int var3, boolean var4);

        public abstract Object execute(long var1, int var3, int var4, boolean var5);

        public abstract Object execute(Object var1, int var2, int var3, boolean var4);

        @Specialization(guards={"targetTypeSize == 4", "signed != 0"})
        static int doIntToInt32(int value, int signed, int targetTypeSize, boolean exact) {
            return value;
        }

        @Specialization(guards={"targetTypeSize == 4", "signed == 0", "value >= 0"})
        static int doIntToUInt32Pos(int value, int signed, int targetTypeSize, boolean exact) {
            return value;
        }

        @Specialization(guards={"targetTypeSize == 4", "signed == 0"}, replaces={"doIntToUInt32Pos"})
        static int doIntToUInt32(int value, int signed, int targetTypeSize, boolean exact, @Bind Node inliningTarget, @Cached.Shared(value="raiseNativeNode") @Cached PRaiseNode raiseNativeNode) {
            if (exact && value < 0) {
                throw AsNativePrimitiveNode.raiseNegativeValue(inliningTarget, raiseNativeNode);
            }
            return value;
        }

        @Specialization(guards={"targetTypeSize == 8", "signed != 0"})
        static long doIntToInt64(int obj, int signed, int targetTypeSize, boolean exact) {
            return obj;
        }

        @Specialization(guards={"targetTypeSize == 8", "signed == 0", "value >= 0"})
        static long doIntToUInt64Pos(int value, int signed, int targetTypeSize, boolean exact) {
            return value;
        }

        @Specialization(guards={"targetTypeSize == 8", "signed == 0"}, replaces={"doIntToUInt64Pos"})
        static long doIntToUInt64(int value, int signed, int targetTypeSize, boolean exact, @Bind Node inliningTarget, @Cached.Shared(value="raiseNativeNode") @Cached PRaiseNode raiseNativeNode) {
            if (exact && value < 0) {
                throw AsNativePrimitiveNode.raiseNegativeValue(inliningTarget, raiseNativeNode);
            }
            return value;
        }

        @Specialization(guards={"targetTypeSize == 8", "signed != 0"})
        static long doLongToInt64(long value, int signed, int targetTypeSize, boolean exact) {
            return value;
        }

        @Specialization(guards={"targetTypeSize == 8", "signed == 0", "value >= 0"})
        static long doLongToUInt64Pos(long value, int signed, int targetTypeSize, boolean exact) {
            return value;
        }

        @Specialization(guards={"targetTypeSize == 8", "signed == 0"}, replaces={"doLongToUInt64Pos"})
        static long doLongToUInt64(long value, int signed, int targetTypeSize, boolean exact, @Bind Node inliningTarget, @Cached.Shared(value="raiseNativeNode") @Cached PRaiseNode raiseNativeNode) {
            if (exact && value < 0L) {
                throw AsNativePrimitiveNode.raiseNegativeValue(inliningTarget, raiseNativeNode);
            }
            return value;
        }

        @Specialization(guards={"exact", "targetTypeSize == 4", "signed != 0"})
        static int doLongToInt32Exact(long obj, int signed, int targetTypeSize, boolean exact, @Bind Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                return PInt.intValueExact(obj);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO_C_TYPE, targetTypeSize);
            }
        }

        @Specialization(guards={"exact", "targetTypeSize == 4", "signed == 0", "obj >= 0"})
        static int doLongToUInt32PosExact(long obj, int signed, int targetTypeSize, boolean exact, @Bind Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            if (Integer.toUnsignedLong((int)obj) == obj) {
                return (int)obj;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO_C_TYPE, targetTypeSize);
        }

        @Specialization(guards={"exact", "targetTypeSize == 4", "signed == 0"}, replaces={"doLongToUInt32PosExact"})
        static int doLongToUInt32Exact(long obj, int signed, int targetTypeSize, boolean exact, @Bind Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            if (obj < 0L) {
                throw AsNativePrimitiveNode.raiseNegativeValue(inliningTarget, raiseNode);
            }
            return AsNativePrimitiveNode.doLongToUInt32PosExact(obj, signed, targetTypeSize, exact, inliningTarget, raiseNode);
        }

        @Specialization(guards={"!exact", "targetTypeSize == 4"})
        static int doLongToInt32Lossy(long obj, int signed, int targetTypeSize, boolean exact) {
            return (int)obj;
        }

        @Specialization(guards={"targetTypeSize == 8"})
        static Object doVoidPtrToI64(PythonNativeVoidPtr obj, int signed, int targetTypeSize, boolean exact) {
            return obj;
        }

        @Specialization(guards={"exact", "targetTypeSize == 4"})
        @CompilerDirectives.TruffleBoundary
        static int doPIntTo32Bit(PInt obj, int signed, int targetTypeSize, boolean exact, @Bind Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                if (signed != 0) {
                    return obj.intValueExact();
                }
                if (obj.bitLength() <= 32) {
                    if (obj.isNegative()) {
                        throw AsNativePrimitiveNode.raiseNegativeValue(inliningTarget, raiseNode);
                    }
                    return obj.intValue();
                }
            }
            catch (OverflowException overflowException) {
                // empty catch block
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO_C_TYPE, targetTypeSize);
        }

        @Specialization(guards={"exact", "targetTypeSize == 8"})
        @CompilerDirectives.TruffleBoundary
        static long doPIntTo64Bit(PInt obj, int signed, int targetTypeSize, boolean exact, @Bind Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                if (signed != 0) {
                    return obj.longValueExact();
                }
                if (obj.bitLength() <= 64) {
                    if (obj.isNegative()) {
                        throw AsNativePrimitiveNode.raiseNegativeValue(inliningTarget, raiseNode);
                    }
                    return obj.longValue();
                }
            }
            catch (OverflowException overflowException) {
                // empty catch block
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO_C_TYPE, targetTypeSize);
        }

        @Specialization(guards={"!exact", "targetTypeSize == 4"})
        static int doPIntToInt32Lossy(PInt obj, int signed, int targetTypeSize, boolean exact) {
            return obj.intValue();
        }

        @Specialization(guards={"!exact", "targetTypeSize == 8"})
        static long doPIntToInt64Lossy(PInt obj, int signed, int targetTypeSize, boolean exact) {
            return obj.longValue();
        }

        @Specialization(guards={"targetTypeSize == 4 || targetTypeSize == 8"}, replaces={"doIntToInt32", "doIntToUInt32Pos", "doIntToUInt32", "doIntToInt64", "doIntToUInt64Pos", "doIntToUInt64", "doLongToInt64", "doLongToUInt64Pos", "doLongToUInt64", "doLongToInt32Exact", "doLongToUInt32PosExact", "doLongToUInt32Exact", "doLongToInt32Lossy", "doVoidPtrToI64", "doPIntTo32Bit", "doPIntTo64Bit", "doPIntToInt32Lossy", "doPIntToInt64Lossy"})
        static Object doGeneric(Object obj, int signed, int targetTypeSize, boolean exact, @Bind Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object result = indexNode.execute(null, inliningTarget, obj);
            if (targetTypeSize == 4) {
                return AsNativePrimitiveNode.toInt32(inliningTarget, result, signed, exact, raiseNode);
            }
            if (targetTypeSize == 8) {
                return AsNativePrimitiveNode.toInt64(inliningTarget, result, signed, exact, raiseNode);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.SystemError, ErrorMessages.UNSUPPORTED_TARGET_SIZE, targetTypeSize);
        }

        @Specialization(guards={"targetTypeSize != 4", "targetTypeSize != 8"})
        static int doUnsupportedTargetSize(Object obj, int signed, int targetTypeSize, boolean exact, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.SystemError, ErrorMessages.UNSUPPORTED_TARGET_SIZE, targetTypeSize);
        }

        private static PException raiseNegativeValue(Node inliningTarget, PRaiseNode raiseNativeNode) {
            throw raiseNativeNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.CANNOT_CONVERT_NEGATIVE_VALUE_TO_UNSIGNED_INT);
        }

        private static int toInt32(Node inliningTarget, Object object, int signed, boolean exact, PRaiseNode raiseNode) {
            if (object instanceof Integer) {
                int ival = (Integer)object;
                if (signed != 0) {
                    return ival;
                }
                return AsNativePrimitiveNode.doIntToUInt32(ival, signed, 4, exact, inliningTarget, raiseNode);
            }
            if (object instanceof Long) {
                long lval = (Long)object;
                if (exact) {
                    if (signed != 0) {
                        return AsNativePrimitiveNode.doLongToInt32Exact(lval, 1, 4, true, inliningTarget, raiseNode);
                    }
                    return AsNativePrimitiveNode.doLongToUInt32Exact(lval, signed, 4, true, inliningTarget, raiseNode);
                }
                return AsNativePrimitiveNode.doLongToInt32Lossy(lval, 0, 4, false);
            }
            if (object instanceof PInt) {
                PInt pval = (PInt)object;
                if (exact) {
                    return AsNativePrimitiveNode.doPIntTo32Bit(pval, signed, 4, true, inliningTarget, raiseNode);
                }
                return AsNativePrimitiveNode.doPIntToInt32Lossy(pval, signed, 4, false);
            }
            if (object instanceof PythonNativeVoidPtr) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO_C_TYPE, 4);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.INDEX_RETURNED_NON_INT, object);
        }

        private static Object toInt64(Node inliningTarget, Object object, int signed, boolean exact, PRaiseNode raiseNode) {
            if (object instanceof Integer) {
                Integer ival = (Integer)object;
                if (signed != 0) {
                    return ival.longValue();
                }
                return AsNativePrimitiveNode.doIntToUInt64(ival, signed, 8, exact, inliningTarget, raiseNode);
            }
            if (object instanceof Long) {
                long lval = (Long)object;
                if (signed != 0) {
                    return AsNativePrimitiveNode.doLongToInt64(lval, 1, 8, exact);
                }
                return AsNativePrimitiveNode.doLongToUInt64(lval, signed, 8, exact, inliningTarget, raiseNode);
            }
            if (object instanceof PInt) {
                PInt pval = (PInt)object;
                if (exact) {
                    return AsNativePrimitiveNode.doPIntTo64Bit(pval, signed, 8, true, inliningTarget, raiseNode);
                }
                return AsNativePrimitiveNode.doPIntToInt64Lossy(pval, signed, 8, false);
            }
            if (object instanceof PythonNativeVoidPtr) {
                return AsNativePrimitiveNode.doVoidPtrToI64((PythonNativeVoidPtr)object, signed, 8, exact);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.INDEX_RETURNED_NON_INT, object);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class GetByteArrayNode
    extends Node {
        public abstract byte[] execute(Node var1, Object var2, long var3) throws InteropException, OverflowException;

        @Specialization
        static byte[] doCArrayWrapper(CArrayWrappers.CByteArrayWrapper obj, long n) {
            return GetByteArrayNode.subRangeIfNeeded(obj.getByteArray(), n);
        }

        @Specialization
        static byte[] doForeign(Object obj, long n, @Cached(inline=false) CStructAccess.ReadByteNode readNode) {
            return readNode.readByteArray(obj, (int)n);
        }

        private static byte[] subRangeIfNeeded(byte[] bytes, long n) {
            if ((long)bytes.length > n && n >= 0L) {
                return PythonUtils.arrayCopyOf(bytes, (int)n);
            }
            return bytes;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class TransformExceptionFromNativeNode
    extends Node {
        public abstract void execute(Node var1, PythonContext.PythonThreadState var2, TruffleString var3, boolean var4, boolean var5, TruffleString var6, TruffleString var7);

        public final void execute(Node inliningTarget, PythonContext.PythonThreadState threadState, TruffleString name, boolean indicatesError, boolean strict) {
            this.execute(inliningTarget, threadState, name, indicatesError, strict, ErrorMessages.RETURNED_NULL_WO_SETTING_EXCEPTION, ErrorMessages.RETURNED_RESULT_WITH_EXCEPTION_SET);
        }

        public final void reraise(Node inliningTarget, PythonContext.PythonThreadState threadState) {
            this.execute(inliningTarget, threadState, null, true, true, null, null);
        }

        @Specialization
        static void doGeneric(Node inliningTarget, PythonContext.PythonThreadState threadState, TruffleString name, boolean indicatesError, boolean strict, TruffleString nullButNoErrorMessage, TruffleString resultWithErrorMessage, @Cached InlinedConditionProfile errOccurredProfile, @Cached InlinedConditionProfile indicatesErrorProfile, @Cached ReadAndClearNativeException readAndClearNativeException) {
            Object currentException = readAndClearNativeException.execute(inliningTarget, threadState);
            boolean errOccurred = errOccurredProfile.profile(inliningTarget, currentException != PNone.NO_VALUE);
            boolean indicatesErrorProfiled = indicatesErrorProfile.profile(inliningTarget, indicatesError);
            if (indicatesErrorProfiled || errOccurred) {
                TransformExceptionFromNativeNode.checkFunctionResultSlowpath(inliningTarget, name, indicatesErrorProfiled, strict, nullButNoErrorMessage, resultWithErrorMessage, errOccurred, currentException);
            }
        }

        @HostCompilerDirectives.InliningCutoff
        private static void checkFunctionResultSlowpath(Node inliningTarget, TruffleString name, boolean indicatesError, boolean strict, TruffleString nullButNoErrorMessage, TruffleString resultWithErrorMessage, boolean errOccurred, Object currentException) {
            if (indicatesError) {
                if (errOccurred) {
                    assert (currentException != PNone.NO_VALUE);
                    throw PException.fromObject(currentException, inliningTarget, false);
                }
                if (strict) {
                    assert (currentException == PNone.NO_VALUE);
                    throw TransformExceptionFromNativeNode.raiseNullButNoError(inliningTarget, name, nullButNoErrorMessage);
                }
            } else if (errOccurred) {
                assert (currentException != null);
                throw TransformExceptionFromNativeNode.raiseResultWithError(inliningTarget, name, currentException, resultWithErrorMessage);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static PException raiseNullButNoError(Node node, TruffleString name, TruffleString nullButNoErrorMessage) {
            throw PRaiseNode.raiseStatic(node, PythonErrorType.SystemError, nullButNoErrorMessage, name);
        }

        @CompilerDirectives.TruffleBoundary
        private static PException raiseResultWithError(Node node, TruffleString name, Object currentException, TruffleString resultWithErrorMessage) {
            PythonLanguage language = PythonLanguage.get(null);
            PBaseException sysExc = PFactory.createBaseException(language, PythonErrorType.SystemError, resultWithErrorMessage, new Object[]{name});
            sysExc.setCause(currentException);
            throw PRaiseNode.raiseExceptionObjectStatic(node, (Object)sysExc, PythonOptions.isPExceptionWithJavaStacktrace(language));
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ReadAndClearNativeException
    extends Node {
        public abstract Object execute(Node var1, PythonContext.PythonThreadState var2);

        public static Object executeUncached(PythonContext.PythonThreadState threadState) {
            return CExtCommonNodesFactory.ReadAndClearNativeExceptionNodeGen.getUncached().execute(null, threadState);
        }

        @Specialization
        static Object getException(PythonContext.PythonThreadState threadState, @Cached(inline=false) CStructAccess.ReadPointerNode readPointerNode, @Cached(inline=false) CStructAccess.WritePointerNode writePointerNode, @Cached CApiTransitions.NativeToPythonTransferNode nativeToPythonNode) {
            Object nativeThreadState = PThreadState.getNativeThreadState(threadState);
            if (nativeThreadState != null) {
                Object exception = nativeToPythonNode.execute(readPointerNode.read(nativeThreadState, CFields.PyThreadState__current_exception));
                writePointerNode.write(nativeThreadState, CFields.PyThreadState__current_exception, 0L);
                return exception;
            }
            return PNone.NO_VALUE;
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @GenerateUncached
    public static abstract class TransformExceptionToNativeNode
    extends Node {
        public abstract void execute(Node var1, Object var2);

        public final void execute(Node inliningTarget, PException e) {
            this.execute(inliningTarget, e.getEscapedException());
        }

        public final void executeCached(PException e) {
            this.execute((Node)this, e.getEscapedException());
        }

        public static void executeUncached(Object pythonException) {
            CExtCommonNodesFactory.TransformExceptionToNativeNodeGen.getUncached().execute(null, pythonException);
        }

        public static void executeUncached(PException e) {
            CExtCommonNodesFactory.TransformExceptionToNativeNodeGen.getUncached().execute(null, e.getEscapedException());
        }

        @Specialization
        static void setCurrentException(Node inliningTarget, Object pythonException, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached CExtNodes.XDecRefPointerNode decRefPointerNode, @Cached(inline=false) CApiTransitions.PythonToNativeNewRefNode pythonToNativeNode, @Cached(inline=false) CStructAccess.ReadPointerNode readPointerNode, @Cached(inline=false) CStructAccess.WritePointerNode writePointerNode) {
            Object currentException = pythonToNativeNode.execute(pythonException);
            Object nativeThreadState = PThreadState.getOrCreateNativeThreadState(getThreadStateNode.execute(inliningTarget));
            Object oldException = readPointerNode.read(nativeThreadState, CFields.PyThreadState__current_exception);
            writePointerNode.write(nativeThreadState, CFields.PyThreadState__current_exception, currentException);
            decRefPointerNode.execute(inliningTarget, oldException);
        }
    }

    public static abstract class CheckFunctionResultNode
    extends PNodeWithContext {
        public final Object execute(PythonContext context, TruffleString name, Object result) {
            PythonLanguage language = context.getLanguage(this);
            return this.execute(context.getThreadState(language), name, result);
        }

        public abstract Object execute(PythonContext.PythonThreadState var1, TruffleString var2, Object var3);
    }

    @GenerateInline(value=false)
    @GenerateUncached
    @ImportStatic(value={SpecialMethodNames.class, CApiGuards.class})
    public static abstract class AsNativeDoubleNode
    extends CExtToNativeNode {
        public abstract double executeDouble(Object var1);

        @Specialization(guards={"!isNativeWrapper(value)"})
        static double runGeneric(Object value, @Bind Node inliningTarget, @Cached PyFloatAsDoubleNode asDoubleNode) {
            return asDoubleNode.execute(null, inliningTarget, value);
        }

        @Specialization(guards={"!object.isDouble()"})
        static double doLongNativeWrapper(PrimitiveNativeWrapper object) {
            return object.getLong();
        }

        @Specialization(guards={"object.isDouble()"})
        static double doDoubleNativeWrapper(PrimitiveNativeWrapper object) {
            return object.getDouble();
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @GenerateUncached
    @ImportStatic(value={PGuards.class, CApiGuards.class})
    public static abstract class ConvertPIntToPrimitiveNode
    extends Node {
        public abstract Object execute(Node var1, Object var2, int var3, int var4, boolean var5);

        public final Object execute(Node inliningTarget, Object o, int signed, int targetTypeSize) {
            return this.execute(inliningTarget, o, signed, targetTypeSize, true);
        }

        public final long executeLongCached(Object o, int signed, int targetTypeSize, boolean exact) throws UnexpectedResultException {
            return PGuards.expectLong(this.execute(this, o, signed, targetTypeSize, exact));
        }

        public final int executeIntCached(Object o, int signed, int targetTypeSize, boolean exact) throws UnexpectedResultException {
            return PGuards.expectInteger(this.execute(this, o, signed, targetTypeSize, exact));
        }

        public final long executeLongCached(Object o, int signed, int targetTypeSize) throws UnexpectedResultException {
            return PGuards.expectLong(this.execute(this, o, signed, targetTypeSize, true));
        }

        public final int executeIntCached(Object o, int signed, int targetTypeSize) throws UnexpectedResultException {
            return PGuards.expectInteger(this.execute(this, o, signed, targetTypeSize, true));
        }

        @Specialization(guards={"targetTypeSize == 4", "signed != 0", "fitsInInt32(nativeWrapper)"})
        static int doWrapperToInt32(PrimitiveNativeWrapper nativeWrapper, int signed, int targetTypeSize, boolean exact) {
            return nativeWrapper.getInt();
        }

        @Specialization(guards={"targetTypeSize == 4", "signed == 0", "fitsInUInt32(nativeWrapper)"})
        static int doWrapperToUInt32Pos(PrimitiveNativeWrapper nativeWrapper, int signed, int targetTypeSize, boolean exact) {
            return nativeWrapper.getInt();
        }

        @Specialization(guards={"targetTypeSize == 8", "signed != 0", "fitsInInt64(nativeWrapper)"})
        static long doWrapperToInt64(PrimitiveNativeWrapper nativeWrapper, int signed, int targetTypeSize, boolean exact) {
            return nativeWrapper.getLong();
        }

        @Specialization(guards={"targetTypeSize == 8", "signed == 0", "fitsInUInt64(nativeWrapper)"})
        static long doWrapperToUInt64Pos(PrimitiveNativeWrapper nativeWrapper, int signed, int targetTypeSize, boolean exact) {
            return nativeWrapper.getLong();
        }

        @Specialization
        static Object doWrapperGeneric(PrimitiveNativeWrapper nativeWrapper, int signed, int targetTypeSize, boolean exact, @Cached.Shared @Cached(inline=false) AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(nativeWrapper.getLong(), signed, targetTypeSize, exact);
        }

        @Specialization
        static Object doInt(int value, int signed, int targetTypeSize, boolean exact, @Cached.Shared @Cached(inline=false) AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(value, signed, targetTypeSize, exact);
        }

        @Specialization
        static Object doLong(long value, int signed, int targetTypeSize, boolean exact, @Cached.Shared @Cached(inline=false) AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(value, signed, targetTypeSize, exact);
        }

        @Specialization(guards={"!isPrimitiveNativeWrapper(obj)"}, replaces={"doInt", "doLong"})
        static Object doOther(Object obj, int signed, int targetTypeSize, boolean exact, @Cached.Shared @Cached(inline=false) AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(obj, signed, targetTypeSize, exact);
        }

        static boolean fitsInInt32(PrimitiveNativeWrapper nativeWrapper) {
            return nativeWrapper.isBool() || nativeWrapper.isInt();
        }

        static boolean fitsInInt64(PrimitiveNativeWrapper nativeWrapper) {
            return nativeWrapper.isIntLike() || nativeWrapper.isBool();
        }

        static boolean fitsInUInt32(PrimitiveNativeWrapper nativeWrapper) {
            return (nativeWrapper.isBool() || nativeWrapper.isInt()) && nativeWrapper.getInt() >= 0;
        }

        static boolean fitsInUInt64(PrimitiveNativeWrapper nativeWrapper) {
            return (nativeWrapper.isIntLike() || nativeWrapper.isBool()) && nativeWrapper.getLong() >= 0L;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={CApiGuards.class})
    public static abstract class ReadUnicodeArrayNode
    extends PNodeWithContext {
        public abstract int[] execute(Node var1, Object var2, int var3, int var4);

        public static int[] executeUncached(Object array, int length, int elementSize) {
            return CExtCommonNodesFactory.ReadUnicodeArrayNodeGen.getUncached().execute(null, array, length, elementSize);
        }

        @Specialization(guards={"elementSize == 1"})
        static int[] read1(Node inliningTarget, Object array, int length, int elementSize, @Cached.Shared @Cached InlinedConditionProfile calcLength, @Cached(inline=false) CStructAccess.ReadByteNode read) {
            int len = length;
            if (calcLength.profile(inliningTarget, len == -1)) {
                while (read.readArrayElement(array, ++len) != 0) {
                }
            }
            int[] result = new int[len];
            for (int i = 0; i < len; ++i) {
                result[i] = read.readArrayElement(array, i) & 0xFF;
            }
            return result;
        }

        @Specialization(guards={"elementSize == 2"})
        static int[] read2(Node inliningTarget, Object array, int length, int elementSize, @Cached.Shared @Cached InlinedConditionProfile calcLength, @Cached(inline=false) CStructAccess.ReadI16Node read) {
            int len = length;
            if (calcLength.profile(inliningTarget, len == -1)) {
                while (read.readArrayElement(array, ++len) != 0) {
                }
            }
            int[] result = new int[len];
            for (int i = 0; i < len; ++i) {
                result[i] = read.readArrayElement(array, i) & 0xFFFF;
            }
            return result;
        }

        @Specialization(guards={"elementSize == 4"})
        static int[] read4(Node inliningTarget, Object array, int length, int elementSize, @Cached.Shared @Cached InlinedConditionProfile calcLength, @Cached(inline=false) CStructAccess.ReadI32Node read) {
            int len = length;
            if (calcLength.profile(inliningTarget, len == -1)) {
                while (read.readArrayElement(array, ++len) != 0) {
                }
            }
            int[] result = new int[len];
            for (int i = 0; i < len; ++i) {
                result[i] = read.readArrayElement(array, i);
            }
            return result;
        }
    }

    public static abstract class Charsets {
        private static final int NATIVE_ORDER = 0;
        private static Charset UTF32;
        private static Charset UTF32LE;
        private static Charset UTF32BE;
        private static final TruffleString T_UTF_32;
        private static final TruffleString T_UTF_32LE;
        private static final TruffleString T_UTF_32BE;

        @CompilerDirectives.TruffleBoundary
        public static Charset getUTF32Charset(int byteorder) {
            String utf32Name = Charsets.getUTF32Name(byteorder).toJavaStringUncached();
            if (byteorder == 0) {
                if (UTF32 == null) {
                    UTF32 = Charset.forName(utf32Name);
                }
                return UTF32;
            }
            if (byteorder < 0) {
                if (UTF32LE == null) {
                    UTF32LE = Charset.forName(utf32Name);
                }
                return UTF32LE;
            }
            if (UTF32BE == null) {
                UTF32BE = Charset.forName(utf32Name);
            }
            return UTF32BE;
        }

        public static TruffleString getUTF32Name(int byteorder) {
            TruffleString csName = byteorder == 0 ? T_UTF_32 : (byteorder < 0 ? T_UTF_32LE : T_UTF_32BE);
            return csName;
        }

        static {
            T_UTF_32 = PythonUtils.tsLiteral("UTF-32");
            T_UTF_32LE = PythonUtils.tsLiteral("UTF-32LE");
            T_UTF_32BE = PythonUtils.tsLiteral("UTF-32BE");
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class EncodeNativeStringNode
    extends PNodeWithContext {
        public abstract byte[] execute(Charset var1, Object var2, TruffleString var3);

        @Specialization
        static byte[] doGeneric(Charset charset, Object unicodeObject, TruffleString errors, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached TruffleString.EqualNode eqNode, @Cached PRaiseNode raiseNode) {
            TruffleString str;
            try {
                str = castToTruffleStringNode.execute(inliningTarget, unicodeObject);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_MUST_BE_S_NOT_P, "argument", "a string", unicodeObject);
            }
            try {
                CodingErrorAction action = BytesCommonBuiltins.toCodingErrorAction(inliningTarget, errors, raiseNode, eqNode);
                return BytesCommonBuiltins.doEncode(charset, str, action);
            }
            catch (CharacterCodingException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.UnicodeEncodeError, ErrorMessages.M, e);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class EnsureTruffleStringNode
    extends Node {
        public abstract Object execute(Node var1, Object var2);

        @Specialization
        static TruffleString doString(String s, @Cached(inline=false) TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(s, PythonUtils.TS_ENCODING);
        }

        @Fallback
        static Object doObj(Object o) {
            return o;
        }
    }
}

