/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTracker;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerBitSetWithOffset;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerData;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerList;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerLong;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerLong2;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerTrivialAlwaysReEnter;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerTrivialNeverReEnter;
import java.util.ArrayList;

public class RegressionModeCounterTracker
extends CounterTracker {
    private final ArrayList<CounterTracker> trackers = new ArrayList(5);
    private final int min;

    public RegressionModeCounterTracker(int min, int max, int numberOfCells, boolean isTrivialAlwaysReEnter, boolean isTrivialNeverReEnter, CounterTrackerData.Builder dataBuilder) {
        this.min = min;
        int upperBound = Math.max(min, max);
        if (upperBound <= 64) {
            this.trackers.add(new CounterTrackerLong(min, max, numberOfCells, dataBuilder));
        }
        if (upperBound <= 128) {
            this.trackers.add(new CounterTrackerLong2(min, max, numberOfCells, dataBuilder));
        }
        if (upperBound <= 1024) {
            this.trackers.add(new CounterTrackerBitSetWithOffset(min, max, numberOfCells, dataBuilder));
        }
        if (isTrivialAlwaysReEnter) {
            this.trackers.add(new CounterTrackerTrivialAlwaysReEnter(min, numberOfCells, dataBuilder));
        }
        if (isTrivialNeverReEnter) {
            this.trackers.add(new CounterTrackerTrivialNeverReEnter(min, max, numberOfCells, dataBuilder));
        }
        this.trackers.add(new CounterTrackerList(min, max, numberOfCells, dataBuilder));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected boolean anyLtMax(int sId, long[] fixedData, int[][] intArrays) {
        boolean result = this.onAll(sId, fixedData, intArrays, CounterTracker::anyLtMax);
        this.ensureConsistency(sId, fixedData, intArrays);
        return result;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected boolean anyLtMin(int sId, long[] fixedData, int[][] intArrays) {
        boolean result = this.onAll(sId, fixedData, intArrays, CounterTracker::anyLtMin);
        this.ensureConsistency(sId, fixedData, intArrays);
        return result;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected boolean anyGeMin(int sId, long[] fixedData, int[][] intArrays) {
        boolean result = this.onAll(sId, fixedData, intArrays, CounterTracker::anyGeMin);
        this.ensureConsistency(sId, fixedData, intArrays);
        return result;
    }

    private boolean onAll(int sId, long[] fixedData, int[][] intArrays, TrackerGuard f) {
        CounterTracker firstTracker = this.trackers.get(0);
        boolean resultFirst = f.apply(firstTracker, sId, fixedData, intArrays);
        for (CounterTracker tracker : this.trackers) {
            boolean resultCur = f.apply(tracker, sId, fixedData, intArrays);
            if (resultCur != resultFirst) {
                throw new AssertionError((Object)String.format("Inconsistent tracker results, firstTracker: %b, state: %s cur tracker: %b, state: %s", resultFirst, firstTracker.dumpState(sId, fixedData, intArrays), resultCur, tracker.dumpState(sId, fixedData, intArrays)));
            }
        }
        return resultFirst;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void apply(long operation, long[] fixedData, int[][] intArrays) {
        for (CounterTracker tracker : this.trackers) {
            tracker.apply(operation, fixedData, intArrays);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void init(long[] fixedData, int[][] intArrays) {
        for (CounterTracker tracker : this.trackers) {
            tracker.init(fixedData, intArrays);
        }
    }

    private void ensureConsistency(int sId, long[] fixedData, int[][] intArrays) {
        this.onAll(sId, fixedData, intArrays, CounterTracker::anyLtMax);
        if (this.min > 0) {
            this.onAll(sId, fixedData, intArrays, CounterTracker::anyGeMin);
            this.onAll(sId, fixedData, intArrays, CounterTracker::anyLtMin);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean support(long operation) {
        this.trackers.removeIf(tracker -> !tracker.support(operation));
        return !this.trackers.isEmpty();
    }

    @Override
    public String dumpState(int sId, long[] fixedData, int[][] intArrays) {
        throw new UnsupportedOperationException();
    }

    @FunctionalInterface
    static interface TrackerGuard {
        public boolean apply(CounterTracker var1, int var2, long[] var3, int[][] var4);
    }
}

