/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.VarnumBinder;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;

class BooleanBinder
extends VarnumBinder {
    int paramVal;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    BooleanBinder(int x2) {
        this.paramVal = x2;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        byte[] b2 = null;
        int offset = 0;
        if (bindUseDBA) {
            b2 = stmt.connection.methodTempLittleByteBuffer;
        } else {
            b2 = bindBytes;
            offset = byteoffset + 1;
        }
        int val = this.paramVal;
        int len = this.getDatumBytes(stmt, val, b2, offset);
        bindIndicators[indoffset] = 0;
        bindIndicators[lenoffset] = (short)(len + 1);
        if (bindUseDBA) {
            long pos;
            bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
            stmt.lastBoundDataOffsets[bindPosition] = pos;
            bindDataLengths[bindDataIndex] = len;
            stmt.lastBoundDataLengths[bindPosition] = len;
            bindData.put(b2, 0, len);
        } else {
            b2[byteoffset] = (byte)len;
        }
        return localCheckSum;
    }

    private int getDatumBytes(OraclePreparedStatement stmt, int val, byte[] b2, int offset) throws SQLException {
        int len = 0;
        if (val != 0) {
            b2[offset] = -63;
            b2[offset + 1] = 2;
            len = 2;
        } else {
            b2[offset] = -128;
            len = 1;
        }
        return len;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        byte[] b2 = stmt.connection.methodTempLittleByteBuffer;
        int len = this.getDatumBytes(stmt, this.paramVal, b2, 0);
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, Arrays.copyOf(b2, len), internalType, null, 0);
    }

    static {
        try {
            $$$methodRef$$$3 = BooleanBinder.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = BooleanBinder.class.getDeclaredMethod("getDatum", OraclePreparedStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = BooleanBinder.class.getDeclaredMethod("getDatumBytes", OraclePreparedStatement.class, Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = BooleanBinder.class.getDeclaredMethod("bind", OraclePreparedStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, char[].class, short[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Long.TYPE, ByteArray.class, long[].class, int[].class, Integer.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

