/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.data.handlers;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.handlers.RowHandler;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.StatementUtilities;
import com.ibm.db2.jcc.DBTimestamp;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class ConstantRowHandler<T>
implements RowHandler<T> {
    protected Class cls_;
    private int VALUE_NOT_SET;
    private int resultType_;

    public ConstantRowHandler(Class clazz) {
        this.resultType_ = this.VALUE_NOT_SET = -100;
        this.cls_ = clazz;
    }

    public ConstantRowHandler(Class clazz, int n2) {
        this(clazz);
        this.resultType_ = n2;
    }

    @Override
    public T handle(ResultSet resultSet, T t2) throws SQLException {
        if (this.resultType_ != this.VALUE_NOT_SET) {
            return this.createUsingRegisteredType(resultSet);
        }
        return this.checkTypeAndCreate(resultSet);
    }

    private T createUsingRegisteredType(ResultSet resultSet) throws SQLException {
        Object object;
        switch (this.resultType_) {
            case 5: {
                object = resultSet.getShort(1);
                if (!resultSet.wasNull()) break;
                object = null;
                break;
            }
            case 4: {
                object = resultSet.getInt(1);
                if (!resultSet.wasNull()) break;
                object = null;
                break;
            }
            case -5: {
                object = resultSet.getLong(1);
                break;
            }
            case 8: {
                object = resultSet.getDouble(1);
                if (!resultSet.wasNull()) break;
                object = null;
                break;
            }
            case 6: {
                object = Float.valueOf(resultSet.getFloat(1));
                if (!resultSet.wasNull()) break;
                object = null;
                break;
            }
            case 3: {
                object = resultSet.getBigDecimal(1);
                break;
            }
            case 91: {
                object = resultSet.getDate(1);
                break;
            }
            case 92: {
                object = resultSet.getTime(1);
                break;
            }
            case 93: {
                object = resultSet.getTimestamp(1);
                break;
            }
            case -100010: {
                object = StatementUtilities.getDBTimestamp(resultSet, 1);
                break;
            }
            case 12: {
                object = resultSet.getString(1);
                break;
            }
            case -3: 
            case -2: {
                object = resultSet.getBytes(1);
                break;
            }
            case 2004: {
                object = resultSet.getBlob(1);
                break;
            }
            case 2005: {
                object = resultSet.getClob(1);
                break;
            }
            default: {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_UNREC_TYPE", this.resultType_), null, 10089);
            }
        }
        return (T)object;
    }

    private T checkTypeAndCreate(ResultSet resultSet) throws SQLException {
        Object object = null;
        if (String.class.equals((Object)this.cls_)) {
            object = resultSet.getString(1);
        } else if (Boolean.class.equals((Object)this.cls_)) {
            object = resultSet.getBoolean(1);
            if (resultSet.wasNull()) {
                object = null;
            }
        } else if (Boolean.TYPE.equals(this.cls_)) {
            object = resultSet.getBoolean(1);
        } else if (Byte.class.equals((Object)this.cls_)) {
            object = resultSet.getByte(1);
            if (resultSet.wasNull()) {
                object = null;
            }
        } else if (Byte.TYPE.equals(this.cls_)) {
            object = resultSet.getByte(1);
        } else if (Short.class.equals((Object)this.cls_)) {
            object = resultSet.getShort(1);
            if (resultSet.wasNull()) {
                object = null;
            }
        } else if (Short.TYPE.equals(this.cls_)) {
            object = resultSet.getShort(1);
        } else if (Integer.class.equals((Object)this.cls_)) {
            object = resultSet.getInt(1);
            if (resultSet.wasNull()) {
                object = null;
            }
        } else if (Integer.TYPE.equals(this.cls_)) {
            object = resultSet.getInt(1);
        } else if (Long.class.equals((Object)this.cls_)) {
            object = resultSet.getLong(1);
            if (resultSet.wasNull()) {
                object = null;
            }
        } else if (Long.TYPE.equals(this.cls_)) {
            object = resultSet.getLong(1);
        } else if (Float.class.equals((Object)this.cls_)) {
            object = Float.valueOf(resultSet.getFloat(1));
            if (resultSet.wasNull()) {
                object = null;
            }
        } else if (Float.TYPE.equals(this.cls_)) {
            object = Float.valueOf(resultSet.getFloat(1));
        } else if (Double.class.equals((Object)this.cls_)) {
            object = resultSet.getDouble(1);
            if (resultSet.wasNull()) {
                object = null;
            }
        } else {
            object = Double.TYPE.equals(this.cls_) ? Double.valueOf(resultSet.getDouble(1)) : (byte[].class.equals((Object)this.cls_) ? (Object)resultSet.getBytes(1) : (Date.class.equals((Object)this.cls_) ? resultSet.getDate(1) : (Time.class.equals((Object)this.cls_) ? resultSet.getTime(1) : (Timestamp.class.equals((Object)this.cls_) ? resultSet.getTimestamp(1) : (DBTimestamp.class.equals((Object)this.cls_) ? StatementUtilities.getDBTimestamp(resultSet, 1) : (BigDecimal.class.equals((Object)this.cls_) ? resultSet.getBigDecimal(1) : (Blob.class.equals((Object)this.cls_) ? resultSet.getBlob(1) : (Clob.class.equals((Object)this.cls_) ? resultSet.getClob(1) : resultSet.getObject(1)))))))));
        }
        return (T)object;
    }
}

