/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.bytecode.HashingStorageFromListSequenceStorageNodeGen;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;

@GenerateInline(value=false)
abstract class HashingStorageFromListSequenceStorageNode
extends PNodeWithContext {
    HashingStorageFromListSequenceStorageNode() {
    }

    public abstract HashingStorage execute(Frame var1, SequenceStorage var2);

    @Specialization
    HashingStorage doIt(VirtualFrame frame, SequenceStorage sequenceStorage, @Bind Node inliningTarget, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached InlinedLoopConditionProfile loopConditionProfile) {
        HashingStorage setStorage = EmptyStorage.INSTANCE;
        int length = sequenceStorage.length();
        loopConditionProfile.profileCounted(inliningTarget, (long)length);
        LoopNode.reportLoopCount((Node)inliningTarget, (int)length);
        int i = 0;
        while (loopConditionProfile.inject(inliningTarget, i < length)) {
            Object o = getItemNode.execute(sequenceStorage, i);
            setStorage = setItem.execute((Frame)frame, inliningTarget, setStorage, o, PNone.NONE);
            ++i;
        }
        return setStorage;
    }

    @NeverDefault
    static HashingStorageFromListSequenceStorageNode create() {
        return HashingStorageFromListSequenceStorageNodeGen.create();
    }
}

