/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.datasource;

import java.sql.Connection;
import java.util.Objects;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.PooledConnectionUtility;

public final class ConnectionDatabaseConnectionSource
implements DatabaseConnectionSource {
    private final Connection connection;

    public ConnectionDatabaseConnectionSource(Connection connection) {
        this.connection = Objects.requireNonNull(connection, "No connection provided");
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    @Override
    public Connection get() {
        return PooledConnectionUtility.newPooledConnection(this.connection, this);
    }
}

