/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.metadata.AbstractMetadataMethod;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;

public final class GetPrimaryKeys
extends AbstractMetadataMethod {
    private static final RowDescriptor ROW_DESCRIPTOR = new RowDescriptorBuilder(6, DbMetadataMediator.datatypeCoder).at(0).simple(449, 63, "TABLE_CAT", "COLUMNINFO").addField().at(1).simple(449, 63, "TABLE_SCHEM", "COLUMNINFO").addField().at(2).simple(448, 63, "TABLE_NAME", "COLUMNINFO").addField().at(3).simple(448, 63, "COLUMN_NAME", "COLUMNINFO").addField().at(4).simple(500, 0, "KEY_SEQ", "COLUMNINFO").addField().at(5).simple(448, 63, "PK_NAME", "COLUMNINFO").addField().toRowDescriptor();
    private static final String GET_PRIMARY_KEYS_START = "select\n  RC.RDB$RELATION_NAME as TABLE_NAME,\n  ISGMT.RDB$FIELD_NAME as COLUMN_NAME,\n  ISGMT.RDB$FIELD_POSITION + 1 as KEY_SEQ,\n  RC.RDB$CONSTRAINT_NAME as PK_NAME\nfrom RDB$RELATION_CONSTRAINTS RC\ninner join RDB$INDEX_SEGMENTS ISGMT\n  on RC.RDB$INDEX_NAME = ISGMT.RDB$INDEX_NAME\nwhere RC.RDB$CONSTRAINT_TYPE = 'PRIMARY KEY'\nand ";
    private static final String GET_PRIMARY_KEYS_END = "\norder by ISGMT.RDB$FIELD_NAME ";

    private GetPrimaryKeys(DbMetadataMediator mediator) {
        super(ROW_DESCRIPTOR, mediator);
    }

    public ResultSet getPrimaryKeys(String table) throws SQLException {
        if (table == null || "".equals(table)) {
            return this.createEmpty();
        }
        Clause tableClause = Clause.equalsClause("RC.RDB$RELATION_NAME", table);
        String sql = GET_PRIMARY_KEYS_START + tableClause.getCondition(false) + GET_PRIMARY_KEYS_END;
        DbMetadataMediator.MetadataQuery metadataQuery = new DbMetadataMediator.MetadataQuery(sql, Clause.parameters(tableClause));
        return this.createMetaDataResultSet(metadataQuery);
    }

    @Override
    RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
        return valueBuilder.at(0).set(null).at(1).set(null).at(2).setString(rs.getString("TABLE_NAME")).at(3).setString(rs.getString("COLUMN_NAME")).at(4).setShort(rs.getShort("KEY_SEQ")).at(5).setString(rs.getString("PK_NAME")).toRowValue(false);
    }

    public static GetPrimaryKeys create(DbMetadataMediator mediator) {
        return new GetPrimaryKeys(mediator);
    }
}

