/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode_dsl;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.MarshalModuleBuiltins;
import com.oracle.graal.python.builtins.modules.TypingModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.ObjectHashMap;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.ChainExceptionsNode;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.StopIterationBuiltins;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.builtins.objects.iterator.PDoubleSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntRangeIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntegerIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntegerSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PLongSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PObjectSequenceIterator;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.typing.PTypeAliasType;
import com.oracle.graal.python.compiler.ParserCallbacksImpl;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterCheckNode;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyNumberInPlacePowerNode;
import com.oracle.graal.python.lib.PyNumberPowerNode;
import com.oracle.graal.python.lib.PyObjectAsciiNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectDelItem;
import com.oracle.graal.python.lib.PyObjectFunctionStr;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectGetMethod;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectRichCompare;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PyObjectSetAttrO;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.lib.PySequenceContainsNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.WriteUnraisableNode;
import com.oracle.graal.python.nodes.argument.keywords.ConcatDictToStorageNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.keywords.NonMappingException;
import com.oracle.graal.python.nodes.argument.keywords.SameDictKeyException;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.bytecode.GetSendValueNode;
import com.oracle.graal.python.nodes.bytecode.GetTPFlagsNode;
import com.oracle.graal.python.nodes.bytecode.ImportFromNode;
import com.oracle.graal.python.nodes.bytecode.ImportNode;
import com.oracle.graal.python.nodes.bytecode.ImportStarNode;
import com.oracle.graal.python.nodes.bytecode.MatchClassNode;
import com.oracle.graal.python.nodes.bytecode.MatchKeysNode;
import com.oracle.graal.python.nodes.bytecode.PrintExprNode;
import com.oracle.graal.python.nodes.bytecode.RaiseNode;
import com.oracle.graal.python.nodes.bytecode_dsl.BytecodeDSLCodeUnit;
import com.oracle.graal.python.nodes.bytecode_dsl.BytecodeDSLFrameInfo;
import com.oracle.graal.python.nodes.bytecode_dsl.MakeSetStorageNode;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNodeGen;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallQuaternaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.frame.DeleteGlobalNode;
import com.oracle.graal.python.nodes.frame.GetFrameLocalsNode;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNode;
import com.oracle.graal.python.nodes.frame.ReadBuiltinNode;
import com.oracle.graal.python.nodes.frame.ReadFromLocalsNode;
import com.oracle.graal.python.nodes.frame.ReadGlobalOrBuiltinNode;
import com.oracle.graal.python.nodes.frame.ReadNameNode;
import com.oracle.graal.python.nodes.frame.WriteGlobalNode;
import com.oracle.graal.python.nodes.frame.WriteNameNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.ExceptionStateNodes;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.BoolSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.ArrayBuilder;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.bytecode.BytecodeConfig;
import com.oracle.truffle.api.bytecode.BytecodeLocation;
import com.oracle.truffle.api.bytecode.BytecodeNode;
import com.oracle.truffle.api.bytecode.BytecodeRootNode;
import com.oracle.truffle.api.bytecode.Instruction;
import com.oracle.truffle.api.bytecode.LocalAccessor;
import com.oracle.truffle.api.bytecode.LocalRangeAccessor;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF32;
import java.math.BigInteger;
import java.util.Iterator;

public abstract class PBytecodeDSLRootNode
extends PRootNode
implements BytecodeRootNode {
    public static final int EXPLODE_LOOP_THRESHOLD = 30;
    private static final BytecodeConfig TRACE_AND_PROFILE_CONFIG = PBytecodeDSLRootNodeGen.newConfigBuilder().addInstrumentation(TraceOrProfileCall.class).addInstrumentation(TraceLine.class).addInstrumentation(TraceLineAtLoopHeader.class).addInstrumentation(TraceOrProfileReturn.class).addInstrumentation(TraceException.class).build();
    @Node.Child
    private transient ExecutionContext.CalleeContext calleeContext = ExecutionContext.CalleeContext.create();
    @Node.Child
    private transient ExceptionStateNodes.GetCaughtExceptionNode getCaughtExceptionNode;
    @Node.Child
    private transient MaterializeFrameNode traceMaterializeFrameNode = null;
    @Node.Child
    private transient ChainExceptionsNode chainExceptionsNode;
    @CompilerDirectives.CompilationFinal
    protected transient BytecodeDSLCodeUnit co;
    @CompilerDirectives.CompilationFinal
    protected transient Signature signature;
    @CompilerDirectives.CompilationFinal
    protected transient int selfIndex;
    @CompilerDirectives.CompilationFinal
    protected transient int classcellIndex;
    private transient boolean pythonInternal;
    @CompilerDirectives.CompilationFinal
    private transient boolean internal;
    @CompilerDirectives.CompilationFinal
    private transient ParserCallbacksImpl parserErrorCallback;

    protected PBytecodeDSLRootNode(PythonLanguage language, FrameDescriptor.Builder frameDescriptorBuilder) {
        super(language, frameDescriptorBuilder.info((Object)new BytecodeDSLFrameInfo()).build());
        ((BytecodeDSLFrameInfo)this.getFrameDescriptor().getInfo()).setRootNode(this);
    }

    public final PythonLanguage getLanguage() {
        return (PythonLanguage)this.getLanguage(PythonLanguage.class);
    }

    public void setMetadata(BytecodeDSLCodeUnit co, ParserCallbacksImpl parserErrorCallback) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.co = co;
        this.signature = co.computeSignature();
        this.classcellIndex = co.classcellIndex;
        this.selfIndex = co.selfIndex;
        this.internal = this.getSource().isInternal();
        this.parserErrorCallback = parserErrorCallback;
    }

    public final boolean isInternal() {
        return this.internal;
    }

    @Override
    public final boolean isPythonInternal() {
        return this.pythonInternal;
    }

    public final void setPythonInternal(boolean pythonInternal) {
        this.pythonInternal = pythonInternal;
    }

    public final void triggerDeferredDeprecationWarnings() {
        if (this.parserErrorCallback != null) {
            this.parserErrorCallback.triggerDeprecationWarnings();
        }
    }

    public String toString() {
        return "<bytecode " + String.valueOf(this.co.name) + " at " + Integer.toHexString(((Object)((Object)this)).hashCode()) + ">";
    }

    @NonIdempotent
    public final boolean needsTraceAndProfileInstrumentation() {
        return !this.getLanguage().noTracingOrProfilingAssumption.isValid() && !this.isInternal();
    }

    @NonIdempotent
    public final PythonContext.PythonThreadState getThreadState() {
        return PythonContext.get((Node)this).getThreadState(this.getLanguage());
    }

    public final void ensureTraceAndProfileEnabled() {
        assert (!this.isInternal());
        this.getRootNodes().update(TRACE_AND_PROFILE_CONFIG);
    }

    private PFrame ensurePyFrame(VirtualFrame frame, Node location) {
        if (this.traceMaterializeFrameNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.traceMaterializeFrameNode = (MaterializeFrameNode)this.insert(MaterializeFrameNode.create());
        }
        return this.traceMaterializeFrameNode.execute((Frame)frame, location, true, true);
    }

    private void syncLocalsBackToFrame(VirtualFrame frame, PFrame pyFrame) {
        GetFrameLocalsNode.syncLocalsBackToFrame(this.co, this, pyFrame, (Frame)frame);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object doInvokeProfileOrTraceFunction(Object fun, PFrame pyFrame, TruffleString eventName, Object arg) {
        return CallTernaryMethodNode.getUncached().execute(null, fun, pyFrame, eventName, arg == null ? PNone.NONE : arg);
    }

    @HostCompilerDirectives.InliningCutoff
    private void invokeProfileFunction(VirtualFrame virtualFrame, Node location, Object profileFun, PythonContext.PythonThreadState threadState, PythonContext.ProfileEvent event, Object arg) {
        if (threadState.isProfiling()) {
            return;
        }
        threadState.profilingStart();
        PFrame pyFrame = this.ensurePyFrame(virtualFrame, location);
        EncapsulatingNodeReference encapsulating = EncapsulatingNodeReference.getCurrent();
        Node oldEncapsulatingNode = encapsulating.set(location);
        try {
            GetFrameLocalsNode.executeUncached(pyFrame);
            Object result = PBytecodeDSLRootNode.doInvokeProfileOrTraceFunction(profileFun, pyFrame, event.name, arg);
            this.syncLocalsBackToFrame(virtualFrame, pyFrame);
            Object realResult = result == PNone.NONE ? null : result;
            pyFrame.setLocalTraceFun(realResult);
        }
        catch (Throwable e) {
            threadState.setProfileFun(null, this.getLanguage());
            throw e;
        }
        finally {
            threadState.profilingStop();
            encapsulating.set(oldEncapsulatingNode);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private void invokeTraceFunction(VirtualFrame virtualFrame, Node location, Object traceFun, PythonContext.PythonThreadState threadState, PythonContext.TraceEvent event, Object arg, int line) {
        Object traceFn;
        if (threadState.isTracing()) {
            return;
        }
        assert (event != PythonContext.TraceEvent.DISABLED);
        threadState.tracingStart(event);
        PFrame pyFrame = this.ensurePyFrame(virtualFrame, location);
        boolean useLocalFn = event != PythonContext.TraceEvent.CALL;
        Object object = traceFn = useLocalFn ? pyFrame.getLocalTraceFun() : traceFun;
        if (traceFn == null) {
            threadState.tracingStop();
            return;
        }
        Object nonNullArg = arg == null ? PNone.NONE : arg;
        EncapsulatingNodeReference encapsulating = EncapsulatingNodeReference.getCurrent();
        Node oldEncapsulatingNode = encapsulating.set(location);
        try {
            if (line != -1) {
                pyFrame.setLineLock(line);
            }
            GetFrameLocalsNode.executeUncached(pyFrame);
            Object result = PBytecodeDSLRootNode.doInvokeProfileOrTraceFunction(traceFn, pyFrame, event.pythonName, nonNullArg);
            this.syncLocalsBackToFrame(virtualFrame, pyFrame);
            if (useLocalFn) {
                Object realResult = result == PNone.NONE ? traceFn : result;
                pyFrame.setLocalTraceFun(realResult);
            } else if (result != PNone.NONE) {
                pyFrame.setLocalTraceFun(result);
            } else {
                pyFrame.setLocalTraceFun(null);
            }
        }
        catch (Throwable e) {
            threadState.setTraceFun(null, this.getLanguage());
            throw e;
        }
        finally {
            if (line != -1) {
                pyFrame.lineUnlock();
            }
            threadState.tracingStop();
            encapsulating.set(oldEncapsulatingNode);
        }
    }

    private void traceOrProfileCall(VirtualFrame frame, Node location, BytecodeNode bytecode, int bci) {
        Object profileFun;
        PythonContext.PythonThreadState threadState = this.getThreadState();
        Object traceFun = threadState.getTraceFun();
        if (traceFun != null) {
            int line = this.bciToLine(bci, bytecode);
            this.invokeTraceFunction(frame, location, traceFun, threadState, PythonContext.TraceEvent.CALL, null, line);
        }
        if ((profileFun = threadState.getProfileFun()) != null) {
            this.invokeProfileFunction(frame, location, profileFun, threadState, PythonContext.ProfileEvent.CALL, null);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private void traceLine(VirtualFrame frame, Node location, int line) {
        Object traceFun;
        PythonContext.PythonThreadState threadState = this.getThreadState();
        InstrumentationData instrumentationData = threadState.getInstrumentationData(this);
        if (line == instrumentationData.getPastLine()) {
            return;
        }
        instrumentationData.setPastLine(line);
        PFrame pyFrame = this.ensurePyFrame(frame, location);
        if (pyFrame.getTraceLine() && (traceFun = threadState.getTraceFun()) != null) {
            this.invokeTraceFunction(frame, location, traceFun, threadState, PythonContext.TraceEvent.LINE, null, line);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private void traceLineAtLoopHeader(VirtualFrame frame, Node location, int line) {
        Object traceFun;
        PythonContext.PythonThreadState threadState = this.getThreadState();
        InstrumentationData instrumentationData = threadState.getInstrumentationData(this);
        int pastLine = instrumentationData.getPastLine();
        if (line != pastLine && (traceFun = threadState.getTraceFun()) != null) {
            this.invokeTraceFunction(frame, location, traceFun, threadState, PythonContext.TraceEvent.LINE, null, line);
        }
        instrumentationData.clearPastLine();
    }

    private void traceOrProfileReturn(VirtualFrame frame, Node location, Object value) {
        Object profileFun;
        PythonContext.PythonThreadState threadState = this.getThreadState();
        Object traceFun = threadState.getTraceFun();
        if (traceFun != null) {
            this.invokeTraceFunction(frame, location, traceFun, threadState, PythonContext.TraceEvent.RETURN, value, threadState.getInstrumentationData(this).getPastLine());
        }
        if ((profileFun = threadState.getProfileFun()) != null) {
            this.invokeProfileFunction(frame, location, profileFun, threadState, PythonContext.ProfileEvent.RETURN, value);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private PException traceException(VirtualFrame frame, BytecodeNode bytecode, int bci, PException pe) {
        PFrame pyFrame;
        PException result = pe;
        PythonContext.PythonThreadState threadState = this.getThreadState();
        if (threadState.getTraceFun() != null && (pyFrame = this.ensurePyFrame(frame, (Node)bytecode)).getLocalTraceFun() != null) {
            pe.markAsCaught((Frame)frame, this);
            Object peForPython = pe.getEscapedException();
            Object peType = GetClassNode.executeUncached(peForPython);
            Object traceback = ExceptionNodes.GetTracebackNode.executeUncached(peForPython);
            try {
                this.invokeTraceFunction(frame, (Node)bytecode, null, threadState, PythonContext.TraceEvent.EXCEPTION, PFactory.createTuple(this.getLanguage(), new Object[]{peType, peForPython, traceback}), this.bciToLine(bci, bytecode));
            }
            catch (PException newPe) {
                result = newPe;
            }
            result = result.getExceptionForReraise(!this.isInternal());
            result.setCatchLocation(bci, bytecode);
        }
        return result;
    }

    public Throwable interceptInternalException(Throwable throwable, VirtualFrame frame, BytecodeNode bytecodeNode, int bci) {
        PythonLanguage language = this.getLanguage();
        if (language.getEngineOption(PythonOptions.CatchAllExceptions).booleanValue() && (throwable instanceof Exception || throwable instanceof AssertionError)) {
            return ExceptionUtils.wrapJavaException(throwable, (Node)this, PFactory.createBaseException(language, PythonBuiltinClassType.SystemError, ErrorMessages.M, new Object[]{throwable}));
        }
        PException wrapped = ExceptionUtils.wrapJavaExceptionIfApplicable((Node)this, throwable);
        return wrapped != null ? wrapped : throwable;
    }

    public AbstractTruffleException interceptTruffleException(AbstractTruffleException ex, VirtualFrame frame, BytecodeNode bytecodeNode, int bci) {
        if (ex instanceof PException) {
            AbstractTruffleException context;
            PException pe = (PException)ex;
            pe.setCatchLocation(bci, bytecodeNode);
            if (this.needsTraceAndProfileInstrumentation() && !this.getThreadState().isTracing()) {
                pe = this.traceException(frame, bytecodeNode, bci, pe);
            }
            if (this.getCaughtExceptionNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getCaughtExceptionNode = (ExceptionStateNodes.GetCaughtExceptionNode)this.insert(ExceptionStateNodes.GetCaughtExceptionNode.create());
            }
            if ((context = this.getCaughtExceptionNode.execute(frame)) instanceof PException) {
                PException pe2 = (PException)context;
                if (this.chainExceptionsNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.chainExceptionsNode = (ChainExceptionsNode)this.insert(ChainExceptionsNode.create());
                }
                this.chainExceptionsNode.execute(pe, pe2);
            }
            return pe;
        }
        return ex;
    }

    @Override
    public boolean setsUpCalleeContext() {
        return true;
    }

    public String getName() {
        if (this.co == null) {
            return null;
        }
        return this.co.name.toJavaStringUncached();
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    public BytecodeDSLCodeUnit getCodeUnit() {
        return this.co;
    }

    public int getFirstLineno() {
        return this.co.startLine;
    }

    protected Source getSource() {
        SourceSection section = this.getSourceSection();
        if (section == null) {
            return PythonUtils.createFakeSource();
        }
        return section.getSource();
    }

    @CompilerDirectives.TruffleBoundary
    public int bciToLine(int bci, BytecodeNode bytecodeNode) {
        return this.getSourceSectionForLocation(bci, bytecodeNode).getStartLine();
    }

    @CompilerDirectives.TruffleBoundary
    public SourceSection getSourceSectionForLocation(BytecodeLocation location) {
        SourceSection sourceSection = null;
        if (location != null) {
            sourceSection = location.getSourceLocation();
        }
        if (sourceSection == null) {
            sourceSection = this.getSourceSection();
        }
        return sourceSection;
    }

    @CompilerDirectives.TruffleBoundary
    public SourceSection getSourceSectionForLocation(int bci, BytecodeNode bytecodeNode) {
        BytecodeLocation location = null;
        if (bytecodeNode != null) {
            location = bytecodeNode.getBytecodeLocation(bci);
        }
        return this.getSourceSectionForLocation(location);
    }

    public static int bciToLasti(int bci, BytecodeNode bytecodeNode) {
        if (bci <= 0) {
            return bci;
        }
        int number = 0;
        for (Instruction instruction : bytecodeNode.getInstructions()) {
            if (instruction.isInstrumentation()) continue;
            if (instruction.getBytecodeIndex() >= bci) {
                return number;
            }
            number += 2;
        }
        return -1;
    }

    public static int lastiToBci(int lasti, BytecodeNode bytecodeNode) {
        Instruction result;
        if (lasti < 0) {
            return 0;
        }
        Iterator iter = bytecodeNode.getInstructions().iterator();
        assert (iter.hasNext());
        int nexti = 0;
        do {
            if ((result = (Instruction)iter.next()).isInstrumentation()) continue;
            nexti += 2;
        } while (nexti <= lasti && iter.hasNext());
        return result.getBytecodeIndex();
    }

    @Override
    protected byte[] extractCode() {
        return MarshalModuleBuiltins.serializeCodeUnit((Node)this, PythonContext.get((Node)this), this.co);
    }

    private static Object checkUnboundCell(PCell cell, int index, PBytecodeDSLRootNode rootNode, Node inliningTarget, PRaiseNode raiseNode) {
        Object result = cell.getRef();
        if (result == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            BytecodeDSLCodeUnit codeUnit = rootNode.getCodeUnit();
            if (index < codeUnit.cellvars.length) {
                TruffleString localName = codeUnit.cellvars[index];
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.UnboundLocalError, ErrorMessages.LOCAL_VAR_REFERENCED_BEFORE_ASSIGMENT, localName);
            }
            TruffleString localName = codeUnit.freevars[index - codeUnit.cellvars.length];
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.NameError, ErrorMessages.UNBOUNDFREEVAR, localName);
        }
        return result;
    }

    public PCell readClassCell(Frame frame) {
        if (this.classcellIndex < 0) {
            return null;
        }
        return (PCell)this.getBytecodeNode().getLocalValue(0, frame, this.classcellIndex);
    }

    public boolean hasSelf() {
        return this.selfIndex >= 0;
    }

    public Object readSelf(Frame frame) {
        if (this.selfIndex < 0) {
            return null;
        }
        if (this.selfIndex == 0) {
            return this.getBytecodeNode().getLocalValue(0, frame, 0);
        }
        PCell selfCell = (PCell)this.getBytecodeNode().getLocalValue(0, frame, this.selfIndex);
        return selfCell.getRef();
    }

    private static RuntimeException notSupported(Object left, Object right, Node nodeForRaise, TruffleString operator) {
        throw PRaiseNode.raiseStatic(nodeForRaise, PythonErrorType.TypeError, ErrorMessages.NOT_SUPPORTED_BETWEEN_INSTANCES, operator, left, right);
    }

    @CompilerDirectives.TruffleBoundary
    private static PException raiseUnbound(PBytecodeDSLRootNode rootNode, Node inliningTarget, int index) {
        TruffleString localName = rootNode.getCodeUnit().varnames[index];
        throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.UnboundLocalError, ErrorMessages.LOCAL_VAR_REFERENCED_BEFORE_ASSIGMENT, localName);
    }

    public static final class InstrumentationData {
        private final InstrumentationData previous;
        private final PBytecodeDSLRootNode rootNode;
        private int pastLine;

        public InstrumentationData(PBytecodeDSLRootNode rootNode, InstrumentationData previous) {
            this.previous = previous;
            this.rootNode = rootNode;
            this.pastLine = -1;
        }

        public InstrumentationData getPrevious() {
            return this.previous;
        }

        public PBytecodeDSLRootNode getRootNode() {
            return this.rootNode;
        }

        int getPastLine() {
            return this.pastLine;
        }

        void setPastLine(int pastLine) {
            this.pastLine = pastLine;
        }

        void clearPastLine() {
            this.pastLine = -1;
        }
    }

    public static final class TraceOrProfileCall {
        @Specialization
        public static void perform(VirtualFrame frame, @Bind Node location, @Bind PBytecodeDSLRootNode root, @Bind BytecodeNode bytecode, @Bind(value="$bytecodeIndex") int bci) {
            root.traceOrProfileCall(frame, location, bytecode, bci);
        }
    }

    public static final class TraceLine {
        @Specialization
        public static void perform(VirtualFrame frame, int line, @Bind Node location, @Bind PBytecodeDSLRootNode root) {
            root.traceLine(frame, location, line);
        }
    }

    public static final class TraceLineAtLoopHeader {
        @Specialization
        public static void perform(VirtualFrame frame, int line, @Bind Node location, @Bind PBytecodeDSLRootNode root) {
            root.traceLineAtLoopHeader(frame, location, line);
        }
    }

    public static final class TraceOrProfileReturn {
        @Specialization
        public static Object perform(VirtualFrame frame, Object value, @Bind Node location, @Bind PBytecodeDSLRootNode root) {
            root.traceOrProfileReturn(frame, location, value);
            return value;
        }
    }

    public static final class TraceException {
        @Specialization
        public static void perform() {
            throw new UnsupportedOperationException("trace exception not implemented");
        }
    }

    public static final class MakeGeneric {
        @Specialization
        static Object makeGeneric(VirtualFrame frame, PTuple params, @Bind Node inliningTarget, @Cached TypingModuleBuiltins.UnpackTypeVarTuplesNode unpackTypeVarTuplesNode, @Cached TypingModuleBuiltins.CallTypingFuncObjectNode callTypingFuncObjectNode) {
            params = unpackTypeVarTuplesNode.execute(frame, inliningTarget, params);
            return callTypingFuncObjectNode.execute(frame, inliningTarget, TypingModuleBuiltins.T_GENERIC_ALIAS, new Object[]{PythonBuiltinClassType.PGeneric, params});
        }
    }

    public static final class MakeTypeAliasType {
        @Specialization
        public static PTypeAliasType doObject(TruffleString name, Object typeParams, Object computeValue, @Bind PBytecodeDSLRootNode rootNode) {
            PythonLanguage language = PythonLanguage.get((Node)rootNode);
            return PFactory.createTypeAliasType(language, name, (PTuple)typeParams, computeValue, null, null);
        }
    }

    public static final class MakeTypeParam {
        @Specialization
        public static Object doObject(int kind, TruffleString name, Object boundOrConstraint, @Bind PBytecodeDSLRootNode rootNode) {
            Object evaluateBound = null;
            Object evaluateConstraints = null;
            if (kind == 3) {
                evaluateBound = boundOrConstraint;
            } else if (kind == 4) {
                evaluateConstraints = boundOrConstraint;
            }
            PythonLanguage language = PythonLanguage.get((Node)rootNode);
            return switch (kind) {
                case 0, 3, 4 -> PFactory.createTypeVar(language, name, evaluateBound == null ? PNone.NONE : null, evaluateBound, evaluateConstraints == null ? PFactory.createEmptyTuple(language) : null, evaluateConstraints, false, false, true);
                case 2 -> PFactory.createParamSpec(language, name, PNone.NONE, false, false, true);
                case 1 -> PFactory.createTypeVarTuple(language, name);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
        }
    }

    public static final class RaiseNotImplementedError {
        @Specialization
        public static void doRaise(VirtualFrame frame, TruffleString name, @Bind Node node) {
            throw PRaiseNode.raiseStatic(node, PythonBuiltinClassType.NotImplementedError, name);
        }
    }

    public static final class DeleteLocal {
        @Specialization
        public static void doObject(VirtualFrame frame, LocalAccessor accessor, int index, @Bind PBytecodeDSLRootNode rootNode, @Bind BytecodeNode bytecodeNode, @Bind Node inliningTarget, @Cached InlinedBranchProfile localUnboundProfile) {
            if (accessor.isCleared(bytecodeNode, frame)) {
                localUnboundProfile.enter(inliningTarget);
                throw PBytecodeDSLRootNode.raiseUnbound(rootNode, inliningTarget, index);
            }
            accessor.clear(bytecodeNode, frame);
        }
    }

    public static final class CheckAndLoadLocal {
        @Specialization(rewriteOn={UnexpectedResultException.class})
        public static int doInt(VirtualFrame frame, LocalAccessor accessor, int index, @Bind PBytecodeDSLRootNode rootNode, @Bind BytecodeNode bytecodeNode, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile localUnboundProfile) throws UnexpectedResultException {
            if (accessor.isCleared(bytecodeNode, frame)) {
                localUnboundProfile.enter(inliningTarget);
                throw PBytecodeDSLRootNode.raiseUnbound(rootNode, inliningTarget, index);
            }
            return accessor.getInt(bytecodeNode, frame);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public static boolean doBoolean(VirtualFrame frame, LocalAccessor accessor, int index, @Bind PBytecodeDSLRootNode rootNode, @Bind BytecodeNode bytecodeNode, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile localUnboundProfile) throws UnexpectedResultException {
            if (accessor.isCleared(bytecodeNode, frame)) {
                localUnboundProfile.enter(inliningTarget);
                throw PBytecodeDSLRootNode.raiseUnbound(rootNode, inliningTarget, index);
            }
            return accessor.getBoolean(bytecodeNode, frame);
        }

        @Specialization(replaces={"doInt", "doBoolean"})
        public static Object doObject(VirtualFrame frame, LocalAccessor accessor, int index, @Bind PBytecodeDSLRootNode rootNode, @Bind BytecodeNode bytecodeNode, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile localUnboundProfile) {
            if (accessor.isCleared(bytecodeNode, frame)) {
                localUnboundProfile.enter(inliningTarget);
                throw PBytecodeDSLRootNode.raiseUnbound(rootNode, inliningTarget, index);
            }
            return accessor.getObject(bytecodeNode, frame);
        }
    }

    public static final class YieldFromThrow {
        private static final TruffleString T_CLOSE = PythonUtils.tsLiteral("close");
        private static final TruffleString T_THROW = PythonUtils.tsLiteral("throw");

        @Specialization
        static boolean doGenerator(VirtualFrame frame, LocalAccessor yieldedValue, LocalAccessor returnedValue, PGenerator generator, PException exception, @Bind Node inliningTarget, @Bind BytecodeNode bytecode, @Cached CommonGeneratorBuiltins.ThrowNode throwNode, @Cached CommonGeneratorBuiltins.CloseNode closeNode, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profileExit, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached.Shared @Cached StopIterationBuiltins.StopIterationValueNode getValue) {
            if (profileExit.profileException(inliningTarget, exception, PythonBuiltinClassType.GeneratorExit)) {
                closeNode.execute(frame, generator);
                throw exception;
            }
            try {
                Object value = throwNode.execute(frame, generator, exception.getEscapedException(), PNone.NO_VALUE, PNone.NO_VALUE);
                yieldedValue.setObject(bytecode, frame, value);
                return false;
            }
            catch (PException e) {
                YieldFromThrow.handleException(frame, e, inliningTarget, bytecode, stopIterationProfile, getValue, returnedValue);
                return true;
            }
        }

        @Fallback
        static boolean doOther(VirtualFrame frame, LocalAccessor yieldedValue, LocalAccessor returnedValue, Object obj, Object exception, @Bind Node inliningTarget, @Bind BytecodeNode bytecode, @Cached PyObjectLookupAttr lookupThrow, @Cached PyObjectLookupAttr lookupClose, @Cached CallNode callThrow, @Cached CallNode callClose, @Cached WriteUnraisableNode writeUnraisableNode, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profileExit, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached.Shared @Cached StopIterationBuiltins.StopIterationValueNode getValue) {
            PException pException = (PException)((Object)exception);
            if (profileExit.profileException(inliningTarget, pException, PythonBuiltinClassType.GeneratorExit)) {
                Object close = PNone.NO_VALUE;
                try {
                    close = lookupClose.execute((Frame)frame, inliningTarget, obj, T_CLOSE);
                }
                catch (PException e) {
                    writeUnraisableNode.execute(frame, e.getEscapedException(), null, obj);
                }
                if (close != PNone.NO_VALUE) {
                    callClose.execute((Frame)frame, close, new Object[0]);
                }
                throw pException;
            }
            Object throwMethod = lookupThrow.execute((Frame)frame, inliningTarget, obj, T_THROW);
            if (throwMethod == PNone.NO_VALUE) {
                throw pException;
            }
            try {
                Object value = callThrow.execute((Frame)frame, throwMethod, pException.getEscapedException());
                yieldedValue.setObject(bytecode, frame, value);
                return false;
            }
            catch (PException e) {
                YieldFromThrow.handleException(frame, e, inliningTarget, bytecode, stopIterationProfile, getValue, returnedValue);
                return true;
            }
        }

        private static void handleException(VirtualFrame frame, PException e, Node inliningTarget, BytecodeNode bytecode, BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, StopIterationBuiltins.StopIterationValueNode getValue, LocalAccessor returnedValue) {
            e.expectStopIteration(inliningTarget, stopIterationProfile);
            returnedValue.setObject(bytecode, frame, getValue.execute((PBaseException)e.getUnreifiedException()));
        }
    }

    public static final class YieldFromSend {
        private static final TruffleString T_SEND = PythonUtils.tsLiteral("send");

        @Specialization
        static boolean doGenerator(VirtualFrame virtualFrame, LocalAccessor yieldedValue, LocalAccessor returnedValue, PGenerator generator, Object arg, @Bind Node inliningTarget, @Bind BytecodeNode bytecode, @Cached CommonGeneratorBuiltins.SendNode sendNode, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached.Shared @Cached StopIterationBuiltins.StopIterationValueNode getValue) {
            try {
                Object value = sendNode.execute(virtualFrame, generator, arg);
                yieldedValue.setObject(bytecode, virtualFrame, value);
                return false;
            }
            catch (PException e) {
                YieldFromSend.handleException(virtualFrame, e, inliningTarget, bytecode, stopIterationProfile, getValue, returnedValue);
                return true;
            }
        }

        @Specialization(guards={"iterCheck.execute(inliningTarget, iter)"}, limit="1")
        static boolean doIterator(VirtualFrame virtualFrame, LocalAccessor yieldedValue, LocalAccessor returnedValue, Object iter, PNone arg, @Bind Node inliningTarget, @Bind BytecodeNode bytecode, @Cached PyIterCheckNode iterCheck, @Cached PyIterNextNode getNextNode, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached.Shared @Cached StopIterationBuiltins.StopIterationValueNode getValue) {
            try {
                Object value = getNextNode.execute((Frame)virtualFrame, inliningTarget, iter);
                yieldedValue.setObject(bytecode, virtualFrame, value);
                return false;
            }
            catch (IteratorExhausted e) {
                returnedValue.setObject(bytecode, virtualFrame, (Object)PNone.NONE);
                return true;
            }
        }

        @Fallback
        static boolean doOther(VirtualFrame virtualFrame, LocalAccessor yieldedValue, LocalAccessor returnedValue, Object obj, Object arg, @Bind Node inliningTarget, @Bind BytecodeNode bytecode, @Bind(value="$bytecodeIndex") int bci, @Cached PyObjectCallMethodObjArgs callMethodNode, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached.Shared @Cached StopIterationBuiltins.StopIterationValueNode getValue) {
            try {
                Object value = callMethodNode.execute((Frame)virtualFrame, inliningTarget, obj, T_SEND, arg);
                yieldedValue.setObject(bytecode, virtualFrame, value);
                return false;
            }
            catch (PException e) {
                YieldFromSend.handleException(virtualFrame, e, inliningTarget, bytecode, stopIterationProfile, getValue, returnedValue);
                return true;
            }
        }

        private static void handleException(VirtualFrame frame, PException e, Node inliningTarget, BytecodeNode bytecode, BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, StopIterationBuiltins.StopIterationValueNode getValue, LocalAccessor returnedValue) {
            e.expectStopIteration(inliningTarget, stopIterationProfile);
            returnedValue.setObject(bytecode, frame, getValue.execute((PBaseException)e.getUnreifiedException()));
        }
    }

    public static final class ResumeYield {
        @Specialization
        public static Object doObject(VirtualFrame frame, Object sendValue, @Bind Node location, @Bind PBytecodeDSLRootNode root, @Bind BytecodeNode bytecode, @Bind(value="$bytecodeIndex") int bci, @Cached GetSendValueNode getSendValue) {
            if (root.needsTraceAndProfileInstrumentation()) {
                root.ensureTraceAndProfileEnabled();
                root.getThreadState().pushInstrumentationData(root);
                root.traceOrProfileCall(frame, location, bytecode, bci);
            }
            return getSendValue.execute(sendValue);
        }
    }

    public static final class PreYield {
        @Specialization
        public static Object doObject(VirtualFrame frame, Object value, @Bind Node location, @Bind PBytecodeDSLRootNode root) {
            if (root.needsTraceAndProfileInstrumentation()) {
                root.traceOrProfileReturn(frame, location, value);
                root.getThreadState().popInstrumentationData(root);
            }
            return value;
        }
    }

    @ImportStatic(value={PGuards.class})
    public static final class BinarySubscript {
        @Specialization(rewriteOn={UnexpectedResultException.class}, guards={"isBuiltinList(list)"})
        public static int doIntList(PList list, int index, @Cached.Shared @Cached(value="createForList()") SequenceStorageNodes.GetItemNode getListItemNode) throws UnexpectedResultException {
            return getListItemNode.executeInt(list.getSequenceStorage(), index);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class}, guards={"isBuiltinList(list)"})
        public static double doDoubleList(PList list, int index, @Cached.Shared @Cached(value="createForList()") SequenceStorageNodes.GetItemNode getListItemNode) throws UnexpectedResultException {
            return getListItemNode.executeDouble(list.getSequenceStorage(), index);
        }

        @Specialization(replaces={"doIntList", "doDoubleList"}, guards={"isBuiltinList(list)"})
        public static Object doObjectList(PList list, int index, @Cached.Shared @Cached(value="createForList()") SequenceStorageNodes.GetItemNode getListItemNode) {
            return getListItemNode.execute(list.getSequenceStorage(), index);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class}, guards={"isBuiltinTuple(tuple)"})
        public static int doIntTuple(PTuple tuple, int index, @Cached.Shared @Cached(value="createForTuple()") SequenceStorageNodes.GetItemNode getTupleItemNode) throws UnexpectedResultException {
            return getTupleItemNode.executeInt(tuple.getSequenceStorage(), index);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class}, guards={"isBuiltinTuple(tuple)"})
        public static double doDoubleTuple(PTuple tuple, int index, @Cached.Shared @Cached(value="createForTuple()") SequenceStorageNodes.GetItemNode getTupleItemNode) throws UnexpectedResultException {
            return getTupleItemNode.executeDouble(tuple.getSequenceStorage(), index);
        }

        @Specialization(replaces={"doIntTuple", "doDoubleTuple"}, guards={"isBuiltinTuple(tuple)"})
        public static Object doObjectTuple(PTuple tuple, int index, @Cached.Shared @Cached(value="createForTuple()") SequenceStorageNodes.GetItemNode getTupleItemNode) {
            return getTupleItemNode.execute(tuple.getSequenceStorage(), index);
        }

        @Fallback
        public static Object doOther(VirtualFrame frame, Object receiver, Object key, @Bind Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached PyObjectGetItem.PyObjectGetItemGeneric getItemNode) {
            TpSlots slots = getSlotsNode.execute(inliningTarget, receiver);
            return getItemNode.execute((Frame)frame, inliningTarget, receiver, slots, key);
        }
    }

    public static final class CheckTypeFlags {
        @Specialization
        public static boolean doObject(long typeFlags, Object value, @Cached GetTPFlagsNode getTPFlagsNode) {
            return (getTPFlagsNode.execute(value) & typeFlags) != 0L;
        }
    }

    public static final class GetLen {
        @Specialization
        public static int doObject(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached PyObjectSizeNode sizeNode) {
            return sizeNode.execute((Frame)frame, inliningTarget, value);
        }
    }

    public static final class TeeLocal {
        @Specialization
        public static int doInt(VirtualFrame frame, LocalAccessor local, int value, @Bind BytecodeNode bytecode) {
            local.setInt(bytecode, frame, value);
            return value;
        }

        @Specialization
        public static double doDouble(VirtualFrame frame, LocalAccessor local, double value, @Bind BytecodeNode bytecode) {
            local.setDouble(bytecode, frame, value);
            return value;
        }

        @Specialization
        public static long doLong(VirtualFrame frame, LocalAccessor local, long value, @Bind BytecodeNode bytecode) {
            local.setLong(bytecode, frame, value);
            return value;
        }

        @Specialization(replaces={"doInt", "doDouble", "doLong"})
        public static Object doObject(VirtualFrame frame, LocalAccessor local, Object value, @Bind BytecodeNode bytecode) {
            local.setObject(bytecode, frame, value);
            return value;
        }
    }

    public static final class BuildString {
        @Specialization
        public static Object perform(int length, Object[] strings, @Cached TruffleStringBuilder.AppendStringNode appendNode, @Cached TruffleStringBuilder.ToStringNode toString) {
            TruffleStringBuilder tsb = TruffleStringBuilderUTF32.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            CompilerAsserts.partialEvaluationConstant((int)length);
            for (int i = 0; i < length; ++i) {
                appendNode.execute(tsb, (AbstractTruffleString)((TruffleString)strings[i]));
            }
            return toString.execute(tsb);
        }
    }

    public static final class AsyncContextManagerExit {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static void doExceptional(VirtualFrame frame, Object exception, Object result, @Bind Node inliningTarget, @Bind PBytecodeDSLRootNode rootNode, @Cached CallQuaternaryMethodNode callExit, @Cached GetClassNode getClass, @Cached ExceptionNodes.GetTracebackNode getTraceback, @Cached PyObjectIsTrueNode isTrue) {
            if (!isTrue.execute((Frame)frame, result)) {
                if (exception instanceof PException) {
                    throw ((PException)((Object)exception)).getExceptionForReraise(!rootNode.isInternal());
                }
                if (exception instanceof AbstractTruffleException) {
                    throw (AbstractTruffleException)((Object)exception);
                }
                throw CompilerDirectives.shouldNotReachHere((String)"Exception not on stack");
            }
        }
    }

    public static final class AsyncContextManagerCallExit {
        @Specialization
        public static Object doRegular(VirtualFrame frame, PNone none, Object exit, Object contextManager, @Cached.Shared @Cached CallQuaternaryMethodNode callExit) {
            return callExit.execute((Frame)frame, exit, contextManager, PNone.NONE, PNone.NONE, PNone.NONE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doExceptional(VirtualFrame frame, Object exception, Object exit, Object contextManager, @Bind Node inliningTarget, @Bind PBytecodeDSLRootNode rootNode, @Cached.Shared @Cached CallQuaternaryMethodNode callExit, @Cached GetClassNode getClass, @Cached ExceptionNodes.GetTracebackNode getTraceback, @Cached PyObjectIsTrueNode isTrue) {
            AbstractTruffleException savedExcState = PArguments.getException((Frame)frame);
            try {
                Object pythonException = exception;
                if (exception instanceof PException) {
                    PArguments.setException((Frame)frame, (AbstractTruffleException)((PException)((Object)exception)));
                    pythonException = ((PException)((Object)exception)).getEscapedException();
                }
                Object excType = getClass.execute(inliningTarget, pythonException);
                Object excTraceback = getTraceback.execute(inliningTarget, pythonException);
                Object object = callExit.execute((Frame)frame, exit, contextManager, excType, pythonException, excTraceback);
                return object;
            }
            finally {
                PArguments.setException((Frame)frame, savedExcState);
            }
        }
    }

    public static final class AsyncContextManagerEnter {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static void doEnter(VirtualFrame frame, LocalAccessor exitSetter, LocalAccessor resultSetter, Object contextManager, @Bind Node inliningTarget, @Bind BytecodeNode bytecode, @Cached GetClassNode getClass, @Cached LookupSpecialMethodNode.Dynamic lookupEnter, @Cached LookupSpecialMethodNode.Dynamic lookupExit, @Cached CallUnaryMethodNode callEnter, @Cached PRaiseNode raiseNode) {
            Object type = getClass.execute(inliningTarget, contextManager);
            Object enter = lookupEnter.execute((Frame)frame, inliningTarget, type, SpecialMethodNames.T___AENTER__, contextManager);
            if (enter == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.AttributeError, new Object[]{SpecialMethodNames.T___AENTER__});
            }
            Object exit = lookupExit.execute((Frame)frame, inliningTarget, type, SpecialMethodNames.T___AEXIT__, contextManager);
            if (exit == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.AttributeError, new Object[]{SpecialMethodNames.T___AEXIT__});
            }
            Object result = callEnter.executeObject((Frame)frame, enter, contextManager);
            exitSetter.setObject(bytecode, frame, exit);
            resultSetter.setObject(bytecode, frame, result);
        }
    }

    public static final class ContextManagerExit {
        @Specialization
        public static void doRegular(VirtualFrame frame, PNone none, Object exit, Object contextManager, @Cached.Shared @Cached CallQuaternaryMethodNode callExit) {
            callExit.execute((Frame)frame, exit, contextManager, PNone.NONE, PNone.NONE, PNone.NONE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static void doExceptional(VirtualFrame frame, Object exception, Object exit, Object contextManager, @Bind Node inliningTarget, @Bind PBytecodeDSLRootNode rootNode, @Cached.Shared @Cached CallQuaternaryMethodNode callExit, @Cached GetClassNode getClass, @Cached ExceptionNodes.GetTracebackNode getTraceback, @Cached PyObjectIsTrueNode isTrue) {
            AbstractTruffleException savedExcState = PArguments.getException((Frame)frame);
            try {
                Object excTraceback;
                Object excType;
                Object result;
                Object pythonException = exception;
                if (exception instanceof PException) {
                    PException pException = (PException)((Object)exception);
                    PArguments.setException((Frame)frame, (AbstractTruffleException)pException);
                    pythonException = pException.getEscapedException();
                }
                if (!isTrue.execute((Frame)frame, result = callExit.execute((Frame)frame, exit, contextManager, excType = getClass.execute(inliningTarget, pythonException), pythonException, excTraceback = getTraceback.execute(inliningTarget, pythonException)))) {
                    if (exception instanceof PException) {
                        PException pException = (PException)((Object)exception);
                        throw pException.getExceptionForReraise(!rootNode.isInternal());
                    }
                    if (exception instanceof AbstractTruffleException) {
                        AbstractTruffleException ate = (AbstractTruffleException)((Object)exception);
                        throw ate;
                    }
                    throw CompilerDirectives.shouldNotReachHere((String)"Exception not on stack");
                }
            }
            finally {
                PArguments.setException((Frame)frame, savedExcState);
            }
        }
    }

    public static final class ContextManagerEnter {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static void doEnter(VirtualFrame frame, LocalAccessor exitSetter, LocalAccessor resultSetter, Object contextManager, @Bind Node inliningTarget, @Bind BytecodeNode bytecode, @Cached GetClassNode getClass, @Cached LookupSpecialMethodNode.Dynamic lookupEnter, @Cached LookupSpecialMethodNode.Dynamic lookupExit, @Cached CallUnaryMethodNode callEnter, @Cached PRaiseNode raiseNode) {
            Object type = getClass.execute(inliningTarget, contextManager);
            Object enter = lookupEnter.execute((Frame)frame, inliningTarget, type, SpecialMethodNames.T___ENTER__, contextManager);
            if (enter == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.N_OBJECT_DOES_NOT_SUPPORT_CONTEXT_MANAGER_PROTOCOL, type);
            }
            Object exit = lookupExit.execute((Frame)frame, inliningTarget, type, SpecialMethodNames.T___EXIT__, contextManager);
            if (exit == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.N_OBJECT_DOES_NOT_SUPPORT_CONTEXT_MANAGER_PROTOCOL_EXIT, type);
            }
            Object result = callEnter.executeObject((Frame)frame, enter, contextManager);
            exitSetter.setObject(bytecode, frame, exit);
            resultSetter.setObject(bytecode, frame, result);
        }
    }

    public static final class CallVarargsMethod {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doCall(VirtualFrame frame, Object callable, Object[] args, PKeyword[] keywords, @Cached CallNode node) {
            return node.execute((Frame)frame, callable, args, keywords);
        }
    }

    public static final class CallQuaternaryMethod {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doCall(VirtualFrame frame, Object callable, Object arg0, Object arg1, Object arg2, Object arg3, @Cached CallQuaternaryMethodNode node) {
            return node.execute((Frame)frame, callable, arg0, arg1, arg2, arg3);
        }
    }

    public static final class CallTernaryMethod {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doCall(VirtualFrame frame, Object callable, Object arg0, Object arg1, Object arg2, @Cached CallTernaryMethodNode node) {
            return node.execute((Frame)frame, callable, arg0, arg1, arg2);
        }
    }

    public static final class CallBinaryMethod {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doObject(VirtualFrame frame, Object callable, Object arg0, Object arg1, @Cached CallBinaryMethodNode node) {
            return node.executeObject((Frame)frame, callable, arg0, arg1);
        }
    }

    public static final class CallUnaryMethod {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doCall(VirtualFrame frame, Object callable, Object arg0, @Cached CallUnaryMethodNode node) {
            return node.executeObject((Frame)frame, callable, arg0);
        }
    }

    public static final class CallNilaryMethod {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doCall(VirtualFrame frame, Object callable, @Cached CallNode node) {
            return node.execute((Frame)frame, callable, PythonUtils.EMPTY_OBJECT_ARRAY, PKeyword.EMPTY_KEYWORDS);
        }
    }

    @ImportStatic(value={PGuards.class})
    public static final class UnpackEx {
        @Specialization(guards={"isBuiltinSequence(sequence)"})
        public static Object[] doUnpackSequence(VirtualFrame localFrame, int countBefore, int countAfter, PSequence sequence, @Bind Node inliningTarget, @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemSliceNode getItemSliceNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, sequence);
            int len = storage.length();
            int starLen = len - countBefore - countAfter;
            if (starLen < 0) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK_EX, countBefore + countAfter, len);
            }
            Object[] result = new Object[countBefore + 1 + countAfter];
            UnpackEx.copyItemsToArray(inliningTarget, storage, 0, result, 0, countBefore, getItemNode);
            result[countBefore] = PFactory.createList(PythonLanguage.get(inliningTarget), getItemSliceNode.execute(storage, countBefore, countBefore + starLen, 1, starLen));
            UnpackEx.copyItemsToArray(inliningTarget, storage, len - countAfter, result, countBefore + 1, countAfter, getItemNode);
            return result;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object[] doUnpackIterable(VirtualFrame virtualFrame, int countBefore, int countAfter, Object collection, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile notIterableProfile, @Cached ListNodes.ConstructListNode constructListNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemSliceNode getItemSliceNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object iterator;
            try {
                iterator = getIter.execute((Frame)virtualFrame, inliningTarget, collection);
            }
            catch (PException e) {
                e.expectTypeError(inliningTarget, notIterableProfile);
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_UNPACK_NON_ITERABLE, collection);
            }
            Object[] result = new Object[countBefore + 1 + countAfter];
            UnpackEx.copyItemsToArray(virtualFrame, inliningTarget, iterator, result, 0, countBefore, countBefore + countAfter, getNextNode, raiseNode);
            PList starAndAfter = constructListNode.execute((Frame)virtualFrame, iterator);
            SequenceStorage storage = starAndAfter.getSequenceStorage();
            int lenAfter = storage.length();
            if (lenAfter < countAfter) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK_EX, countBefore + countAfter, countBefore + lenAfter);
            }
            if (countAfter == 0) {
                result[countBefore] = starAndAfter;
            } else {
                int starLen = lenAfter - countAfter;
                PList starList = PFactory.createList(PythonLanguage.get(inliningTarget), getItemSliceNode.execute(storage, 0, starLen, 1, starLen));
                result[countBefore] = starList;
                UnpackEx.copyItemsToArray(inliningTarget, storage, starLen, result, countBefore + 1, countAfter, getItemNode);
            }
            return result;
        }

        private static void copyItemsToArray(VirtualFrame frame, Node inliningTarget, Object iterator, Object[] destination, int destinationOffset, int length, int totalLength, PyIterNextNode getNextNode, PRaiseNode raiseNode) {
            CompilerAsserts.partialEvaluationConstant((int)destinationOffset);
            CompilerAsserts.partialEvaluationConstant((int)length);
            CompilerAsserts.partialEvaluationConstant((int)totalLength);
            for (int i = 0; i < length; ++i) {
                try {
                    Object value;
                    destination[destinationOffset + i] = value = getNextNode.execute((Frame)frame, inliningTarget, iterator);
                    continue;
                }
                catch (IteratorExhausted e) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK_EX, totalLength, destinationOffset + i);
                }
            }
        }

        private static void copyItemsToArray(Node inliningTarget, SequenceStorage source, int sourceOffset, Object[] destination, int destinationOffset, int length, SequenceStorageNodes.GetItemScalarNode getItemNode) {
            CompilerAsserts.partialEvaluationConstant((int)sourceOffset);
            CompilerAsserts.partialEvaluationConstant((int)destinationOffset);
            CompilerAsserts.partialEvaluationConstant((int)length);
            for (int i = 0; i < length; ++i) {
                destination[destinationOffset + i] = getItemNode.execute(inliningTarget, source, sourceOffset + i);
            }
        }
    }

    @ImportStatic(value={PGuards.class})
    public static final class UnpackSequence {
        @Specialization(guards={"isBuiltinSequence(sequence)"})
        public static Object[] doUnpackSequence(VirtualFrame localFrame, int count, PSequence sequence, @Bind Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            CompilerAsserts.partialEvaluationConstant((int)count);
            SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, sequence);
            int len = storage.length();
            if (len != count) {
                throw UnpackSequence.raiseError(inliningTarget, raiseNode, len, count);
            }
            Object[] result = new Object[len];
            for (int i = 0; i < count; ++i) {
                result[i] = getItemNode.execute(inliningTarget, storage, i);
            }
            return result;
        }

        @HostCompilerDirectives.InliningCutoff
        private static PException raiseError(Node inliningTarget, PRaiseNode raiseNode, int len, int count) {
            if (len < count) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK, count, len);
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.TOO_MANY_VALUES_TO_UNPACK, count);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object[] doUnpackIterable(VirtualFrame virtualFrame, int count, Object collection, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile notIterableProfile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object iterator;
            CompilerAsserts.partialEvaluationConstant((int)count);
            try {
                iterator = getIter.execute((Frame)virtualFrame, inliningTarget, collection);
            }
            catch (PException e) {
                e.expectTypeError(inliningTarget, notIterableProfile);
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_UNPACK_NON_ITERABLE, collection);
            }
            Object[] result = new Object[count];
            for (int i = 0; i < count; ++i) {
                try {
                    Object value;
                    result[i] = value = getNextNode.execute((Frame)virtualFrame, inliningTarget, iterator);
                    continue;
                }
                catch (IteratorExhausted e) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK, count, i);
                }
            }
            try {
                Object i = getNextNode.execute((Frame)virtualFrame, inliningTarget, iterator);
            }
            catch (IteratorExhausted e) {
                return result;
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.TOO_MANY_VALUES_TO_UNPACK, count);
        }
    }

    @ImportStatic(value={PGuards.class})
    public static final class UnpackStarred {
        public static boolean isListOrTuple(PSequence obj, Node inliningTarget, InlinedConditionProfile isListProfile) {
            return isListProfile.profile(inliningTarget, PGuards.isBuiltinList(obj)) || PGuards.isBuiltinTuple(obj);
        }

        @Specialization(guards={"isListOrTuple(seq, inliningTarget, isListProfile)"}, limit="1")
        static Object[] fromListOrTuple(PSequence seq, @Bind Node inliningTarget, @Cached InlinedConditionProfile isListProfile, @Cached.Exclusive @Cached SequenceNodes.GetPSequenceStorageNode getStorage, @Cached.Exclusive @Cached SequenceStorageNodes.ToArrayNode toArrayNode) {
            return toArrayNode.execute(inliningTarget, getStorage.execute(inliningTarget, seq));
        }

        @Specialization(guards={"isNoValue(none)"})
        static Object[] none(PNone none) {
            return PythonUtils.EMPTY_OBJECT_ARRAY;
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        public static Object[] doUnpackIterable(VirtualFrame virtualFrame, Object collection, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile notIterableProfile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object iterator;
            try {
                iterator = getIter.execute((Frame)virtualFrame, inliningTarget, collection);
            }
            catch (PException e) {
                e.expectTypeError(inliningTarget, notIterableProfile);
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_UNPACK_NON_ITERABLE, collection);
            }
            ArrayBuilder<Object> result = new ArrayBuilder<Object>();
            try {
                while (true) {
                    Object item = getNextNode.execute((Frame)virtualFrame, inliningTarget, iterator);
                    result.add(item);
                }
            }
            catch (IteratorExhausted e) {
                return result.toArray(new Object[0]);
            }
        }
    }

    public static final class KwargsMerge {
        @Specialization
        public static PDict doMerge(VirtualFrame frame, LocalAccessor callee, PDict dict, Object toMerge, @Bind PBytecodeDSLRootNode rootNode, @Bind Node inliningTarget, @Bind BytecodeNode bytecodeNode, @Cached ConcatDictToStorageNode concatNode, @Cached PRaiseNode raise) {
            try {
                HashingStorage resultStorage = concatNode.execute(frame, dict.getDictStorage(), toMerge);
                dict.setDictStorage(resultStorage);
            }
            catch (SameDictKeyException e) {
                throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_GOT_MULTIPLE_VALUES_FOR_KEYWORD_ARG, PyObjectFunctionStr.execute(callee.getObject(bytecodeNode, frame)), e.getKey());
            }
            catch (NonMappingException e) {
                throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ARG_AFTER_MUST_BE_MAPPING, PyObjectFunctionStr.execute(callee.getObject(bytecodeNode, frame)), toMerge);
            }
            return dict;
        }
    }

    public static final class Unstar {
        @Specialization(guards={"length != 1"})
        public static Object[] perform(Object[] values, int length) {
            assert (length > 1);
            CompilerAsserts.partialEvaluationConstant((int)length);
            int totalLength = 0;
            for (int i = 0; i < length; ++i) {
                totalLength += ((Object[])values[i]).length;
            }
            Object[] result = new Object[totalLength];
            int idx = 0;
            for (int i = 0; i < length; ++i) {
                int nl = ((Object[])values[i]).length;
                System.arraycopy(values[i], 0, result, idx, nl);
                idx += nl;
            }
            return result;
        }
    }

    public static final class MakeCellArray {
        @Specialization
        public static PCell[] doMakeCellArray(Object[] cells) {
            return PCell.toCellArray(cells);
        }
    }

    public static final class StoreRange {
        @Specialization
        public static void perform(VirtualFrame frame, LocalRangeAccessor locals, Object[] values, @Bind BytecodeNode bytecode) {
            CompilerAsserts.partialEvaluationConstant((int)locals.getLength());
            assert (values.length == locals.getLength());
            for (int i = 0; i < locals.getLength(); ++i) {
                locals.setObject(bytecode, frame, i, values[i]);
            }
        }
    }

    public static final class LoadClosure {
        @Specialization
        public static PCell[] doLoadClosure(VirtualFrame frame) {
            return PArguments.getClosure((Frame)frame);
        }
    }

    public static final class ClearLocal {
        @Specialization
        public static void doClearLocal(VirtualFrame frame, LocalAccessor localAccessor, @Bind BytecodeNode bytecode) {
            localAccessor.setObject(bytecode, frame, null);
        }
    }

    public static final class ClearCell {
        @Specialization
        public static void doClearCell(int index, PCell cell, @Bind PBytecodeDSLRootNode rootNode, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            PBytecodeDSLRootNode.checkUnboundCell(cell, index, rootNode, inliningTarget, raiseNode);
            cell.clearRef();
        }
    }

    public static final class CreateCell {
        @Specialization
        public static PCell doCreateCell(Object value) {
            PCell cell = new PCell(Assumption.create());
            cell.setRef(value);
            return cell;
        }
    }

    public static final class StoreCell {
        @Specialization
        public static void doStoreCell(PCell cell, Object value) {
            cell.setRef(value);
        }
    }

    public static final class LoadSpecialArgument {
        @Specialization
        public static Object doLoadCell(VirtualFrame frame) {
            return PArguments.getSpecialArgument((Frame)frame);
        }
    }

    public static final class LoadFromDictOrGlobals {
        @Specialization
        public static Object doLoadCell(VirtualFrame frame, TruffleString name, Object dict, @Bind PBytecodeDSLRootNode rootNode, @Bind Node inliningTarget, @Cached PyObjectGetItem getItemNode, @Cached ReadGlobalOrBuiltinNode readGlobal, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            Object value;
            try {
                value = getItemNode.execute((Frame)frame, inliningTarget, dict, name);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonErrorType.KeyError, errorProfile);
                value = readGlobal.read((Frame)frame, PArguments.getGlobals((Frame)frame), name);
            }
            return value;
        }
    }

    public static final class LoadFromDictOrCell {
        @Specialization
        public static Object doLoadCell(VirtualFrame frame, int index, Object locals, PCell cell, @Bind PBytecodeDSLRootNode rootNode, @Bind Node inliningTarget, @Cached ReadFromLocalsNode readLocalsNode, @Cached PRaiseNode raiseNode) {
            BytecodeDSLCodeUnit co = rootNode.getCodeUnit();
            TruffleString name = index < co.cellvars.length ? co.cellvars[index] : co.freevars[index - co.cellvars.length];
            Object value = readLocalsNode.execute(frame, inliningTarget, locals, name);
            if (value != PNone.NO_VALUE) {
                return value;
            }
            return PBytecodeDSLRootNode.checkUnboundCell(cell, index, rootNode, inliningTarget, raiseNode);
        }
    }

    public static final class LoadCell {
        @Specialization
        public static Object doLoadCell(int index, PCell cell, @Bind PBytecodeDSLRootNode rootNode, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            return PBytecodeDSLRootNode.checkUnboundCell(cell, index, rootNode, inliningTarget, raiseNode);
        }
    }

    public static final class AssertFailed {
        @Specialization
        public static void doAssertFailed(VirtualFrame frame, Object assertionMessage, @Bind PBytecodeDSLRootNode rooNode) {
            if (assertionMessage == PNone.NO_VALUE) {
                throw PRaiseNode.raiseStatic((Node)rooNode, PythonErrorType.AssertionError);
            }
            throw PRaiseNode.raiseStatic((Node)rooNode, PythonErrorType.AssertionError, new Object[]{assertionMessage});
        }
    }

    public static final class MarkExceptionAsCaught {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static void doPException(VirtualFrame frame, PException ex, @Bind PBytecodeDSLRootNode rootNode) {
            ex.markAsCaught((Frame)frame, rootNode);
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        public static void doNothing(Object ex) {
        }
    }

    public static final class SetCurrentException {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static void doPException(VirtualFrame frame, AbstractTruffleException ex) {
            PArguments.setException((Frame)frame, ex);
        }
    }

    public static final class GetCurrentException {
        @Specialization
        public static AbstractTruffleException doPException(VirtualFrame frame) {
            return PArguments.getException((Frame)frame);
        }
    }

    public static final class Throw {
        @Specialization
        public static void doAbstractTruffleException(AbstractTruffleException ex) {
            throw ex;
        }
    }

    public static final class Reraise {
        @Specialization
        public static void doPException(PException ex, @Bind PBytecodeDSLRootNode root) {
            throw ex.getExceptionForReraise(!root.isInternal());
        }

        @Specialization
        public static void doAbstractTruffleException(AbstractTruffleException ex) {
            throw ex;
        }
    }

    public static final class Raise {
        @Specialization
        public static void perform(VirtualFrame frame, Object typeOrExceptionObject, Object cause, @Bind PBytecodeDSLRootNode root, @Cached RaiseNode raiseNode) {
            raiseNode.execute(frame, typeOrExceptionObject, cause, !root.isInternal());
        }
    }

    public static final class ImportStar {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static void doImport(VirtualFrame frame, TruffleString name, int level, @Cached(value="create(name, level)") ImportStarNode node) {
            node.execute(frame, name, level);
        }

        @NeverDefault
        static ImportStarNode create(TruffleString name, int level) {
            return ImportStarNode.create();
        }
    }

    public static final class ImportFrom {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doImport(VirtualFrame frame, TruffleString name, Object module, @Cached ImportFromNode node) {
            return node.execute((Frame)frame, module, name);
        }
    }

    public static final class Import {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doImport(VirtualFrame frame, TruffleString name, TruffleString[] fromList, int level, @Cached ImportNode node) {
            return node.execute(frame, name, PArguments.getGlobals((Frame)frame), fromList, level);
        }
    }

    public static final class Ne {
        @Specialization
        public static boolean cmp(int left, int right) {
            return left != right;
        }

        @Specialization
        public static boolean cmp(long left, long right) {
            return left != right;
        }

        @Specialization
        public static boolean cmp(char left, char right) {
            return left != right;
        }

        @Specialization
        public static boolean cmp(byte left, byte right) {
            return left != right;
        }

        @Specialization
        public static boolean cmp(double left, double right) {
            return left != right;
        }

        @Specialization
        public static boolean cmp(TruffleString left, TruffleString right, @Cached TruffleString.EqualNode equalNode) {
            return !equalNode.execute((AbstractTruffleString)left, (AbstractTruffleString)right, PythonUtils.TS_ENCODING);
        }

        @Specialization
        public static boolean cmp(int left, double right) {
            return (double)left != right;
        }

        @Specialization
        public static boolean cmp(double left, int right) {
            return left != (double)right;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached PyObjectRichCompare.GenericRichCompare richCompareNode) {
            return richCompareNode.execute(frame, left, right, RichCmpOp.Py_NE);
        }
    }

    public static final class Eq {
        @Specialization
        public static boolean cmp(int left, int right) {
            return left == right;
        }

        @Specialization
        public static boolean cmp(long left, long right) {
            return left == right;
        }

        @Specialization
        public static boolean cmp(char left, char right) {
            return left == right;
        }

        @Specialization
        public static boolean cmp(byte left, byte right) {
            return left == right;
        }

        @Specialization
        public static boolean cmp(double left, double right) {
            return left == right;
        }

        @Specialization
        public static boolean cmp(TruffleString left, TruffleString right, @Cached TruffleString.EqualNode equalNode) {
            return equalNode.execute((AbstractTruffleString)left, (AbstractTruffleString)right, PythonUtils.TS_ENCODING);
        }

        @Specialization
        public static boolean cmp(int left, double right) {
            return (double)left == right;
        }

        @Specialization
        public static boolean cmp(double left, int right) {
            return left == (double)right;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached PyObjectRichCompare.GenericRichCompare richCompareNode) {
            return richCompareNode.execute(frame, left, right, RichCmpOp.Py_EQ);
        }
    }

    public static final class Gt {
        @Specialization
        public static boolean cmp(int left, int right) {
            return left > right;
        }

        @Specialization
        public static boolean cmp(long left, long right) {
            return left > right;
        }

        @Specialization
        public static boolean cmp(char left, char right) {
            return left > right;
        }

        @Specialization
        public static boolean cmp(byte left, byte right) {
            return left > right;
        }

        @Specialization
        public static boolean cmp(double left, double right) {
            return left > right;
        }

        @Specialization
        public static boolean cmp(int left, double right) {
            return (double)left > right;
        }

        @Specialization
        public static boolean cmp(double left, int right) {
            return left > (double)right;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static final Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached PyObjectRichCompare.GenericRichCompare richCompareNode) {
            return richCompareNode.execute(frame, left, right, RichCmpOp.Py_GT);
        }
    }

    public static final class Ge {
        @Specialization
        public static boolean cmp(int left, int right) {
            return left >= right;
        }

        @Specialization
        public static boolean cmp(long left, long right) {
            return left >= right;
        }

        @Specialization
        public static boolean cmp(char left, char right) {
            return left >= right;
        }

        @Specialization
        public static boolean cmp(byte left, byte right) {
            return left >= right;
        }

        @Specialization
        public static boolean cmp(double left, double right) {
            return left >= right;
        }

        @Specialization
        public static boolean cmp(int left, double right) {
            return (double)left >= right;
        }

        @Specialization
        public static boolean cmp(double left, int right) {
            return left >= (double)right;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached PyObjectRichCompare.GenericRichCompare richCompareNode) {
            return richCompareNode.execute(frame, left, right, RichCmpOp.Py_GE);
        }
    }

    public static final class Lt {
        @Specialization
        public static boolean cmp(int left, int right) {
            return left < right;
        }

        @Specialization
        public static boolean cmp(long left, long right) {
            return left < right;
        }

        @Specialization
        public static boolean cmp(char left, char right) {
            return left < right;
        }

        @Specialization
        public static boolean cmp(byte left, byte right) {
            return left < right;
        }

        @Specialization
        public static boolean cmp(double left, double right) {
            return left < right;
        }

        @Specialization
        public static boolean cmp(int left, double right) {
            return (double)left < right;
        }

        @Specialization
        public static boolean cmp(double left, int right) {
            return left < (double)right;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached PyObjectRichCompare.GenericRichCompare richCompareNode) {
            return richCompareNode.execute(frame, left, right, RichCmpOp.Py_LT);
        }
    }

    public static final class Le {
        @Specialization
        public static boolean cmp(int left, int right) {
            return left <= right;
        }

        @Specialization
        public static boolean cmp(long left, long right) {
            return left <= right;
        }

        @Specialization
        public static boolean cmp(char left, char right) {
            return left <= right;
        }

        @Specialization
        public static boolean cmp(byte left, byte right) {
            return left <= right;
        }

        @Specialization
        public static boolean cmp(double left, double right) {
            return left <= right;
        }

        @Specialization
        public static boolean cmp(int left, double right) {
            return (double)left <= right;
        }

        @Specialization
        public static boolean cmp(double left, int right) {
            return left <= (double)right;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached PyObjectRichCompare.GenericRichCompare richCompareNode) {
            return richCompareNode.execute(frame, left, right, RichCmpOp.Py_LE);
        }
    }

    @ImportStatic(value={PGuards.class})
    public static final class UnpackStarredToLocals {
        @Specialization(guards={"isBuiltinSequence(sequence)"})
        public static void doUnpackSequence(VirtualFrame localFrame, int starIndex, LocalRangeAccessor results, PSequence sequence, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemSliceNode getItemSliceNode, @Bind PBytecodeDSLRootNode rootNode, @Bind BytecodeNode bytecode, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            int resultsLength = results.getLength();
            int countBefore = starIndex;
            int countAfter = resultsLength - starIndex - 1;
            SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, sequence);
            int len = storage.length();
            int starLen = len - resultsLength + 1;
            if (starLen < 0) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK_EX, countBefore + countAfter, len);
            }
            UnpackStarredToLocals.copyToLocalsFromSequence(storage, 0, 0, countBefore, results, localFrame, inliningTarget, bytecode, getItemNode);
            PList starList = PFactory.createList(rootNode.getLanguage(), getItemSliceNode.execute(storage, countBefore, countBefore + starLen, 1, starLen));
            results.setObject(bytecode, localFrame, starIndex, (Object)starList);
            UnpackStarredToLocals.copyToLocalsFromSequence(storage, starIndex + 1, len - countAfter, countAfter, results, localFrame, inliningTarget, bytecode, getItemNode);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static void doUnpackIterable(VirtualFrame frame, int starIndex, LocalRangeAccessor results, Object collection, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile notIterableProfile, @Cached ListNodes.ConstructListNode constructListNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemSliceNode getItemSliceNode, @Bind PBytecodeDSLRootNode rootNode, @Bind BytecodeNode bytecode, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            Object iterator;
            int resultsLength = results.getLength();
            int countBefore = starIndex;
            int countAfter = resultsLength - starIndex - 1;
            try {
                iterator = getIter.execute((Frame)frame, inliningTarget, collection);
            }
            catch (PException e) {
                e.expectTypeError(inliningTarget, notIterableProfile);
                throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_UNPACK_NON_ITERABLE, collection);
            }
            UnpackStarredToLocals.copyToLocalsFromIterator(frame, inliningTarget, iterator, countBefore, results, bytecode, countBefore + countAfter, getNextNode, raiseNode);
            PList starAndAfter = constructListNode.execute((Frame)frame, iterator);
            SequenceStorage storage = starAndAfter.getSequenceStorage();
            int lenAfter = storage.length();
            if (lenAfter < countAfter) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK_EX, countBefore + countAfter, countBefore + lenAfter);
            }
            if (countAfter == 0) {
                results.setObject(bytecode, frame, starIndex, (Object)starAndAfter);
            } else {
                int starLen = lenAfter - countAfter;
                PList starList = PFactory.createList(rootNode.getLanguage(), getItemSliceNode.execute(storage, 0, starLen, 1, starLen));
                results.setObject(bytecode, frame, starIndex, (Object)starList);
                UnpackStarredToLocals.copyToLocalsFromSequence(storage, starIndex + 1, starLen, countAfter, results, frame, inliningTarget, bytecode, getItemNode);
            }
        }

        private static void copyToLocalsFromIterator(VirtualFrame frame, Node inliningTarget, Object iterator, int length, LocalRangeAccessor results, BytecodeNode bytecode, int requiredLength, PyIterNextNode getNextNode, PRaiseNode raiseNode) {
            CompilerAsserts.partialEvaluationConstant((int)length);
            for (int i = 0; i < length; ++i) {
                try {
                    Object item = getNextNode.execute((Frame)frame, inliningTarget, iterator);
                    results.setObject(bytecode, frame, i, item);
                    continue;
                }
                catch (IteratorExhausted e) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK_EX, requiredLength, i);
                }
            }
        }

        private static void copyToLocalsFromSequence(SequenceStorage storage, int runOffset, int offset, int length, LocalRangeAccessor run, VirtualFrame localFrame, Node inliningTarget, BytecodeNode bytecode, SequenceStorageNodes.GetItemScalarNode getItemNode) {
            CompilerAsserts.partialEvaluationConstant((int)length);
            for (int i = 0; i < length; ++i) {
                run.setObject(bytecode, localFrame, runOffset + i, getItemNode.execute(inliningTarget, storage, offset + i));
            }
        }
    }

    @ImportStatic(value={PGuards.class})
    public static final class UnpackToLocals {
        @Specialization(guards={"isBuiltinSequence(sequence)"})
        public static void doUnpackSequence(VirtualFrame localFrame, LocalRangeAccessor results, PSequence sequence, @Bind Node inliningTarget, @Bind BytecodeNode bytecode, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, sequence);
            int len = storage.length();
            int count = results.getLength();
            CompilerAsserts.partialEvaluationConstant((int)count);
            if (len != count) {
                UnpackToLocals.raiseError(inliningTarget, raiseNode, len, count);
            }
            for (int i = 0; i < count; ++i) {
                results.setObject(bytecode, localFrame, i, getItemNode.execute(inliningTarget, storage, i));
            }
        }

        @HostCompilerDirectives.InliningCutoff
        private static void raiseError(Node inliningTarget, PRaiseNode raiseNode, int len, int count) {
            if (len < count) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK, count, len);
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.TOO_MANY_VALUES_TO_UNPACK, count);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static void doUnpackIterable(VirtualFrame virtualFrame, LocalRangeAccessor results, Object collection, @Bind Node inliningTarget, @Bind BytecodeNode bytecode, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile notIterableProfile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object iterator;
            int count = results.getLength();
            CompilerAsserts.partialEvaluationConstant((int)count);
            try {
                iterator = getIter.execute((Frame)virtualFrame, inliningTarget, collection);
            }
            catch (PException e) {
                e.expectTypeError(inliningTarget, notIterableProfile);
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_UNPACK_NON_ITERABLE, collection);
            }
            for (int i = 0; i < count; ++i) {
                try {
                    Object value = getNextNode.execute((Frame)virtualFrame, inliningTarget, iterator);
                    results.setObject(bytecode, virtualFrame, i, value);
                    continue;
                }
                catch (IteratorExhausted e) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK, count, i);
                }
            }
            try {
                Object i = getNextNode.execute((Frame)virtualFrame, inliningTarget, iterator);
            }
            catch (IteratorExhausted e) {
                return;
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.TOO_MANY_VALUES_TO_UNPACK, count);
        }
    }

    public static final class SetItem {
        @Specialization
        public static void doIt(VirtualFrame frame, Object value, Object primary, Object slice, @Bind Node inliningTarget, @Cached.Shared @Cached PyObjectSetItem setItemNode) {
            setItemNode.execute((Frame)frame, inliningTarget, primary, slice, value);
        }
    }

    public static final class LiteralBoolean {
        @Specialization
        public static boolean doBoolean(boolean value) {
            return value;
        }
    }

    public static final class SetDictItem {
        @Specialization
        public static void perform(VirtualFrame frame, PDict item, Object key, Object value, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageSetItem setItem) {
            item.setDictStorage(setItem.execute((Frame)frame, inliningTarget, item.getDictStorage(), key, value));
        }
    }

    public static final class MakeDict {
        @Specialization(guards={"entries == 0"})
        public static PDict empty(VirtualFrame frame, int entries, Object[] keysAndValues, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createDict(rootNode.getLanguage());
        }

        @Specialization
        public static PDict empty(VirtualFrame frame, int entries, Object[] keysAndValues, @Bind PBytecodeDSLRootNode rootNode, @Bind Node inliningTarget, @Cached PyObjectHashNode hashNode, @Cached ObjectHashMap.PutNode putNode, @Cached DictNodes.UpdateNode updateNode) {
            if (keysAndValues.length != entries * 2) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            ObjectHashMap map = new ObjectHashMap(keysAndValues.length / 2);
            PDict dict = PFactory.createDict(rootNode.getLanguage(), new EconomicMapStorage(map, false));
            for (int i = 0; i < entries; ++i) {
                Object key = keysAndValues[i * 2];
                Object value = keysAndValues[i * 2 + 1];
                if (key == PNone.NO_VALUE) {
                    EconomicMapStorage es;
                    HashingStorage hashingStorage;
                    updateNode.execute((Frame)frame, dict, value);
                    assert ((hashingStorage = dict.getDictStorage()) instanceof EconomicMapStorage && (es = (EconomicMapStorage)hashingStorage).mapIsEqualTo(map));
                    continue;
                }
                long hash = hashNode.execute((Frame)frame, inliningTarget, key);
                putNode.put((Frame)frame, inliningTarget, map, key, hash, value);
            }
            return dict;
        }
    }

    public static final class MappingToKeywords {
        @Specialization
        public static PKeyword[] perform(Object sourceCollection, @Bind Node inliningTarget, @Cached ExpandKeywordStarargsNode expandKeywordStarargsNode, @Cached PRaiseNode raise) {
            return expandKeywordStarargsNode.execute(inliningTarget, sourceCollection);
        }
    }

    public static final class MakeKeywords {
        @Specialization
        public static PKeyword[] perform(Object[] values, TruffleString[] keys) {
            CompilerAsserts.partialEvaluationConstant((int)keys.length);
            PKeyword[] result = new PKeyword[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                result[i] = new PKeyword(keys[i], values[i]);
            }
            return result;
        }
    }

    public static final class MakeSlice {
        @Specialization
        public static Object doIII(int start, int end, int step, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createIntSlice(rootNode.getLanguage(), start, end, step);
        }

        @Specialization
        public static Object doNIN(PNone start, int end, PNone step, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createIntSlice(rootNode.getLanguage(), 0, end, 1, true, true);
        }

        @Specialization
        public static Object doIIN(int start, int end, PNone step, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createIntSlice(rootNode.getLanguage(), start, end, 1, false, true);
        }

        @Specialization
        public static Object doNII(PNone start, int end, int step, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createIntSlice(rootNode.getLanguage(), 0, end, step, true, false);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doGeneric(Object start, Object end, Object step, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createObjectSlice(rootNode.getLanguage(), start, end, step);
        }
    }

    public static final class MakeConstantObjectTuple {
        @Specialization
        public static PTuple perform(Object[] array, @Bind PBytecodeDSLRootNode rootNode) {
            ObjectSequenceStorage storage = new ObjectSequenceStorage(array);
            return PFactory.createTuple(rootNode.getLanguage(), storage);
        }
    }

    public static final class MakeConstantDoubleTuple {
        @Specialization
        public static PTuple perform(double[] array, @Bind PBytecodeDSLRootNode rootNode) {
            DoubleSequenceStorage storage = new DoubleSequenceStorage(array);
            return PFactory.createTuple(rootNode.getLanguage(), storage);
        }
    }

    public static final class MakeConstantBooleanTuple {
        @Specialization
        public static PTuple perform(boolean[] array, @Bind PBytecodeDSLRootNode rootNode) {
            BoolSequenceStorage storage = new BoolSequenceStorage(array);
            return PFactory.createTuple(rootNode.getLanguage(), storage);
        }
    }

    public static final class MakeConstantLongTuple {
        @Specialization
        public static PTuple perform(long[] array, @Bind PBytecodeDSLRootNode rootNode) {
            LongSequenceStorage storage = new LongSequenceStorage(array);
            return PFactory.createTuple(rootNode.getLanguage(), storage);
        }
    }

    public static final class MakeConstantIntTuple {
        @Specialization
        public static PTuple perform(int[] array, @Bind PBytecodeDSLRootNode rootNode) {
            IntSequenceStorage storage = new IntSequenceStorage(array);
            return PFactory.createTuple(rootNode.getLanguage(), storage);
        }
    }

    public static final class MakeConstantObjectList {
        @Specialization
        public static PList perform(Object[] array, @Bind PBytecodeDSLRootNode rootNode) {
            ObjectSequenceStorage storage = new ObjectSequenceStorage(PythonUtils.arrayCopyOf(array, array.length));
            return PFactory.createList(rootNode.getLanguage(), storage);
        }
    }

    public static final class MakeConstantDoubleList {
        @Specialization
        public static PList perform(double[] array, @Bind PBytecodeDSLRootNode rootNode) {
            DoubleSequenceStorage storage = new DoubleSequenceStorage(PythonUtils.arrayCopyOf(array, array.length));
            return PFactory.createList(rootNode.getLanguage(), storage);
        }
    }

    public static final class MakeConstantBooleanList {
        @Specialization
        public static PList perform(boolean[] array, @Bind PBytecodeDSLRootNode rootNode) {
            BoolSequenceStorage storage = new BoolSequenceStorage(PythonUtils.arrayCopyOf(array, array.length));
            return PFactory.createList(rootNode.getLanguage(), storage);
        }
    }

    public static final class MakeConstantLongList {
        @Specialization
        public static PList perform(long[] array, @Bind PBytecodeDSLRootNode rootNode) {
            LongSequenceStorage storage = new LongSequenceStorage(PythonUtils.arrayCopyOf(array, array.length));
            return PFactory.createList(rootNode.getLanguage(), storage);
        }
    }

    public static final class MakeConstantIntList {
        @Specialization
        public static PList perform(int[] array, @Bind PBytecodeDSLRootNode rootNode) {
            IntSequenceStorage storage = new IntSequenceStorage(PythonUtils.arrayCopyOf(array, array.length));
            return PFactory.createList(rootNode.getLanguage(), storage);
        }
    }

    public static final class MakeTuple {
        @Specialization
        public static Object perform(Object[] elements, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createTuple(rootNode.getLanguage(), elements);
        }
    }

    public static final class MakeFrozenSet {
        @Specialization(guards={"elements.length == 0"})
        public static PFrozenSet doEmpty(VirtualFrame frame, Object[] elements, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createFrozenSet(rootNode.getLanguage());
        }

        @Specialization(guards={"elements.length != 0"})
        public static PFrozenSet doNonEmpty(VirtualFrame frame, Object[] elements, @Bind PBytecodeDSLRootNode rootNode, @Bind Node inliningTarget, @Cached MakeSetStorageNode makeSetStorageNode) {
            return PFactory.createFrozenSet(rootNode.getLanguage(), makeSetStorageNode.execute(frame, inliningTarget, elements));
        }
    }

    @ImportStatic(value={PBytecodeDSLRootNode.class})
    public static final class MakeSet {
        @Specialization(guards={"elements.length == 0"})
        public static PSet doEmpty(VirtualFrame frame, Object[] elements, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createSet(rootNode.getLanguage());
        }

        @Specialization(guards={"elements.length != 0"})
        public static PSet doNonEmpty(VirtualFrame frame, Object[] elements, @Bind PBytecodeDSLRootNode rootNode, @Bind Node inliningTarget, @Cached MakeSetStorageNode makeSetStorageNode) {
            return PFactory.createSet(rootNode.getLanguage(), makeSetStorageNode.execute(frame, inliningTarget, elements));
        }
    }

    public static final class MakeList {
        @Specialization
        public static PList perform(Object[] elements, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createList(rootNode.getLanguage(), elements);
        }
    }

    public static final class LoadBuildClass {
        public static final TruffleString NAME = BuiltinNames.T___BUILD_CLASS__;

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object perform(VirtualFrame frame, @Cached ReadBuiltinNode readNode) {
            return readNode.execute(NAME);
        }
    }

    public static final class DeleteGlobal {
        @Specialization
        public static void perform(VirtualFrame frame, TruffleString name, @Cached DeleteGlobalNode deleteNode) {
            deleteNode.executeWithGlobals(frame, PArguments.getGlobals((Frame)frame), name);
        }
    }

    public static final class WriteGlobal {
        @Specialization
        public static void perform(VirtualFrame frame, TruffleString name, Object value, @Cached WriteGlobalNode writeNode) {
            writeNode.executeObject(frame, name, value);
        }
    }

    public static final class ReadGlobal {
        @Specialization
        public static Object perform(VirtualFrame frame, TruffleString name, @Cached ReadGlobalOrBuiltinNode readNode) {
            return readNode.execute(frame, name);
        }
    }

    public static final class DeleteItem {
        @Specialization
        public static void doWithFrame(VirtualFrame frame, Object primary, Object index, @Bind Node inliningTarget, @Cached PyObjectDelItem delItemNode) {
            delItemNode.execute((Frame)frame, inliningTarget, primary, index);
        }
    }

    public static final class DeleteAttribute {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static void doObject(VirtualFrame frame, TruffleString key, Object object, @Bind Node inliningTarget, @Cached PyObjectSetAttrO setAttrO) {
            setAttrO.execute((Frame)frame, inliningTarget, object, key, PNone.NO_VALUE);
        }
    }

    public static final class SetAttribute {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static void doIt(VirtualFrame frame, TruffleString key, Object value, Object object, @Bind Node inliningTarget, @Cached PyObjectSetAttr setAttrNode) {
            setAttrNode.execute((Frame)frame, inliningTarget, object, key, value);
        }
    }

    public static final class GetAttribute {
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static Object doIt(VirtualFrame frame, TruffleString name, Object obj, @Cached(value="create(name)") GetAttributeNode.GetFixedAttributeNode getAttributeNode) {
            return getAttributeNode.execute(frame, obj);
        }
    }

    public static final class GetMethod {
        @Specialization
        public static Object doIt(VirtualFrame frame, TruffleString name, Object obj, @Bind Node inliningTarget, @Cached PyObjectGetMethod getMethod) {
            return getMethod.execute((Frame)frame, inliningTarget, obj, name);
        }
    }

    public static final class ForIterate {
        @Specialization
        public static boolean doIntegerSequence(VirtualFrame frame, LocalAccessor output, PIntegerSequenceIterator iterator, @Bind BytecodeNode bytecode) {
            return ForIterate.doInteger(frame, output, iterator, bytecode);
        }

        @Specialization
        public static boolean doIntRange(VirtualFrame frame, LocalAccessor output, PIntRangeIterator iterator, @Bind BytecodeNode bytecode) {
            return ForIterate.doInteger(frame, output, iterator, bytecode);
        }

        private static boolean doInteger(VirtualFrame frame, LocalAccessor output, PIntegerIterator iterator, BytecodeNode bytecode) {
            if (!iterator.hasNext()) {
                iterator.setExhausted();
                return false;
            }
            output.setInt(bytecode, frame, iterator.next());
            return true;
        }

        @Specialization
        public static boolean doObjectIterator(VirtualFrame frame, LocalAccessor output, PObjectSequenceIterator iterator, @Bind BytecodeNode bytecode) {
            if (!iterator.hasNext()) {
                iterator.setExhausted();
                output.setObject(bytecode, frame, null);
                return false;
            }
            Object value = iterator.next();
            output.setObject(bytecode, frame, value);
            return value != null;
        }

        @Specialization
        public static boolean doLongIterator(VirtualFrame frame, LocalAccessor output, PLongSequenceIterator iterator, @Bind BytecodeNode bytecode) {
            if (!iterator.hasNext()) {
                iterator.setExhausted();
                return false;
            }
            output.setLong(bytecode, frame, iterator.next());
            return true;
        }

        @Specialization
        public static boolean doDoubleIterator(VirtualFrame frame, LocalAccessor output, PDoubleSequenceIterator iterator, @Bind BytecodeNode bytecode) {
            if (!iterator.hasNext()) {
                iterator.setExhausted();
                return false;
            }
            output.setDouble(bytecode, frame, iterator.next());
            return true;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        public static boolean doIterator(VirtualFrame frame, LocalAccessor output, Object object, @Bind Node inliningTarget, @Bind BytecodeNode bytecode, @Cached PyIterNextNode next, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            try {
                Object value = next.execute((Frame)frame, inliningTarget, object);
                output.setObject(bytecode, frame, value);
                return true;
            }
            catch (IteratorExhausted e) {
                output.setObject(bytecode, frame, null);
                return false;
            }
        }
    }

    public static final class InPlacePow {
        @Specialization
        public static Object doIt(VirtualFrame frame, Object left, Object right, @Cached PyNumberInPlacePowerNode ipowNode) {
            return ipowNode.execute(frame, left, right);
        }
    }

    public static final class Pow {
        @Specialization
        public static Object doIt(VirtualFrame frame, Object left, Object right, @Cached PyNumberPowerNode powNode) {
            return powNode.execute(frame, left, right);
        }
    }

    public static final class MakeFunction {
        @Specialization(guards={"isSingleContext(rootNode)", "!codeUnit.isGeneratorOrCoroutine()"})
        public static Object functionSingleContext(VirtualFrame frame, TruffleString name, TruffleString qualifiedName, BytecodeDSLCodeUnit codeUnit, Object[] defaults, Object[] kwDefaultsObject, Object closure, Object annotations, @Bind PBytecodeDSLRootNode rootNode, @Cached(value="createFunctionRootNode(rootNode, codeUnit)", adopt=false) PBytecodeDSLRootNode functionRootNode, @Cached(value="createCode(rootNode, codeUnit, functionRootNode)") PCode cachedCode, @Cached.Shared @CachedLibrary(limit="1") DynamicObjectLibrary dylib) {
            return MakeFunction.createFunction(frame, name, qualifiedName, codeUnit.getDocstring(), cachedCode, defaults, kwDefaultsObject, closure, annotations, rootNode, dylib);
        }

        @Specialization(replaces={"functionSingleContext"}, guards={"!codeUnit.isGeneratorOrCoroutine()"})
        public static Object functionMultiContext(VirtualFrame frame, TruffleString name, TruffleString qualifiedName, BytecodeDSLCodeUnit codeUnit, Object[] defaults, Object[] kwDefaultsObject, Object closure, Object annotations, @Bind PBytecodeDSLRootNode rootNode, @Cached(value="createFunctionRootNode(rootNode, codeUnit)", adopt=false) PBytecodeDSLRootNode functionRootNode, @Cached.Shared @CachedLibrary(limit="1") DynamicObjectLibrary dylib) {
            PCode code = MakeFunction.createCode(rootNode, codeUnit, functionRootNode);
            return MakeFunction.createFunction(frame, name, qualifiedName, codeUnit.getDocstring(), code, defaults, kwDefaultsObject, closure, annotations, rootNode, dylib);
        }

        @Specialization(guards={"isSingleContext(rootNode)", "codeUnit.isGeneratorOrCoroutine()"})
        public static Object generatorOrCoroutineSingleContext(VirtualFrame frame, TruffleString name, TruffleString qualifiedName, BytecodeDSLCodeUnit codeUnit, Object[] defaults, Object[] kwDefaultsObject, Object closure, Object annotations, @Bind PBytecodeDSLRootNode rootNode, @Cached(value="createFunctionRootNode(rootNode, codeUnit)", adopt=false) PBytecodeDSLRootNode functionRootNode, @Cached(value="createGeneratorRootNode(rootNode, functionRootNode, codeUnit)", adopt=false) PBytecodeDSLGeneratorFunctionRootNode generatorRootNode, @Cached(value="createCode(rootNode, codeUnit, generatorRootNode)") PCode cachedCode, @Cached.Shared @CachedLibrary(limit="1") DynamicObjectLibrary dylib) {
            return MakeFunction.createFunction(frame, name, qualifiedName, codeUnit.getDocstring(), cachedCode, defaults, kwDefaultsObject, closure, annotations, rootNode, dylib);
        }

        @Specialization(replaces={"generatorOrCoroutineSingleContext"}, guards={"codeUnit.isGeneratorOrCoroutine()"})
        public static Object generatorOrCoroutineMultiContext(VirtualFrame frame, TruffleString name, TruffleString qualifiedName, BytecodeDSLCodeUnit codeUnit, Object[] defaults, Object[] kwDefaultsObject, Object closure, Object annotations, @Bind PBytecodeDSLRootNode rootNode, @Cached(value="createFunctionRootNode(rootNode, codeUnit)", adopt=false) PBytecodeDSLRootNode functionRootNode, @Cached(value="createGeneratorRootNode(rootNode, functionRootNode, codeUnit)", adopt=false) PBytecodeDSLGeneratorFunctionRootNode generatorRootNode, @Cached.Shared @CachedLibrary(limit="1") DynamicObjectLibrary dylib) {
            PCode code = MakeFunction.createCode(rootNode, codeUnit, generatorRootNode);
            return MakeFunction.createFunction(frame, name, qualifiedName, codeUnit.getDocstring(), code, defaults, kwDefaultsObject, closure, annotations, rootNode, dylib);
        }

        @Idempotent
        protected static boolean isSingleContext(Node node) {
            return PythonLanguage.get(node).isSingleContext();
        }

        @NeverDefault
        protected static PBytecodeDSLRootNode createFunctionRootNode(PBytecodeDSLRootNode outerRootNode, BytecodeDSLCodeUnit codeUnit) {
            return codeUnit.createRootNode(PythonContext.get((Node)outerRootNode), outerRootNode.getSource());
        }

        @NeverDefault
        protected static PBytecodeDSLGeneratorFunctionRootNode createGeneratorRootNode(PBytecodeDSLRootNode outerRootNode, PBytecodeDSLRootNode functionRootNode, BytecodeDSLCodeUnit codeUnit) {
            return new PBytecodeDSLGeneratorFunctionRootNode(PythonLanguage.get((Node)outerRootNode), functionRootNode.getFrameDescriptor(), functionRootNode, codeUnit.name);
        }

        @NeverDefault
        protected static PCode createCode(PBytecodeDSLRootNode outerRootNode, BytecodeDSLCodeUnit codeUnit, PRootNode rootNode) {
            return PFactory.createCode(PythonLanguage.get((Node)outerRootNode), rootNode.getCallTarget(), rootNode.getSignature(), codeUnit);
        }

        protected static PFunction createFunction(VirtualFrame frame, TruffleString name, TruffleString qualifiedName, TruffleString doc, PCode code, Object[] defaults, Object[] kwDefaultsObject, Object closure, Object annotations, PBytecodeDSLRootNode node, DynamicObjectLibrary dylib) {
            PKeyword[] kwDefaults = new PKeyword[kwDefaultsObject.length];
            System.arraycopy(kwDefaultsObject, 0, kwDefaults, 0, kwDefaults.length);
            PFunction function = PFactory.createFunction(PythonLanguage.get((Node)node), name, qualifiedName, code, PArguments.getGlobals((Frame)frame), defaults, kwDefaults, (PCell[])closure);
            if (annotations != null) {
                dylib.put((DynamicObject)function, (Object)SpecialAttributeNames.T___ANNOTATIONS__, annotations);
            }
            if (doc != null) {
                dylib.put((DynamicObject)function, (Object)SpecialAttributeNames.T___DOC__, (Object)doc);
            }
            return function;
        }
    }

    public static final class MatchClass {
        @Specialization
        public static Object perform(VirtualFrame frame, LocalAccessor attributes, Object subject, Object type, int nargs, TruffleString[] kwArgs, @Bind BytecodeNode bytecodeNode, @Cached MatchClassNode node) {
            Object attrs = node.execute((Frame)frame, subject, type, nargs, kwArgs);
            attributes.setObject(bytecodeNode, frame, attrs);
            return attrs != null;
        }
    }

    public static final class MatchKeys {
        @Specialization
        public static boolean perform(VirtualFrame frame, LocalAccessor values, Object map, Object[] keys, @Bind BytecodeNode bytecodeNode, @Cached MatchKeysNode node) {
            values.setObject(bytecodeNode, frame, node.execute((Frame)frame, map, keys));
            return node.execute((Frame)frame, map, keys) != PNone.NONE;
        }
    }

    public static final class PrintExpr {
        @Specialization
        public static void perform(VirtualFrame frame, Object object, @Cached PrintExprNode printExprNode) {
            printExprNode.execute((Frame)frame, object);
        }
    }

    public static final class FormatAscii {
        @Specialization
        public static TruffleString perform(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached PyObjectAsciiNode asTruffleStringNode) {
            return asTruffleStringNode.execute((Frame)frame, inliningTarget, object);
        }
    }

    public static final class FormatRepr {
        @Specialization
        public static TruffleString perform(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached PyObjectReprAsTruffleStringNode asTruffleStringNode) {
            return asTruffleStringNode.execute((Frame)frame, inliningTarget, object);
        }
    }

    public static final class FormatStr {
        @Specialization
        public static TruffleString perform(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached PyObjectStrAsTruffleStringNode asTruffleStringNode) {
            return asTruffleStringNode.execute((Frame)frame, inliningTarget, object);
        }
    }

    public static final class GetIter {
        @Specialization
        public static Object perform(VirtualFrame frame, Object receiver, @Bind Node inliningTarget, @Cached PyObjectGetIter getIterNode) {
            return getIterNode.execute((Frame)frame, inliningTarget, receiver);
        }
    }

    public static final class LoadBytes {
        @Specialization
        public static Object perform(byte[] bytes, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createBytes(rootNode.getLanguage(), bytes);
        }
    }

    public static final class LoadBigInt {
        @Specialization
        public static Object perform(BigInteger bigInt, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createInt(rootNode.getLanguage(), bigInt);
        }
    }

    public static final class LoadComplex {
        @Specialization
        public static Object perform(double real, double imag, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createComplex(rootNode.getLanguage(), real, imag);
        }
    }

    public static final class LoadKeywordArguments {
        @Specialization
        public static Object perform(VirtualFrame frame, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createDict(rootNode.getLanguage(), PArguments.getKeywordArguments((Frame)frame));
        }
    }

    public static final class LoadVariableArguments {
        @Specialization
        public static Object perform(VirtualFrame frame, @Bind PBytecodeDSLRootNode rootNode) {
            return PFactory.createTuple(rootNode.getLanguage(), PArguments.getVariableArguments((Frame)frame));
        }
    }

    public static final class DeleteName {
        @Specialization(guards={"hasLocals(frame)"})
        public static void performLocals(VirtualFrame frame, TruffleString name, @Bind Node inliningTarget, @Cached PyObjectDelItem deleteNode) {
            deleteNode.execute((Frame)frame, inliningTarget, PArguments.getSpecialArgument((Frame)frame), name);
        }

        @Specialization(guards={"!hasLocals(frame)"})
        public static void performGlobals(VirtualFrame frame, TruffleString name, @Cached DeleteGlobalNode deleteNode) {
            deleteNode.executeWithGlobals(frame, PArguments.getGlobals((Frame)frame), name);
        }

        public static boolean hasLocals(VirtualFrame frame) {
            return PArguments.getSpecialArgument((Frame)frame) != null;
        }
    }

    public static final class ReadName {
        @Specialization
        public static Object perform(VirtualFrame frame, TruffleString name, @Cached ReadNameNode readNode) {
            return readNode.execute(frame, name);
        }
    }

    public static final class WriteName {
        @Specialization
        public static void perform(VirtualFrame frame, TruffleString name, Object value, @Cached WriteNameNode writeNode) {
            writeNode.execute(frame, name, value);
        }
    }

    public static final class Contains {
        @Specialization
        static Object contains(VirtualFrame frame, Object item, Object container, @Bind Node inliningTarget, @Cached PySequenceContainsNode containsNode) {
            return containsNode.execute((Frame)frame, inliningTarget, container, item);
        }
    }

    public static final class CollectToObjectArray {
        @Specialization
        public static Object[] perform(Object[] values) {
            return values;
        }
    }

    public static final class UnwrapException {
        @Specialization
        public static Object doPException(PException ex) {
            return ex.getEscapedException();
        }

        @Fallback
        public static Object doOther(Object ex) {
            assert (ex instanceof AbstractTruffleException);
            return ex;
        }
    }

    public static final class ArrayIndex {
        @Specialization
        public static Object doObject(int i, Object[] array) {
            return array[i];
        }
    }

    public static final class EpilogForException {
        @Specialization
        public static void doExit(VirtualFrame frame, AbstractTruffleException ate, @Bind PBytecodeDSLRootNode root, @Bind Node location) {
            if (ate instanceof PException) {
                PException pe = (PException)ate;
                pe.notifyAddedTracebackFrame(!root.isInternal());
            }
            if (root.needsTraceAndProfileInstrumentation()) {
                root.traceOrProfileReturn(frame, location, null);
                root.getThreadState().popInstrumentationData(root);
            }
            root.calleeContext.exit(frame, root, location);
        }
    }

    public static final class EpilogForReturn {
        @Specialization
        public static Object doExit(VirtualFrame frame, Object returnValue, @Bind PBytecodeDSLRootNode root, @Bind Node location) {
            if (root.needsTraceAndProfileInstrumentation()) {
                root.getThreadState().popInstrumentationData(root);
            }
            root.calleeContext.exit(frame, root, location);
            return returnValue;
        }
    }

    public static final class EnterCalleeContext {
        @Specialization
        public static void doEnter(VirtualFrame frame, @Bind PBytecodeDSLRootNode root) {
            root.calleeContext.enter(frame);
            if (root.needsTraceAndProfileInstrumentation()) {
                root.ensureTraceAndProfileEnabled();
                root.getThreadState().pushInstrumentationData(root);
            }
        }
    }
}

