/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionRule;
import schemacrawler.schemacrawler.Options;
import us.fatehi.utility.EnumUtility;
import us.fatehi.utility.ObjectToString;
import us.fatehi.utility.Utility;
import us.fatehi.utility.readconfig.ReadConfig;
import us.fatehi.utility.string.StringFormat;

public final class Config
implements Options,
ReadConfig {
    public static final Logger LOGGER = Logger.getLogger(Config.class.getName());
    private final Map<String, Object> configMap;

    @Deprecated(forRemoval=true)
    public Config() {
        this(Collections.emptyMap());
    }

    @Deprecated(forRemoval=true)
    public Config(Config config) {
        this(Collections.emptyMap());
        this.merge(config);
    }

    Config(Map<String, ? extends Object> map) {
        Objects.requireNonNull(map, "No map provided");
        this.configMap = new ConcurrentHashMap<String, Object>(map);
    }

    @Override
    public boolean containsKey(String key) {
        return this.configMap.containsKey(key);
    }

    @Override
    public boolean getBooleanValue(String propertyName) {
        return this.getBooleanValue(propertyName, false);
    }

    public boolean getBooleanValue(String propertyName, boolean defaultValue) {
        Object value = this.configMap.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool;
        }
        return Boolean.parseBoolean(this.getStringValue(propertyName, Boolean.toString(defaultValue)));
    }

    public <E extends Enum<E>> E getEnumValue(String propertyName, E defaultValue) {
        Object value = this.configMap.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        Objects.requireNonNull(defaultValue, "No default value provided");
        if (value.getClass() == defaultValue.getClass()) {
            return (E)((Enum)value);
        }
        String valueString = this.getStringValue(propertyName, defaultValue.name());
        return EnumUtility.enumValue(valueString, defaultValue);
    }

    public int getIntegerValue(String propertyName, int defaultValue) {
        Object value = this.configMap.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            return intValue;
        }
        try {
            return Integer.parseInt(this.getStringValue(propertyName, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, e, new StringFormat("Could not parse integer value for property <%s>", propertyName));
            return defaultValue;
        }
    }

    public Optional<InclusionRule> getOptionalInclusionRule(String includePatternProperty, String excludePatternProperty) {
        String includePattern = this.getStringValue(includePatternProperty, null);
        String excludePattern = this.getStringValue(excludePatternProperty, null);
        if (Utility.isBlank(includePattern) && Utility.isBlank(excludePattern)) {
            return Optional.empty();
        }
        return Optional.of(new RegularExpressionRule(includePattern, excludePattern));
    }

    @Override
    public String getStringValue(String propertyName, String defaultValue) {
        Object value = this.configMap.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public Map<String, Object> getSubMap(String propertyName) {
        if (Utility.isBlank(propertyName)) {
            return new HashMap<String, Object>(this.configMap);
        }
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> configEntry : this.configMap.entrySet()) {
            String fullKey = configEntry.getKey();
            if (fullKey == null || !fullKey.startsWith(propertyName)) continue;
            String key = fullKey.substring(propertyName.length() + 1);
            Object value = configEntry.getValue();
            subMap.put(key, value);
        }
        return subMap;
    }

    public void merge(Config config) {
        if (config == null) {
            return;
        }
        this.configMap.putAll(config.configMap);
    }

    public Object put(String key, Object value) {
        if (value == null) {
            return this.configMap.remove(key);
        }
        if (!Utility.isBlank(key)) {
            return this.configMap.put(key, value);
        }
        return null;
    }

    public int size() {
        return this.configMap.size();
    }

    public String toString() {
        return ObjectToString.toString(this.configMap);
    }
}

