/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.jakartaee.EESpecProfiles;
import org.apache.tomcat.jakartaee.Migration;
import org.apache.tomcat.jakartaee.MigrationCache;
import org.apache.tomcat.jakartaee.StringManager;

public class MigrationCLI {
    private static final StringManager sm = StringManager.getManager(MigrationCLI.class);
    private static final String EXCLUDE_ARG = "-exclude=";
    private static final String LOGLEVEL_ARG = "-logLevel=";
    private static final String PROFILE_ARG = "-profile=";
    private static final String ZIPINMEMORY_ARG = "-zipInMemory";
    private static final String MATCHEXCLUDESPATH_ARG = "-matchExcludesAgainstPathName";
    private static final String CACHE_ARG = "-cache";
    private static final String CACHE_LOCATION_ARG = "-cacheLocation=";
    private static final String CACHE_RETENTION_ARG = "-cacheRetention=";

    public static void main(String[] args) throws IOException {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%5$s%n");
        Migration migration = new Migration();
        File cacheDir = null;
        boolean enableCache = false;
        int cacheRetentionDays = 30;
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        Iterator iter = arguments.iterator();
        while (iter.hasNext()) {
            String argument = (String)iter.next();
            if (argument.startsWith(EXCLUDE_ARG)) {
                iter.remove();
                String exclude = argument.substring(EXCLUDE_ARG.length());
                migration.addExclude(exclude);
                continue;
            }
            if (argument.startsWith(LOGLEVEL_ARG)) {
                iter.remove();
                String logLevelName = argument.substring(LOGLEVEL_ARG.length());
                Level level = null;
                try {
                    level = Level.parse(logLevelName.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException iae) {
                    MigrationCLI.invalidArguments();
                }
                Logger.getGlobal().getParent().getHandlers()[0].setLevel(level);
                Logger.getGlobal().getParent().setLevel(level);
                continue;
            }
            if (argument.startsWith(PROFILE_ARG)) {
                iter.remove();
                String profileName = argument.substring(PROFILE_ARG.length());
                try {
                    EESpecProfiles profile = EESpecProfiles.valueOf(profileName.toUpperCase(Locale.ENGLISH));
                    migration.setEESpecProfile(profile);
                }
                catch (IllegalArgumentException e) {
                    MigrationCLI.invalidArguments();
                }
                continue;
            }
            if (argument.equals(ZIPINMEMORY_ARG)) {
                iter.remove();
                migration.setZipInMemory(true);
                continue;
            }
            if (argument.equals(MATCHEXCLUDESPATH_ARG)) {
                iter.remove();
                migration.setMatchExcludesAgainstPathName(true);
                continue;
            }
            if (argument.equals(CACHE_ARG)) {
                iter.remove();
                enableCache = true;
                if (cacheDir != null) continue;
                cacheDir = new File(System.getProperty("user.home"), ".migration-cache");
                continue;
            }
            if (argument.startsWith(CACHE_LOCATION_ARG)) {
                iter.remove();
                enableCache = true;
                String cachePath = argument.substring(CACHE_LOCATION_ARG.length());
                cacheDir = new File(cachePath);
                continue;
            }
            if (!argument.startsWith(CACHE_RETENTION_ARG)) continue;
            iter.remove();
            String retentionStr = argument.substring(CACHE_RETENTION_ARG.length());
            try {
                cacheRetentionDays = Integer.parseInt(retentionStr);
                if (cacheRetentionDays >= 1) continue;
                MigrationCLI.invalidArguments();
            }
            catch (NumberFormatException e) {
                MigrationCLI.invalidArguments();
            }
        }
        if (arguments.size() != 2) {
            MigrationCLI.invalidArguments();
        }
        String source = (String)arguments.get(0);
        String dest = (String)arguments.get(1);
        migration.setSource(new File(source));
        migration.setDestination(new File(dest));
        if (enableCache) {
            MigrationCache migrationCache = new MigrationCache(cacheDir, cacheRetentionDays);
            migration.setCache(migrationCache);
        }
        migration.execute();
    }

    private static void invalidArguments() {
        System.out.println(sm.getString("migration.usage"));
        System.exit(1);
    }
}

