/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.ArrayList;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.mbeans.BaseCatalinaMBean;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.HostConfig;

public class ContainerMBean
extends BaseCatalinaMBean<ContainerBase> {
    public void addChild(String string, String string2) throws MBeanException {
        LifecycleListener lifecycleListener;
        Container container = (Container)ContainerMBean.newInstance(string);
        container.setName(string2);
        if (container instanceof StandardHost) {
            lifecycleListener = new HostConfig();
            container.addLifecycleListener(lifecycleListener);
        } else if (container instanceof StandardContext) {
            lifecycleListener = new ContextConfig();
            container.addLifecycleListener(lifecycleListener);
        }
        boolean bl = true;
        ContainerBase containerBase = (ContainerBase)this.doGetManagedResource();
        try {
            bl = containerBase.getStartChildren();
            containerBase.setStartChildren(false);
            containerBase.addChild(container);
            container.init();
        }
        catch (LifecycleException lifecycleException) {
            throw new MBeanException(lifecycleException);
        }
        finally {
            if (containerBase != null) {
                containerBase.setStartChildren(bl);
            }
        }
    }

    public void removeChild(String string) throws MBeanException {
        if (string != null) {
            Container container = (Container)this.doGetManagedResource();
            Container container2 = container.findChild(string);
            container.removeChild(container2);
        }
    }

    public String addValve(String string) throws MBeanException {
        Valve valve = (Valve)ContainerMBean.newInstance(string);
        Container container = (Container)this.doGetManagedResource();
        container.getPipeline().addValve(valve);
        if (valve instanceof JmxEnabled) {
            return ((JmxEnabled)((Object)valve)).getObjectName().toString();
        }
        return null;
    }

    public void removeValve(String string) throws MBeanException {
        ObjectName objectName;
        Container container = (Container)this.doGetManagedResource();
        try {
            objectName = new ObjectName(string);
        }
        catch (NullPointerException | MalformedObjectNameException exception) {
            throw new MBeanException(exception);
        }
        if (container != null) {
            Valve[] valveArray;
            for (Valve valve : valveArray = container.getPipeline().getValves()) {
                ObjectName objectName2;
                if (!(valve instanceof JmxEnabled) || !(objectName2 = ((JmxEnabled)((Object)valve)).getObjectName()).equals(objectName)) continue;
                container.getPipeline().removeValve(valve);
            }
        }
    }

    public void addLifecycleListener(String string) throws MBeanException {
        LifecycleListener lifecycleListener = (LifecycleListener)ContainerMBean.newInstance(string);
        Container container = (Container)this.doGetManagedResource();
        container.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListeners(String string) throws MBeanException {
        LifecycleListener[] lifecycleListenerArray;
        Container container = (Container)this.doGetManagedResource();
        for (LifecycleListener lifecycleListener : lifecycleListenerArray = container.findLifecycleListeners()) {
            if (!lifecycleListener.getClass().getName().equals(string)) continue;
            container.removeLifecycleListener(lifecycleListener);
        }
    }

    public String[] findLifecycleListenerNames() throws MBeanException {
        LifecycleListener[] lifecycleListenerArray;
        Container container = (Container)this.doGetManagedResource();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (LifecycleListener lifecycleListener : lifecycleListenerArray = container.findLifecycleListeners()) {
            arrayList.add(lifecycleListener.getClass().getName());
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] findContainerListenerNames() throws MBeanException {
        ContainerListener[] containerListenerArray;
        Container container = (Container)this.doGetManagedResource();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ContainerListener containerListener : containerListenerArray = container.findContainerListeners()) {
            arrayList.add(containerListener.getClass().getName());
        }
        return arrayList.toArray(new String[0]);
    }
}

