push_textdomain("tribes")

local dirname = path.dirname (__file__)

wl.Descriptions():new_productionsite_type {
   name = "frisians_berry_farm",
   -- TRANSLATORS: This is a building name used in lists of buildings
   descname = pgettext ("frisians_building", "Berry Farm"),
   animation_directory = dirname,
   icon = dirname .. "menu.png",
   size = "small",

   buildcost = {
      brick = 1,
      log = 2,
      reed = 1
   },
   return_on_dismantle = {
      brick = 1,
      log = 1
   },

   spritesheets = {
      idle = {
         hotspot = {40, 73},
         frames = 10,
         columns = 5,
         rows = 2,
         fps = 10
      },
      build = {
         hotspot = {40, 55},
         frames = 3,
         columns = 3,
         rows = 1,
      }
   },
   animations = {
      unoccupied = {
         hotspot = {40, 55}
      }
   },

   aihints = {
      space_consumer = true,
      prohibited_till = 460
   },

   working_positions = {
      frisians_berry_farmer = 1
   },

   programs = {
      main = {
         -- TRANSLATORS: Completed/Skipped/Did not start planting bushes because ...
         descname = _("planting bushes"),
         actions = {
            -- time of worker: 12.2-30.2 sec
            -- min. time total: 12.2 + 21 = 33.2 sec
            -- max. time total: 30.2 + 21 = 51.2 sec
            "callworker=plant",
            "sleep=duration:21s"
         }
      },
   },
}

pop_textdomain()
