/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import java.util.Comparator;
import org.jkiss.dbeaver.model.sql.completion.CompletionProposalBase;

public class SQLCompletionProposalComparator
implements Comparator<CompletionProposalBase> {
    private final boolean sortAlphabetically;
    private final boolean isSearchInsideNames;

    public SQLCompletionProposalComparator(boolean sortAlphabetically, boolean isSearchInsideNames) {
        this.sortAlphabetically = sortAlphabetically;
        this.isSearchInsideNames = isSearchInsideNames;
    }

    @Override
    public int compare(CompletionProposalBase p1, CompletionProposalBase p2) {
        if (this.isSearchInsideNames) {
            return this.compareWhenFuzzySearch(p1, p2);
        }
        return this.compareWhenPrefixSearch(p1, p2);
    }

    private int compareWhenFuzzySearch(CompletionProposalBase p1, CompletionProposalBase p2) {
        int rc;
        int score1 = p1.getProposalScore();
        int score2 = p2.getProposalScore();
        if (score1 == Integer.MAX_VALUE && score2 == Integer.MAX_VALUE) {
            return this.compareWhenPrefixSearch(p1, p2);
        }
        if ((score1 > 0 || score2 > 0) && (rc = -Integer.compare(score1, score2)) != 0) {
            return rc;
        }
        if (this.sortAlphabetically) {
            rc = p1.getDisplayString().compareToIgnoreCase(p2.getDisplayString());
            if (rc != 0) {
                return rc;
            }
        } else {
            return 0;
        }
        return Integer.compare(p1.getProposalTypeSorterScore(), p2.getProposalTypeSorterScore());
    }

    private int compareWhenPrefixSearch(CompletionProposalBase p1, CompletionProposalBase p2) {
        int rc;
        int krc = Integer.compare(p1.getProposalTypeSorterScore(), p2.getProposalTypeSorterScore());
        if (krc != 0) {
            return krc;
        }
        if (this.sortAlphabetically && (rc = p1.getDisplayString().compareToIgnoreCase(p2.getDisplayString())) != 0) {
            return rc;
        }
        return 0;
    }
}

