/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi.collections;

import com.intellij.debugger.streams.core.psi.ChainTransformer;
import com.intellij.debugger.streams.core.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.core.wrapper.QualifierExpression;
import com.intellij.debugger.streams.core.wrapper.StreamChain;
import com.intellij.debugger.streams.core.wrapper.impl.StreamChainImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.collections.KotlinCollectionsTypeExtractor;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.impl.KotlinChainTransformerImpl;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/collections/CollectionChainTransformer;", "Lcom/intellij/debugger/streams/core/psi/ChainTransformer;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "<init>", "()V", "transformer", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainTransformerImpl;", "transform", "Lcom/intellij/debugger/streams/core/wrapper/StreamChain;", "chainCalls", "", "context", "Lcom/intellij/psi/PsiElement;", "isArray", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "WrappedQualifier", "kotlin.jvm-debugger.sequence.k1"})
public final class CollectionChainTransformer
implements ChainTransformer<KtCallExpression> {
    @NotNull
    private final KotlinChainTransformerImpl transformer = new KotlinChainTransformerImpl(new KotlinCollectionsTypeExtractor());

    @NotNull
    public StreamChain transform(@NotNull List<? extends KtCallExpression> chainCalls, @NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter(chainCalls, (String)"chainCalls");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        StreamChain chain = this.transformer.transform(chainCalls, context2);
        KotlinType kotlinType = UtilsKt.resolveType$default((KtExpression)CollectionsKt.first(chainCalls), null, 1, null);
        boolean bl = kotlinType != null ? this.isArray(kotlinType) : false;
        if (bl) {
            QualifierExpression qualifierExpression = chain.getQualifierExpression();
            Intrinsics.checkNotNullExpressionValue((Object)qualifierExpression, (String)"getQualifierExpression(...)");
            WrappedQualifier qualifier2 = new WrappedQualifier(qualifierExpression);
            return (StreamChain)new StreamChainImpl((QualifierExpression)qualifier2, chain.getIntermediateCalls(), chain.getTerminationCall(), chain.getContext());
        }
        return chain;
    }

    private final boolean isArray(KotlinType $this$isArray) {
        return KotlinBuiltIns.isArray((KotlinType)$this$isArray) || KotlinBuiltIns.isPrimitiveArray((KotlinType)$this$isArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0097\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/collections/CollectionChainTransformer$WrappedQualifier;", "Lcom/intellij/debugger/streams/core/wrapper/QualifierExpression;", "qualifierExpression", "<init>", "(Lcom/intellij/debugger/streams/core/wrapper/QualifierExpression;)V", "text", "", "getText", "()Ljava/lang/String;", "getTypeAfter", "Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "kotlin.jvm-debugger.sequence.k1"})
    private static final class WrappedQualifier
    implements QualifierExpression {
        @NotNull
        private final QualifierExpression qualifierExpression;

        public WrappedQualifier(@NotNull QualifierExpression qualifierExpression) {
            Intrinsics.checkNotNullParameter((Object)qualifierExpression, (String)"qualifierExpression");
            this.qualifierExpression = qualifierExpression;
        }

        @NotNull
        public String getText() {
            return this.qualifierExpression.getText() + ".asIterable()";
        }

        @NotNull
        public TextRange getTextRange() {
            return this.qualifierExpression.getTextRange();
        }

        @NotNull
        public GenericType getTypeAfter() {
            GenericType genericType = this.qualifierExpression.getTypeAfter();
            Intrinsics.checkNotNullExpressionValue((Object)genericType, (String)"getTypeAfter(...)");
            return genericType;
        }
    }
}

