/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.structuralsearch;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0015\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005*\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0001\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0006*\u00020\u000f\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0006*\u00020\u0011\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\u0011\u001a\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\n\"\u0015\u0010\t\u001a\u00020\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"getCommentText", "", "comment", "Lcom/intellij/psi/PsiComment;", "renderNames", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)[Ljava/lang/String;", "removeTypeParameters", "withinHierarchyTextFilterSet", "", "Lcom/intellij/structuralsearch/impl/matcher/handlers/MatchingHandler;", "getWithinHierarchyTextFilterSet", "(Lcom/intellij/structuralsearch/impl/matcher/handlers/MatchingHandler;)Z", "resolveDeclType", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "resolveReceiverType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "resolveExprType", "toSimpleType", "Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "nullable", "kotlin.code-insight.structural-search.k1"})
@SourceDebugExtension(value={"SMAP\nKotlinStructuralSearchUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStructuralSearchUtil.kt\norg/jetbrains/kotlin/idea/structuralsearch/KotlinStructuralSearchUtilKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,69:1\n158#2,6:70\n170#2,6:76\n19#3:82\n*S KotlinDebug\n*F\n+ 1 KotlinStructuralSearchUtil.kt\norg/jetbrains/kotlin/idea/structuralsearch/KotlinStructuralSearchUtilKt\n*L\n43#1:70,6\n44#1:76,6\n63#1:82\n*E\n"})
public final class KotlinStructuralSearchUtilKt {
    @NotNull
    public static final String getCommentText(@NotNull PsiComment comment) {
        String string;
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        IElementType iElementType = comment.getTokenType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EOL_COMMENT)) {
            String string2 = comment.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            string = ((Object)StringsKt.trim((CharSequence)StringsKt.drop((String)string2, (int)2))).toString();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.BLOCK_COMMENT)) {
            String string3 = comment.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            string = ((Object)StringsKt.trim((CharSequence)StringsKt.dropLast((String)StringsKt.drop((String)string3, (int)2), (int)2))).toString();
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    public static final String[] renderNames(@NotNull KotlinType $this$renderNames) {
        Intrinsics.checkNotNullParameter((Object)$this$renderNames, (String)"<this>");
        String[] stringArray = new String[]{DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType($this$renderNames), DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType($this$renderNames), String.valueOf($this$renderNames)};
        return stringArray;
    }

    @NotNull
    public static final String removeTypeParameters(@NotNull String $this$removeTypeParameters) {
        int n;
        int n2;
        String string;
        block5: {
            int n3;
            int n4;
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$removeTypeParameters, (String)"<this>");
                if (!StringsKt.contains$default((CharSequence)$this$removeTypeParameters, (char)'<', (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)$this$removeTypeParameters, (char)'>', (boolean)false, (int)2, null)) {
                    return $this$removeTypeParameters;
                }
                string = $this$removeTypeParameters;
                CharSequence $this$indexOfFirst$iv = $this$removeTypeParameters;
                boolean $i$f$indexOfFirst = false;
                n4 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < n4; ++index$iv) {
                    char c = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(c == '<')) continue;
                    n3 = index$iv;
                    break block4;
                }
                n3 = -1;
            }
            n2 = n3;
            CharSequence $this$indexOfLast$iv = $this$removeTypeParameters;
            boolean $i$f$indexOfLast = false;
            n4 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n4) {
                do {
                    int index$iv = n4--;
                    char c = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(c == '>')) continue;
                    n = index$iv;
                    break block5;
                } while (0 <= n4);
            }
            n = -1;
        }
        int n5 = n + 1;
        return ((Object)StringsKt.removeRange((CharSequence)string, (int)n2, (int)n5)).toString();
    }

    public static final boolean getWithinHierarchyTextFilterSet(@NotNull MatchingHandler $this$withinHierarchyTextFilterSet) {
        Intrinsics.checkNotNullParameter((Object)$this$withinHierarchyTextFilterSet, (String)"<this>");
        return $this$withinHierarchyTextFilterSet instanceof SubstitutionHandler && (((SubstitutionHandler)$this$withinHierarchyTextFilterSet).isSubtype() || ((SubstitutionHandler)$this$withinHierarchyTextFilterSet).isStrictSubtype());
    }

    @Nullable
    public static final KotlinType resolveDeclType(@NotNull KtDeclaration $this$resolveDeclType) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveDeclType, (String)"<this>");
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default($this$resolveDeclType, null, 1, null);
        CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
        return callableDescriptor != null ? callableDescriptor.getReturnType() : null;
    }

    @Nullable
    public static final KotlinType resolveReceiverType(@NotNull KtExpression $this$resolveReceiverType) {
        DeclarationDescriptor descriptor2;
        Intrinsics.checkNotNullParameter((Object)$this$resolveReceiverType, (String)"<this>");
        ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)$this$resolveReceiverType, null, 1, null);
        DeclarationDescriptor declarationDescriptor = resolvedCall != null && (resolvedCall = resolvedCall.getResultingDescriptor()) != null ? resolvedCall.getContainingDeclaration() : (descriptor2 = null);
        if (descriptor2 instanceof ClassDescriptor) {
            KotlinType kotlinType = DescriptorUtilsKt.getClassValueType((ClassDescriptor)((ClassDescriptor)descriptor2));
            if (kotlinType == null) {
                SimpleType simpleType = ((ClassDescriptor)descriptor2).getDefaultType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
                kotlinType = (KotlinType)simpleType;
            }
            return kotlinType;
        }
        return null;
    }

    @Nullable
    public static final KotlinType resolveExprType(@NotNull KtExpression $this$resolveExprType) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveExprType, (String)"<this>");
        DeclarationDescriptor descriptor2 = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)$this$resolveExprType));
        if (descriptor2 instanceof ClassDescriptor) {
            KotlinType kotlinType = DescriptorUtilsKt.getClassValueType((ClassDescriptor)((ClassDescriptor)descriptor2));
            if (kotlinType == null) {
                SimpleType simpleType = ((ClassDescriptor)descriptor2).getDefaultType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
                kotlinType = (KotlinType)simpleType;
            }
            return kotlinType;
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            return ((PropertyDescriptor)descriptor2).getReturnType();
        }
        if ($this$resolveExprType instanceof KtDotQualifiedExpression && ((KtDotQualifiedExpression)$this$resolveExprType).getParent() instanceof KtDotQualifiedExpression) {
            PsiElement $this$asSafely$iv = ((KtDotQualifiedExpression)$this$resolveExprType).getParent();
            boolean $i$f$asSafely = false;
            PsiElement psiElement = $this$asSafely$iv;
            if (!(psiElement instanceof KtExpression)) {
                psiElement = null;
            }
            KtExpression ktExpression = (KtExpression)psiElement;
            return ktExpression != null ? KotlinStructuralSearchUtilKt.resolveReceiverType(ktExpression) : null;
        }
        return UtilsKt.resolveType$default($this$resolveExprType, null, 1, null);
    }

    @NotNull
    public static final SimpleType toSimpleType(@NotNull ClassDescriptor $this$toSimpleType, boolean nullable2) {
        Intrinsics.checkNotNullParameter((Object)$this$toSimpleType, (String)"<this>");
        TypeAttributes typeAttributes = TypeAttributes.Companion.getEmpty();
        TypeConstructor typeConstructor = $this$toSimpleType.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor, (String)"getTypeConstructor(...)");
        return KotlinTypeFactory.simpleType$default((TypeAttributes)typeAttributes, (TypeConstructor)typeConstructor, (List)CollectionsKt.emptyList(), (boolean)nullable2, null, (int)16, null);
    }

    public static /* synthetic */ SimpleType toSimpleType$default(ClassDescriptor classDescriptor, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return KotlinStructuralSearchUtilKt.toSimpleType(classDescriptor, bl);
    }
}

