/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.idea.svn.DepthCombo;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.update.AbstractSvnUpdatePanel;
import org.jetbrains.idea.svn.update.SvnIntegrateRootOptionsPanel;
import org.jetbrains.idea.svn.update.SvnPanel;

public class SvnIntegratePanel
extends AbstractSvnUpdatePanel {
    private JCheckBox myDryRunCheckbox;
    private JPanel myRootOptionsPanel;
    private JPanel myPanel;
    private JCheckBox myUseAncestry;
    private DepthCombo myDepthCombo;
    private JLabel myDepthLabel;
    private JPanel myAdditionalPanel;

    public SvnIntegratePanel(SvnVcs vcs, Collection<FilePath> roots) {
        super(vcs);
        this.$$$setupUI$$$();
        this.init(roots);
        boolean descend = false;
        for (FilePath root : roots) {
            if (!root.isDirectory()) continue;
            descend = true;
            break;
        }
        this.myDepthCombo.setVisible(descend);
        this.myDepthLabel.setVisible(descend);
        this.myDepthLabel.setLabelFor(this.myDepthCombo);
    }

    @Override
    protected SvnPanel createRootPanel(FilePath root, SvnVcs p1, Collection<FilePath> roots) {
        return new SvnIntegrateRootOptionsPanel(this.myVCS, root);
    }

    @Override
    protected JPanel getRootsPanel() {
        return this.myRootOptionsPanel;
    }

    @Override
    protected JPanel getAdditionalPanel() {
        return this.myAdditionalPanel;
    }

    @Override
    public void reset(SvnConfiguration configuration) {
        super.reset(configuration);
        this.myDryRunCheckbox.setSelected(configuration.isMergeDryRun());
        this.myUseAncestry.setSelected(configuration.isMergeDiffUseAncestry());
    }

    @Override
    public void apply(SvnConfiguration configuration) throws ConfigurationException {
        super.apply(configuration);
        configuration.setMergeDryRun(this.myDryRunCheckbox.isSelected());
        configuration.setMergeDiffUseAncestry(this.myUseAncestry.isSelected());
    }

    @Override
    protected JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected DepthCombo getDepthBox() {
        return this.myDepthCombo;
    }

    private void createUIComponents() {
        this.myDepthCombo = new DepthCombo(true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRootOptionsPanel = jPanel2 = new JPanel();
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myAdditionalPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myUseAncestry = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/SvnBundle", SvnIntegratePanel.class).getString("action.Subversion.integrate.difference.option.use.ancestry.text"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDryRunCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/SvnBundle", SvnIntegratePanel.class).getString("checkbox.update.switch.configurable.try.merge.without.changes"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myDepthLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/SvnBundle", SvnIntegratePanel.class).getString("label.depth.text"));
        jLabel.setToolTipText(DynamicBundle.getBundle((String)"messages/SvnBundle", SvnIntegratePanel.class).getString("label.depth.description"));
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        DepthCombo depthCombo = this.myDepthCombo;
        jPanel.add((Component)depthCombo, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

