/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.opensearch.common.CheckedFunction;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.aggregations.bucket.range.ParsedRange;

public class ParsedDateRange
extends ParsedRange {
    private static final ObjectParser<ParsedDateRange, Void> PARSER = new ObjectParser(ParsedDateRange.class.getSimpleName(), true, ParsedDateRange::new);

    @Override
    public String getType() {
        return "date_range";
    }

    public static ParsedDateRange fromXContent(XContentParser parser, String name) throws IOException {
        ParsedDateRange aggregation = (ParsedDateRange)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedDateRange.declareParsedRangeFields(PARSER, (CheckedFunction<XContentParser, ParsedRange.ParsedBucket, IOException>)((CheckedFunction)parser -> ParsedBucket.fromXContent(parser, false)), (CheckedFunction<XContentParser, ParsedRange.ParsedBucket, IOException>)((CheckedFunction)parser -> ParsedBucket.fromXContent(parser, true)));
    }

    public static class ParsedBucket
    extends ParsedRange.ParsedBucket {
        @Override
        public Object getFrom() {
            return ParsedBucket.doubleAsDateTime(this.from);
        }

        @Override
        public Object getTo() {
            return ParsedBucket.doubleAsDateTime(this.to);
        }

        private static ZonedDateTime doubleAsDateTime(Double d) {
            if (d == null || Double.isInfinite(d)) {
                return null;
            }
            return Instant.ofEpochMilli(d.longValue()).atZone(ZoneOffset.UTC);
        }

        static ParsedBucket fromXContent(XContentParser parser, boolean keyed) throws IOException {
            return ParsedBucket.parseRangeBucketXContent(parser, ParsedBucket::new, keyed);
        }
    }
}

