﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoTRequest.h>
#include <aws/iot/IoT_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace IoT {
namespace Model {

/**
 */
class ListThingGroupsRequest : public IoTRequest {
 public:
  AWS_IOT_API ListThingGroupsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListThingGroups"; }

  AWS_IOT_API Aws::String SerializePayload() const override;

  AWS_IOT_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>To retrieve the next set of results, the <code>nextToken</code> value from a
   * previous response; otherwise <b>null</b> to receive the first set of
   * results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListThingGroupsRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of results to return at one time.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListThingGroupsRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A filter that limits the results to those with the specified parent
   * group.</p>
   */
  inline const Aws::String& GetParentGroup() const { return m_parentGroup; }
  inline bool ParentGroupHasBeenSet() const { return m_parentGroupHasBeenSet; }
  template <typename ParentGroupT = Aws::String>
  void SetParentGroup(ParentGroupT&& value) {
    m_parentGroupHasBeenSet = true;
    m_parentGroup = std::forward<ParentGroupT>(value);
  }
  template <typename ParentGroupT = Aws::String>
  ListThingGroupsRequest& WithParentGroup(ParentGroupT&& value) {
    SetParentGroup(std::forward<ParentGroupT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A filter that limits the results to those with the specified name prefix.</p>
   */
  inline const Aws::String& GetNamePrefixFilter() const { return m_namePrefixFilter; }
  inline bool NamePrefixFilterHasBeenSet() const { return m_namePrefixFilterHasBeenSet; }
  template <typename NamePrefixFilterT = Aws::String>
  void SetNamePrefixFilter(NamePrefixFilterT&& value) {
    m_namePrefixFilterHasBeenSet = true;
    m_namePrefixFilter = std::forward<NamePrefixFilterT>(value);
  }
  template <typename NamePrefixFilterT = Aws::String>
  ListThingGroupsRequest& WithNamePrefixFilter(NamePrefixFilterT&& value) {
    SetNamePrefixFilter(std::forward<NamePrefixFilterT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If true, return child groups as well.</p>
   */
  inline bool GetRecursive() const { return m_recursive; }
  inline bool RecursiveHasBeenSet() const { return m_recursiveHasBeenSet; }
  inline void SetRecursive(bool value) {
    m_recursiveHasBeenSet = true;
    m_recursive = value;
  }
  inline ListThingGroupsRequest& WithRecursive(bool value) {
    SetRecursive(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  int m_maxResults{0};
  bool m_maxResultsHasBeenSet = false;

  Aws::String m_parentGroup;
  bool m_parentGroupHasBeenSet = false;

  Aws::String m_namePrefixFilter;
  bool m_namePrefixFilterHasBeenSet = false;

  bool m_recursive{false};
  bool m_recursiveHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
