﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codecommit/CodeCommit_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeCommit {
namespace Model {
class MergeBranchesBySquashResult {
 public:
  AWS_CODECOMMIT_API MergeBranchesBySquashResult() = default;
  AWS_CODECOMMIT_API MergeBranchesBySquashResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODECOMMIT_API MergeBranchesBySquashResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The commit ID of the merge in the destination or target branch.</p>
   */
  inline const Aws::String& GetCommitId() const { return m_commitId; }
  template <typename CommitIdT = Aws::String>
  void SetCommitId(CommitIdT&& value) {
    m_commitIdHasBeenSet = true;
    m_commitId = std::forward<CommitIdT>(value);
  }
  template <typename CommitIdT = Aws::String>
  MergeBranchesBySquashResult& WithCommitId(CommitIdT&& value) {
    SetCommitId(std::forward<CommitIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tree ID of the merge in the destination or target branch.</p>
   */
  inline const Aws::String& GetTreeId() const { return m_treeId; }
  template <typename TreeIdT = Aws::String>
  void SetTreeId(TreeIdT&& value) {
    m_treeIdHasBeenSet = true;
    m_treeId = std::forward<TreeIdT>(value);
  }
  template <typename TreeIdT = Aws::String>
  MergeBranchesBySquashResult& WithTreeId(TreeIdT&& value) {
    SetTreeId(std::forward<TreeIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  MergeBranchesBySquashResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_commitId;

  Aws::String m_treeId;

  Aws::String m_requestId;
  bool m_commitIdHasBeenSet = false;
  bool m_treeIdHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeCommit
}  // namespace Aws
