/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.util;

import java.lang.ref.SoftReference;
import java.util.Optional;

public interface Optionally<T> {
    public static final Optionally<?> EMPTY = new Empty();

    public static <T> Optionally<T> empty() {
        return EMPTY;
    }

    public void clear();

    public Optional<T> getOptional();

    public static class Empty<T>
    implements Optionally<T> {
        @Override
        public void clear() {
        }

        @Override
        public Optional<T> getOptional() {
            return Optional.empty();
        }
    }

    public static class Hard<T>
    implements Optionally<T> {
        protected Optional<T> optional;

        public Hard(T element) {
            this.optional = Optional.ofNullable(element);
        }

        @Override
        public void clear() {
            this.optional = Optional.empty();
        }

        @Override
        public Optional<T> getOptional() {
            return this.optional;
        }
    }

    public static class Soft<T>
    extends SoftReference<T>
    implements Optionally<T> {
        public Soft(T t) {
            super(t);
        }

        @Override
        public Optional<T> getOptional() {
            return Optional.ofNullable(this.get());
        }
    }
}

