/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragment;

public final class AnnotationsUtils {
    private static final FqName JS_NAME = JsStandardClassIds.Annotations.JsName.asSingleFqName();
    private static final FqName JS_EXPORT = JsStandardClassIds.Annotations.JsExport.asSingleFqName();
    private static final FqName JS_EXPORT_IGNORE = JsStandardClassIds.Annotations.JsExportIgnore.asSingleFqName();
    private static final FqName JS_MODULE_ANNOTATION = JsStandardClassIds.Annotations.JsModule.asSingleFqName();
    private static final FqName JS_NON_MODULE_ANNOTATION = JsStandardClassIds.Annotations.JsNonModule.asSingleFqName();
    private static final FqName JS_EXTERNAL_INHERITORS_ONLY = JsStandardClassIds.Annotations.JsExternalInheritorsOnly.asSingleFqName();
    private static final FqName JS_EXTERNAL_ARGUMENT = JsStandardClassIds.Annotations.JsExternalArgument.asSingleFqName();

    private AnnotationsUtils() {
    }

    public static boolean hasAnnotation(@NotNull DeclarationDescriptor descriptor, @NotNull PredefinedAnnotation annotation) {
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(0);
        }
        if (annotation == null) {
            AnnotationsUtils.$$$reportNull$$$0(1);
        }
        return AnnotationsUtils.getAnnotationByName(descriptor, annotation) != null;
    }

    @Nullable
    private static String getAnnotationStringParameter(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation) {
        if (declarationDescriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(2);
        }
        if (annotation == null) {
            AnnotationsUtils.$$$reportNull$$$0(3);
        }
        AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getAnnotationByName(declarationDescriptor, annotation);
        assert (annotationDescriptor != null);
        if (annotationDescriptor.getAllValueArguments().isEmpty()) {
            return null;
        }
        ConstantValue<?> constant = annotationDescriptor.getAllValueArguments().values().iterator().next();
        if (constant == null) {
            return null;
        }
        Object value = constant.getValue();
        assert (value instanceof String) : "Native function annotation should have one String parameter";
        return (String)value;
    }

    @Nullable
    public static String getNameForAnnotatedObject(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation) {
        if (declarationDescriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(4);
        }
        if (annotation == null) {
            AnnotationsUtils.$$$reportNull$$$0(5);
        }
        if (!AnnotationsUtils.hasAnnotation(declarationDescriptor, annotation)) {
            return null;
        }
        return AnnotationsUtils.getAnnotationStringParameter(declarationDescriptor, annotation);
    }

    @Nullable
    public static String getNameForAnnotatedObject(@NotNull DeclarationDescriptor descriptor, @NotNull BindingContext bindingContext) {
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(6);
        }
        if (bindingContext == null) {
            AnnotationsUtils.$$$reportNull$$$0(7);
        }
        String defaultJsName = AnnotationsUtils.getJsName(descriptor);
        for (PredefinedAnnotation annotation : PredefinedAnnotation.Companion.getWITH_CUSTOM_NAME()) {
            if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, annotation)) continue;
            String name = AnnotationsUtils.getNameForAnnotatedObject(descriptor, annotation);
            if (name == null) {
                name = defaultJsName;
            }
            return name != null ? name : descriptor.getName().asString();
        }
        if (defaultJsName == null && (AnnotationsUtils.isEffectivelyExternalMember(descriptor) || AnnotationsUtils.isExportedObject(descriptor, bindingContext))) {
            return descriptor.getName().asString();
        }
        return defaultJsName;
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor, @NotNull PredefinedAnnotation annotation) {
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(8);
        }
        if (annotation == null) {
            AnnotationsUtils.$$$reportNull$$$0(9);
        }
        return descriptor.getAnnotations().findAnnotation(annotation.getFqName());
    }

    public static boolean isExportedObject(@NotNull DeclarationDescriptor descriptor, @NotNull BindingContext bindingContext) {
        PropertyAccessorDescriptor propertyAccessor;
        MemberDescriptor memberDescriptor;
        DescriptorVisibility visibility;
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(10);
        }
        if (bindingContext == null) {
            AnnotationsUtils.$$$reportNull$$$0(11);
        }
        if (descriptor instanceof MemberDescriptor && (visibility = (memberDescriptor = (MemberDescriptor)descriptor).getVisibility()) != DescriptorVisibilities.PUBLIC && visibility != DescriptorVisibilities.PROTECTED) {
            return false;
        }
        if (AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, JS_EXPORT_IGNORE)) {
            return false;
        }
        if (descriptor instanceof PropertyAccessorDescriptor && (propertyAccessor = (PropertyAccessorDescriptor)descriptor).getCorrespondingProperty().getAnnotations().hasAnnotation(JS_EXPORT_IGNORE)) {
            return false;
        }
        if (AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, JS_EXPORT)) {
            return true;
        }
        return CollectionsKt.any(AnnotationsUtils.getContainingFileAnnotations(bindingContext, descriptor), annotation -> JS_EXPORT.equals((Object)annotation.getFqName()));
    }

    public static boolean isNativeObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(12);
        }
        if (AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, PredefinedAnnotation.NATIVE) || AnnotationsUtils.isEffectivelyExternalMember(descriptor)) {
            return true;
        }
        if (descriptor instanceof PropertyAccessorDescriptor) {
            PropertyAccessorDescriptor accessor = (PropertyAccessorDescriptor)descriptor;
            return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass((DeclarationDescriptor)accessor.getCorrespondingProperty(), PredefinedAnnotation.NATIVE);
        }
        return false;
    }

    public static boolean isNativeInterface(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(13);
        }
        return AnnotationsUtils.isNativeObject(descriptor) && DescriptorUtils.isInterface(descriptor);
    }

    private static boolean isEffectivelyExternalMember(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(14);
        }
        return descriptor instanceof MemberDescriptor && DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor);
    }

    public static boolean isLibraryObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(15);
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, PredefinedAnnotation.LIBRARY);
    }

    @Nullable
    public static String getJsName(@NotNull DeclarationDescriptor descriptor) {
        AnnotationDescriptor annotation;
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(16);
        }
        if ((annotation = AnnotationsUtils.getJsNameAnnotation(descriptor)) == null || annotation.getAllValueArguments().isEmpty()) {
            return null;
        }
        ConstantValue<?> value = annotation.getAllValueArguments().values().iterator().next();
        if (value == null) {
            return null;
        }
        Object result = value.getValue();
        if (!(result instanceof String)) {
            return null;
        }
        return (String)result;
    }

    @Nullable
    public static AnnotationDescriptor getJsNameAnnotation(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(17);
        }
        return descriptor.getAnnotations().findAnnotation(JS_NAME);
    }

    @Nullable
    public static AnnotationDescriptor getJsExportAnnotation(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(18);
        }
        return descriptor.getAnnotations().findAnnotation(JS_EXPORT);
    }

    public static boolean isPredefinedObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(19);
        }
        if (descriptor instanceof MemberDescriptor && ((MemberDescriptor)descriptor).isExpect()) {
            return true;
        }
        if (AnnotationsUtils.isEffectivelyExternalMember(descriptor)) {
            return true;
        }
        for (PredefinedAnnotation annotation : PredefinedAnnotation.values()) {
            if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, annotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor, @NotNull PredefinedAnnotation annotation) {
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(20);
        }
        if (annotation == null) {
            AnnotationsUtils.$$$reportNull$$$0(21);
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, annotation.getFqName());
    }

    private static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor, @NotNull FqName fqName) {
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(22);
        }
        if (fqName == null) {
            AnnotationsUtils.$$$reportNull$$$0(23);
        }
        if (descriptor.getAnnotations().hasAnnotation(fqName)) {
            return true;
        }
        ClassDescriptor containingClass = DescriptorUtils.getContainingClass(descriptor);
        return containingClass != null && AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass((DeclarationDescriptor)containingClass, fqName);
    }

    public static boolean hasJsNameInAccessors(@NotNull PropertyDescriptor property2) {
        if (property2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(24);
        }
        for (PropertyAccessorDescriptor accessor : property2.getAccessors()) {
            if (AnnotationsUtils.getJsName(accessor) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getModuleName(@NotNull DeclarationDescriptor declaration) {
        AnnotationDescriptor annotation;
        if (declaration == null) {
            AnnotationsUtils.$$$reportNull$$$0(25);
        }
        return (annotation = declaration.getAnnotations().findAnnotation(JS_MODULE_ANNOTATION)) != null ? AnnotationsUtils.extractSingleStringArgument(annotation) : null;
    }

    @Nullable
    public static String getFileModuleName(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor declaration) {
        if (bindingContext == null) {
            AnnotationsUtils.$$$reportNull$$$0(26);
        }
        if (declaration == null) {
            AnnotationsUtils.$$$reportNull$$$0(27);
        }
        return AnnotationsUtils.getSingleStringAnnotationArgument(bindingContext, declaration, JS_MODULE_ANNOTATION);
    }

    @Nullable
    private static String getSingleStringAnnotationArgument(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor declaration, @NotNull FqName annotationFqName) {
        if (bindingContext == null) {
            AnnotationsUtils.$$$reportNull$$$0(28);
        }
        if (declaration == null) {
            AnnotationsUtils.$$$reportNull$$$0(29);
        }
        if (annotationFqName == null) {
            AnnotationsUtils.$$$reportNull$$$0(30);
        }
        for (AnnotationDescriptor annotation : AnnotationsUtils.getContainingFileAnnotations(bindingContext, declaration)) {
            if (!annotationFqName.equals((Object)annotation.getFqName())) continue;
            return AnnotationsUtils.extractSingleStringArgument(annotation);
        }
        return null;
    }

    public static boolean isNonModule(@NotNull DeclarationDescriptor declaration) {
        if (declaration == null) {
            AnnotationsUtils.$$$reportNull$$$0(31);
        }
        return declaration.getAnnotations().findAnnotation(JS_NON_MODULE_ANNOTATION) != null;
    }

    public static boolean isFromNonModuleFile(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor declaration) {
        if (bindingContext == null) {
            AnnotationsUtils.$$$reportNull$$$0(32);
        }
        if (declaration == null) {
            AnnotationsUtils.$$$reportNull$$$0(33);
        }
        return CollectionsKt.any(AnnotationsUtils.getContainingFileAnnotations(bindingContext, declaration), annotation -> JS_NON_MODULE_ANNOTATION.equals((Object)annotation.getFqName()));
    }

    public static boolean isJsExternalInheritorsOnly(@NotNull ClassDescriptor declaration) {
        if (declaration == null) {
            AnnotationsUtils.$$$reportNull$$$0(34);
        }
        return declaration.getAnnotations().hasAnnotation(JS_EXTERNAL_INHERITORS_ONLY);
    }

    public static boolean isJsExternalArgument(@NotNull ValueParameterDescriptor declaration) {
        if (declaration == null) {
            AnnotationsUtils.$$$reportNull$$$0(35);
        }
        return declaration.getAnnotations().hasAnnotation(JS_EXTERNAL_ARGUMENT);
    }

    @Nullable
    private static String extractSingleStringArgument(@NotNull AnnotationDescriptor annotation) {
        if (annotation == null) {
            AnnotationsUtils.$$$reportNull$$$0(36);
        }
        if (annotation.getAllValueArguments().isEmpty()) {
            return null;
        }
        ConstantValue<?> importValue = annotation.getAllValueArguments().values().iterator().next();
        if (importValue == null) {
            return null;
        }
        if (!(importValue.getValue() instanceof String)) {
            return null;
        }
        return (String)importValue.getValue();
    }

    @NotNull
    public static List<AnnotationDescriptor> getContainingFileAnnotations(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor descriptor) {
        PackageFragmentDescriptor containingPackage;
        if (bindingContext == null) {
            AnnotationsUtils.$$$reportNull$$$0(37);
        }
        if (descriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(38);
        }
        if ((containingPackage = DescriptorUtils.getParentOfType(descriptor, PackageFragmentDescriptor.class, false)) instanceof KotlinJavascriptPackageFragment) {
            List<AnnotationDescriptor> list = ((KotlinJavascriptPackageFragment)containingPackage).getContainingFileAnnotations(descriptor);
            if (list == null) {
                AnnotationsUtils.$$$reportNull$$$0(39);
            }
            return list;
        }
        KtFile kotlinFile = AnnotationsUtils.getFile(descriptor);
        if (kotlinFile != null) {
            ArrayList<AnnotationDescriptor> annotations = new ArrayList<AnnotationDescriptor>();
            for (KtAnnotationEntry psiAnnotation : kotlinFile.getAnnotationEntries()) {
                AnnotationDescriptor annotation = bindingContext.get(BindingContext.ANNOTATION, psiAnnotation);
                if (annotation == null) continue;
                annotations.add(annotation);
            }
            ArrayList<AnnotationDescriptor> arrayList = annotations;
            if (arrayList == null) {
                AnnotationsUtils.$$$reportNull$$$0(40);
            }
            return arrayList;
        }
        List<AnnotationDescriptor> list = Collections.emptyList();
        if (list == null) {
            AnnotationsUtils.$$$reportNull$$$0(41);
        }
        return list;
    }

    @Nullable
    private static KtFile getFile(DeclarationDescriptor descriptor) {
        if (!(descriptor instanceof DeclarationDescriptorWithSource)) {
            return null;
        }
        SourceFile file = ((DeclarationDescriptorWithSource)descriptor).getSource().getContainingFile();
        if (!(file instanceof PsiSourceFile)) {
            return null;
        }
        PsiFile psiFile = ((PsiSourceFile)file).getPsiFile();
        if (!(psiFile instanceof KtFile)) {
            return null;
        }
        return (KtFile)psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 21: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationDescriptor";
                break;
            }
            case 7: 
            case 11: 
            case 26: 
            case 28: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFqName";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFileAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationStringParameter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNameForAnnotatedObject";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationByName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isExportedObject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNativeObject";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNativeInterface";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isEffectivelyExternalMember";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryObject";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getJsName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getJsNameAnnotation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getJsExportAnnotation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedObject";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotationOrInsideAnnotatedClass";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasJsNameInAccessors";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFileModuleName";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSingleStringAnnotationArgument";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isNonModule";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isFromNonModuleFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isJsExternalInheritorsOnly";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isJsExternalArgument";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "extractSingleStringArgument";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFileAnnotations";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

