/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue.quickfix;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiPredicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.settings.GradleConfigurable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0015B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/gradle/issue/quickfix/GradleSettingsQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "myProjectPath", "", "myRequestImport", "", "myConfigurationChangeDetector", "Ljava/util/function/BiPredicate;", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "myFilter", "<init>", "(Ljava/lang/String;ZLjava/util/function/BiPredicate;Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "GradleJvmChangeDetector", "intellij.gradle"})
@ApiStatus.Experimental
public final class GradleSettingsQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final String myProjectPath;
    private final boolean myRequestImport;
    @Nullable
    private final BiPredicate<GradleProjectSettings, GradleProjectSettings> myConfigurationChangeDetector;
    @Nullable
    private final String myFilter;
    @NotNull
    private final String id;

    public GradleSettingsQuickFix(@NotNull String myProjectPath, boolean myRequestImport, @Nullable BiPredicate<GradleProjectSettings, GradleProjectSettings> myConfigurationChangeDetector, @Nullable String myFilter) {
        Intrinsics.checkNotNullParameter((Object)myProjectPath, (String)"myProjectPath");
        this.myProjectPath = myProjectPath;
        this.myRequestImport = myRequestImport;
        this.myConfigurationChangeDetector = myConfigurationChangeDetector;
        this.myFilter = myFilter;
        this.id = "fix_gradle_settings";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(this.myProjectPath);
        if (gradleProjectSettings == null) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        GradleProjectSettings projectSettings = gradleProjectSettings;
        CompletableFuture future = new CompletableFuture();
        ApplicationManager.getApplication().invokeLater(() -> GradleSettingsQuickFix.runQuickFix$lambda$0(projectSettings, project, this, future));
        CompletionStage completionStage = future.thenCompose(arg_0 -> GradleSettingsQuickFix.runQuickFix$lambda$2(arg_0 -> GradleSettingsQuickFix.runQuickFix$lambda$1(this, project, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    private static final void runQuickFix$lambda$0(GradleProjectSettings $projectSettings, Project $project, GradleSettingsQuickFix this$0, CompletableFuture $future) {
        GradleProjectSettings oldSettings = null;
        oldSettings = $projectSettings.clone();
        Object[] groups = ShowSettingsUtilImpl.Companion.getConfigurableGroups($project, true);
        Configurable configurable = ConfigurableVisitor.findByType(GradleConfigurable.class, (List)ArraysKt.toList((Object[])groups));
        DialogWrapper dialogWrapper = SettingsDialogFactory.Companion.getInstance().create($project, (ConfigurableGroup[])groups, configurable, this$0.myFilter);
        boolean result = dialogWrapper.showAndGet();
        $future.complete(result && this$0.myConfigurationChangeDetector != null && this$0.myConfigurationChangeDetector.test(oldSettings, $projectSettings));
    }

    private static final CompletionStage runQuickFix$lambda$1(GradleSettingsQuickFix this$0, Project $project, Boolean isSettingsChanged) {
        Boolean bl = isSettingsChanged;
        Intrinsics.checkNotNull((Object)bl);
        return bl != false && this$0.myRequestImport ? ExternalSystemUtil.requestImport((Project)$project, (String)this$0.myProjectPath, (ProjectSystemId)GradleConstants.SYSTEM_ID) : CompletableFuture.completedFuture(null);
    }

    private static final CompletionStage runQuickFix$lambda$2(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/issue/quickfix/GradleSettingsQuickFix$GradleJvmChangeDetector;", "Ljava/util/function/BiPredicate;", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "<init>", "()V", "test", "", "t", "u", "intellij.gradle"})
    public static final class GradleJvmChangeDetector
    implements BiPredicate<GradleProjectSettings, GradleProjectSettings> {
        @NotNull
        public static final GradleJvmChangeDetector INSTANCE = new GradleJvmChangeDetector();

        private GradleJvmChangeDetector() {
        }

        @Override
        public boolean test(@NotNull GradleProjectSettings t, @NotNull GradleProjectSettings u) {
            Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
            Intrinsics.checkNotNullParameter((Object)((Object)u), (String)"u");
            return !Intrinsics.areEqual((Object)t.getGradleJvm(), (Object)u.getGradleJvm());
        }
    }
}

