/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.tree.Parameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class AccessedParameters {
    private static final ThreadLocal<AccessedParameters> current = new ThreadLocal();
    final Map<String, Set<Parameter>> result = new HashMap<String, Set<Parameter>>();
    @Nullable
    private final AccessedParameters prev = AccessedParameters.current();
    boolean prohibitAccess;
    String ruleId;

    public static AccessedParameters start() {
        AccessedParameters token = new AccessedParameters();
        current.set(token);
        return token;
    }

    public Map<String, Set<Parameter>> finish() {
        assert (AccessedParameters.current() == this);
        if (this.prev == null) {
            current.remove();
        } else {
            current.set(this.prev);
        }
        return this.result;
    }

    void accessed(Parameter parameter) {
        if (this.prohibitAccess) {
            throw new IllegalStateException("Crazy parses should not depend on parameters; accessed " + String.valueOf(parameter));
        }
        assert (this.ruleId != null);
        this.result.computeIfAbsent(this.ruleId, __ -> new HashSet()).add(parameter);
    }

    @Nullable
    static AccessedParameters current() {
        return current.get();
    }
}

