/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.defaults.metadata;

import com.jetbrains.fus.reporting.FileStorage;
import com.jetbrains.fus.reporting.FusHttpClient;
import com.jetbrains.fus.reporting.FusLoggerFactory;
import com.jetbrains.fus.reporting.HttpResponse;
import com.jetbrains.fus.reporting.Logger;
import com.jetbrains.fus.reporting.RemoteConfig;
import com.jetbrains.fus.reporting.defaults.MetadataUpdateDelay;
import com.jetbrains.fus.reporting.defaults.retry.Retrier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001.B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0018H\u0004J<\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001b2\u001a\u0010%\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020(0'0&H\u0004J!\u0010)\u001a\u00020\u00182\u0017\u0010*\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180+\u00a2\u0006\u0002\b,H\u0004J\u0014\u0010-\u001a\u00020\u001b*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006/"}, d2={"Lcom/jetbrains/fus/reporting/defaults/metadata/AbstractMetadataFileUpdater;", "", "loggerFactory", "Lcom/jetbrains/fus/reporting/FusLoggerFactory;", "httpClient", "Lcom/jetbrains/fus/reporting/FusHttpClient;", "fileStorage", "Lcom/jetbrains/fus/reporting/FileStorage;", "remoteConfig", "Lcom/jetbrains/fus/reporting/RemoteConfig;", "metadataUpdateDelay", "Lcom/jetbrains/fus/reporting/defaults/MetadataUpdateDelay;", "(Lcom/jetbrains/fus/reporting/FusLoggerFactory;Lcom/jetbrains/fus/reporting/FusHttpClient;Lcom/jetbrains/fus/reporting/FileStorage;Lcom/jetbrains/fus/reporting/RemoteConfig;Lcom/jetbrains/fus/reporting/defaults/MetadataUpdateDelay;)V", "log", "Lcom/jetbrains/fus/reporting/Logger;", "retrier", "Lcom/jetbrains/fus/reporting/defaults/retry/Retrier;", "getRetrier", "()Lcom/jetbrains/fus/reporting/defaults/retry/Retrier;", "setRetrier", "(Lcom/jetbrains/fus/reporting/defaults/retry/Retrier;)V", "cacheFileContent", "", "fileName", "", "content", "lastModified", "", "getCachedFileContent", "getLastModifiedOnServer", "url", "getNewestFile", "Lcom/jetbrains/fus/reporting/defaults/metadata/AbstractMetadataFileUpdater$MetadataFile;", "localFileName", "remoteFileUrl", "otherSourceDescriptor", "otherLastModified", "otherValueSupplier", "Lkotlin/Function0;", "Lkotlin/Pair;", "", "safeCallRemoteConfig", "call", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getLastModified", "MetadataFile", "api-jvm-defaults"})
public abstract class AbstractMetadataFileUpdater {
    @NotNull
    private final FusHttpClient httpClient;
    @NotNull
    private final FileStorage fileStorage;
    @NotNull
    private final RemoteConfig remoteConfig;
    @NotNull
    private final Logger log;
    @NotNull
    private Retrier retrier;

    public AbstractMetadataFileUpdater(@NotNull FusLoggerFactory loggerFactory, @NotNull FusHttpClient httpClient, @NotNull FileStorage fileStorage, @NotNull RemoteConfig remoteConfig, @NotNull MetadataUpdateDelay metadataUpdateDelay) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)fileStorage, (String)"fileStorage");
        Intrinsics.checkNotNullParameter((Object)remoteConfig, (String)"remoteConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)metadataUpdateDelay), (String)"metadataUpdateDelay");
        this.httpClient = httpClient;
        this.fileStorage = fileStorage;
        this.remoteConfig = remoteConfig;
        String string2 = Reflection.getOrCreateKotlinClass(AbstractMetadataFileUpdater.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string2);
        this.log = loggerFactory.getLogger(string2);
        this.retrier = new Retrier(metadataUpdateDelay.getDuration-UwyO8pc(), 0, 2, null);
    }

    @NotNull
    protected final Retrier getRetrier() {
        return this.retrier;
    }

    protected final void setRetrier(@NotNull Retrier retrier) {
        Intrinsics.checkNotNullParameter((Object)retrier, (String)"<set-?>");
        this.retrier = retrier;
    }

    private final long getLastModifiedOnServer(String url) {
        return this.httpClient.lastModified(url);
    }

    private final void cacheFileContent(String fileName, String content, long lastModified) {
        String string2 = content;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.fileStorage.write(fileName, byArray);
        String string3 = fileName + ".meta";
        string2 = String.valueOf(lastModified);
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        this.fileStorage.write(string3, byArray2);
    }

    protected final long getLastModified(@NotNull FileStorage $this$getLastModified, @NotNull String fileName) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$getLastModified, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        byte[] byArray = $this$getLastModified.read(fileName + ".meta");
        if (byArray == null) {
            return 0L;
        }
        byte[] content = byArray;
        String contentString = new String(content, Charsets.UTF_8);
        try {
            l = Long.parseLong(contentString);
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        return l;
    }

    private final String getCachedFileContent(String fileName) {
        byte[] byArray = this.fileStorage.read(fileName);
        if (byArray == null) {
            return "";
        }
        byte[] content = byArray;
        return new String(content, Charsets.UTF_8);
    }

    @NotNull
    protected final MetadataFile getNewestFile(@NotNull String localFileName, @NotNull String remoteFileUrl) {
        Intrinsics.checkNotNullParameter((Object)localFileName, (String)"localFileName");
        Intrinsics.checkNotNullParameter((Object)remoteFileUrl, (String)"remoteFileUrl");
        return this.getNewestFile(localFileName, "REMOTE", this.getLastModifiedOnServer(remoteFileUrl), (Function0<Pair<String, Integer>>)((Function0)new Function0<Pair<? extends String, ? extends Integer>>(this, remoteFileUrl){
            final /* synthetic */ AbstractMetadataFileUpdater this$0;
            final /* synthetic */ String $remoteFileUrl;
            {
                this.this$0 = $receiver;
                this.$remoteFileUrl = $remoteFileUrl;
                super(0);
            }

            @NotNull
            public final Pair<String, Integer> invoke() {
                HttpResponse result2 = AbstractMetadataFileUpdater.access$getHttpClient$p(this.this$0).get(this.$remoteFileUrl);
                return TuplesKt.to((Object)result2.getBody(), (Object)result2.getStatusCode());
            }
        }));
    }

    @NotNull
    protected final MetadataFile getNewestFile(@NotNull String localFileName, @NotNull String otherSourceDescriptor, long otherLastModified, @NotNull Function0<Pair<String, Integer>> otherValueSupplier) {
        MetadataFile metadataFile;
        Intrinsics.checkNotNullParameter((Object)localFileName, (String)"localFileName");
        Intrinsics.checkNotNullParameter((Object)otherSourceDescriptor, (String)"otherSourceDescriptor");
        Intrinsics.checkNotNullParameter(otherValueSupplier, (String)"otherValueSupplier");
        long lastModifiedLocally = this.getLastModified(this.fileStorage, localFileName);
        boolean localFileExists = this.fileStorage.exists(localFileName);
        if (otherLastModified < 0L || otherLastModified > lastModifiedLocally || !localFileExists) {
            Pair pair = (Pair)otherValueSupplier.invoke();
            String content = (String)pair.component1();
            int statusCode = ((Number)pair.component2()).intValue();
            if (content == null) {
                this.log.info("Failed to get " + otherSourceDescriptor + " file for '" + localFileName + "'");
                return new MetadataFile(null, 0L, false, statusCode);
            }
            this.cacheFileContent(localFileName, content, otherLastModified);
            this.log.info("Updated local file '" + localFileName + "' from " + otherSourceDescriptor);
            metadataFile = new MetadataFile(content, otherLastModified, false, 0, 8, null);
        } else {
            this.log.info(localFileName + " is already up to date");
            metadataFile = new MetadataFile(this.getCachedFileContent(localFileName), lastModifiedLocally, true, 0, 8, null);
        }
        return metadataFile;
    }

    @NotNull
    protected final String safeCallRemoteConfig(@NotNull Function1<? super RemoteConfig, String> call2) {
        String string2;
        Intrinsics.checkNotNullParameter(call2, (String)"call");
        try {
            string2 = (String)call2.invoke((Object)this.remoteConfig);
        }
        catch (Exception e2) {
            this.log.info("Failed to retrieve remote configuration: " + e2.getMessage());
            string2 = "";
        }
        return string2;
    }

    public static final /* synthetic */ FusHttpClient access$getHttpClient$p(AbstractMetadataFileUpdater $this) {
        return $this.httpClient;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\b\u0084\b\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/fus/reporting/defaults/metadata/AbstractMetadataFileUpdater$MetadataFile;", "", "content", "", "lastModified", "", "cacheWasUsed", "", "statusCode", "", "(Ljava/lang/String;JZI)V", "getCacheWasUsed", "()Z", "getContent", "()Ljava/lang/String;", "getLastModified", "()J", "getStatusCode", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "api-jvm-defaults"})
    protected static final class MetadataFile {
        @Nullable
        private final String content;
        private final long lastModified;
        private final boolean cacheWasUsed;
        private final int statusCode;

        public MetadataFile(@Nullable String content, long lastModified, boolean cacheWasUsed, int statusCode) {
            this.content = content;
            this.lastModified = lastModified;
            this.cacheWasUsed = cacheWasUsed;
            this.statusCode = statusCode;
        }

        public /* synthetic */ MetadataFile(String string2, long l, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                n = -1;
            }
            this(string2, l, bl, n);
        }

        @Nullable
        public final String getContent() {
            return this.content;
        }

        public final long getLastModified() {
            return this.lastModified;
        }

        public final boolean getCacheWasUsed() {
            return this.cacheWasUsed;
        }

        public final int getStatusCode() {
            return this.statusCode;
        }

        @Nullable
        public final String component1() {
            return this.content;
        }

        public final long component2() {
            return this.lastModified;
        }

        public final boolean component3() {
            return this.cacheWasUsed;
        }

        public final int component4() {
            return this.statusCode;
        }

        @NotNull
        public final MetadataFile copy(@Nullable String content, long lastModified, boolean cacheWasUsed, int statusCode) {
            return new MetadataFile(content, lastModified, cacheWasUsed, statusCode);
        }

        public static /* synthetic */ MetadataFile copy$default(MetadataFile metadataFile, String string2, long l, boolean bl, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string2 = metadataFile.content;
            }
            if ((n2 & 2) != 0) {
                l = metadataFile.lastModified;
            }
            if ((n2 & 4) != 0) {
                bl = metadataFile.cacheWasUsed;
            }
            if ((n2 & 8) != 0) {
                n = metadataFile.statusCode;
            }
            return metadataFile.copy(string2, l, bl, n);
        }

        @NotNull
        public String toString() {
            return "MetadataFile(content=" + this.content + ", lastModified=" + this.lastModified + ", cacheWasUsed=" + this.cacheWasUsed + ", statusCode=" + this.statusCode + ")";
        }

        public int hashCode() {
            int result2 = this.content == null ? 0 : this.content.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.lastModified);
            result2 = result2 * 31 + Boolean.hashCode(this.cacheWasUsed);
            result2 = result2 * 31 + Integer.hashCode(this.statusCode);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MetadataFile)) {
                return false;
            }
            MetadataFile metadataFile = (MetadataFile)other;
            if (!Intrinsics.areEqual((Object)this.content, (Object)metadataFile.content)) {
                return false;
            }
            if (this.lastModified != metadataFile.lastModified) {
                return false;
            }
            if (this.cacheWasUsed != metadataFile.cacheWasUsed) {
                return false;
            }
            return this.statusCode == metadataFile.statusCode;
        }
    }
}

