/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import java.awt.Container;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.core.ContainerFocusOwnerFinder;
import org.assertj.swing.core.FocusOwnerFinderStrategy;
import org.assertj.swing.core.HierarchyRootsSource;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

class HierarchyBasedFocusOwnerFinder
implements FocusOwnerFinderStrategy {
    private final ContainerFocusOwnerFinder delegate;
    private final HierarchyRootsSource rootsSource;

    HierarchyBasedFocusOwnerFinder() {
        this(new ContainerFocusOwnerFinder(), new HierarchyRootsSource());
    }

    HierarchyBasedFocusOwnerFinder(@Nonnull ContainerFocusOwnerFinder newDelegate, @Nonnull HierarchyRootsSource newRootsSource) {
        this.delegate = newDelegate;
        this.rootsSource = newRootsSource;
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public Component focusOwner() {
        for (Container c : this.rootsSource.existingHierarchyRoots()) {
            Component focus = this.delegate.focusOwnerOf(c);
            if (focus == null) continue;
            return focus;
        }
        return null;
    }
}

