/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/SynchronizedAnnotationOnLambdaChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "<init>", "()V", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nSynchronizedAnnotationOnLambdaChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SynchronizedAnnotationOnLambdaChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/SynchronizedAnnotationOnLambdaChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class SynchronizedAnnotationOnLambdaChecker
implements AdditionalAnnotationChecker {
    @NotNull
    public static final SynchronizedAnnotationOnLambdaChecker INSTANCE = new SynchronizedAnnotationOnLambdaChecker();

    private SynchronizedAnnotationOnLambdaChecker() {
    }

    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace, @Nullable KtAnnotated annotated, @NotNull LanguageVersionSettings languageVersionSettings) {
        Object v1;
        Iterable iterable;
        block5: {
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            Intrinsics.checkNotNullParameter(actualTargets, (String)"actualTargets");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            if (entries.isEmpty()) {
                return;
            }
            iterable = entries;
            for (Object t : iterable) {
                KtAnnotationEntry it = (KtAnnotationEntry)t;
                boolean bl = false;
                AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)trace.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)it);
                if (!Intrinsics.areEqual((Object)(annotationDescriptor != null ? annotationDescriptor.getFqName() : null), (Object)JvmStandardClassIds.SYNCHRONIZED_ANNOTATION_FQ_NAME)) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        KtAnnotationEntry ktAnnotationEntry = v1;
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotation = ktAnnotationEntry;
        KtAnnotated ktAnnotated = annotated;
        iterable = ktAnnotated != null ? PsiUtilsKt.unwrapParenthesesLabelsAndAnnotations((PsiElement)ktAnnotated) : null;
        KtExpression ktExpression = iterable instanceof KtLambdaExpression ? (KtLambdaExpression)((Object)iterable) : null;
        if (ktExpression == null || (ktExpression = ktExpression.getFunctionLiteral()) == null) {
            return;
        }
        KtExpression literal = ktExpression;
        DeclarationDescriptor descriptor = (DeclarationDescriptor)trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)literal);
        if (descriptor instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor).isSuspend()) {
            trace.report((Diagnostic)ErrorsJvm.SYNCHRONIZED_ON_SUSPEND.on(languageVersionSettings, (PsiElement)annotation));
        }
    }
}

