/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.Failure;
import com.intellij.openapi.externalSystem.model.task.event.FailureResult;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.TestAssertionFailure;
import com.intellij.openapi.externalSystem.model.task.event.TestFailure;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0001\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ2\u0010\r\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000ej\u0004\u0018\u0001`\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000ej\u0002`\u00102\u0006\u0010\u0012\u001a\u00020\u0005J$\u0010\u0013\u001a\u00020\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000ej\u0002`\u00102\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u001e\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000ej\u0002`\u0010H\u0002J<\u0010\u0016\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000ej\u0002`\u00102\u0012\u0010\u0017\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000ej\u0002`\u00102\u0012\u0010\u0018\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000ej\u0002`\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/events/GradleFileComparisonEventPatcher;", "", "<init>", "()V", "isBuiltInTestEventsUsed", "", "events", "Ljava/util/HashMap;", "", "Lorg/jetbrains/plugins/gradle/execution/test/runner/events/GradleFileComparisonEventPatcher$TestEventData;", "Lkotlin/collections/HashMap;", "setBuiltInTestEventsUsed", "", "patchTestFinishEvent", "Lcom/intellij/openapi/externalSystem/model/task/event/ExternalSystemFinishEvent;", "Lcom/intellij/openapi/externalSystem/model/task/event/TestOperationDescriptor;", "Lorg/jetbrains/plugins/gradle/execution/test/runner/events/TestFinishEvent;", "event", "isXml", "getDebugInfo", "eventData", "getEventPatchId", "createTestFinishEvent", "tapiEvent", "xmlEvent", "TestEventData", "Companion", "intellij.gradle.java"})
@ApiStatus.Internal
public final class GradleFileComparisonEventPatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isBuiltInTestEventsUsed;
    @NotNull
    private final HashMap<String, TestEventData> events = new HashMap();
    @NotNull
    private static final String FILE_COMPARISON_FAILURE = "com.intellij.rt.execution.junit.FileComparisonFailure";

    public final void setBuiltInTestEventsUsed() {
        this.isBuiltInTestEventsUsed = true;
    }

    @Nullable
    public final ExternalSystemFinishEvent<? extends TestOperationDescriptor> patchTestFinishEvent(@NotNull ExternalSystemFinishEvent<? extends TestOperationDescriptor> event, boolean isXml) {
        ExternalSystemFinishEvent<? extends TestOperationDescriptor> externalSystemFinishEvent;
        ExternalSystemFinishEvent<? extends TestOperationDescriptor> externalSystemFinishEvent2;
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (!this.isBuiltInTestEventsUsed) {
            return event;
        }
        String string = this.getEventPatchId(event);
        if (string == null) {
            return event;
        }
        String patchId = string;
        TestEventData eventData = this.events.get(patchId);
        if (eventData == null) {
            Map map = this.events;
            TestEventData testEventData = isXml ? new TestEventData(event, null) : new TestEventData(null, event);
            map.put(patchId, testEventData);
            return null;
        }
        if (isXml) {
            if (!(eventData.getXmlTestEvent() == null)) {
                boolean $i$a$-check-GradleFileComparisonEventPatcher$patchTestFinishEvent$32 = false;
                String $i$a$-check-GradleFileComparisonEventPatcher$patchTestFinishEvent$32 = "Found XML test event duplication.\n" + this.getDebugInfo(event, eventData);
                throw new IllegalStateException($i$a$-check-GradleFileComparisonEventPatcher$patchTestFinishEvent$32.toString());
            }
        } else if (!(eventData.getTapiTestEvent() == null)) {
            boolean bl = false;
            String string2 = "Found TAPI test event duplication.\n" + this.getDebugInfo(event, eventData);
            throw new IllegalStateException(string2.toString());
        }
        if (!isXml) {
            externalSystemFinishEvent2 = event;
        } else {
            ExternalSystemFinishEvent<? extends TestOperationDescriptor> externalSystemFinishEvent3 = eventData.getTapiTestEvent();
            externalSystemFinishEvent2 = externalSystemFinishEvent3;
            Intrinsics.checkNotNull(externalSystemFinishEvent3);
        }
        ExternalSystemFinishEvent<? extends TestOperationDescriptor> tapiTestEvent = externalSystemFinishEvent2;
        if (isXml) {
            externalSystemFinishEvent = event;
        } else {
            ExternalSystemFinishEvent<? extends TestOperationDescriptor> externalSystemFinishEvent4 = eventData.getXmlTestEvent();
            externalSystemFinishEvent = externalSystemFinishEvent4;
            Intrinsics.checkNotNull(externalSystemFinishEvent4);
        }
        ExternalSystemFinishEvent<? extends TestOperationDescriptor> xmlTestEvent = externalSystemFinishEvent;
        ((Map)this.events).put(patchId, new TestEventData(xmlTestEvent, tapiTestEvent));
        return this.createTestFinishEvent(tapiTestEvent, xmlTestEvent);
    }

    private final String getDebugInfo(ExternalSystemFinishEvent<? extends TestOperationDescriptor> event, TestEventData eventData) {
        ExternalSystemFinishEvent<? extends TestOperationDescriptor> xmlTestEvent = eventData.getXmlTestEvent();
        ExternalSystemFinishEvent<? extends TestOperationDescriptor> tapiTestEvent = eventData.getTapiTestEvent();
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add("Current event:");
        joiner.add("    ID=" + event.getEventId());
        joiner.add("    PARENT_ID=" + event.getParentEventId());
        joiner.add("    TIME=" + event.getEventTime());
        joiner.add("    NAME=" + event.getDisplayName());
        if (xmlTestEvent != null) {
            joiner.add("XML event:");
            joiner.add("    ID=" + xmlTestEvent.getEventId());
            joiner.add("    PARENT_ID=" + xmlTestEvent.getParentEventId());
            joiner.add("    TIME=" + xmlTestEvent.getEventTime());
            v0 = joiner.add("    NAME=" + xmlTestEvent.getDisplayName());
        } else {
            v0 = joiner.add("XML event = null");
        }
        if (tapiTestEvent != null) {
            joiner.add("TAPI event:");
            joiner.add("    ID=" + tapiTestEvent.getEventId());
            joiner.add("    PARENT_ID=" + tapiTestEvent.getParentEventId());
            joiner.add("    TIME=" + tapiTestEvent.getEventTime());
            v1 = joiner.add("    NAME=" + tapiTestEvent.getDisplayName());
        } else {
            v1 = joiner.add("TAPI event = null");
        }
        String string = joiner.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getEventPatchId(ExternalSystemFinishEvent<? extends TestOperationDescriptor> event) {
        Failure failure;
        OperationResult operationResult = event.getOperationResult();
        if (operationResult instanceof FailureResult && (failure = (Failure)CollectionsKt.singleOrNull((List)((FailureResult)operationResult).getFailures())) instanceof TestFailure && Intrinsics.areEqual((Object)((TestFailure)failure).getExceptionName(), (Object)FILE_COMPARISON_FAILURE)) {
            return ((TestFailure)failure).getStackTrace();
        }
        return null;
    }

    private final ExternalSystemFinishEvent<? extends TestOperationDescriptor> createTestFinishEvent(ExternalSystemFinishEvent<? extends TestOperationDescriptor> tapiEvent, ExternalSystemFinishEvent<? extends TestOperationDescriptor> xmlEvent) {
        OperationResult tapiOperationResult = tapiEvent.getOperationResult();
        OperationResult xmlOperationResult = xmlEvent.getOperationResult();
        if (tapiOperationResult instanceof FailureResult && xmlOperationResult instanceof FailureResult) {
            Failure tapiFailure = (Failure)CollectionsKt.singleOrNull((List)((FailureResult)tapiOperationResult).getFailures());
            Failure xmlFailure = (Failure)CollectionsKt.singleOrNull((List)((FailureResult)xmlOperationResult).getFailures());
            if (tapiFailure instanceof TestFailure && xmlFailure instanceof TestAssertionFailure) {
                TestAssertionFailure failure = new TestAssertionFailure(((TestFailure)tapiFailure).getExceptionName(), ((TestFailure)tapiFailure).getMessage(), ((TestFailure)tapiFailure).getStackTrace(), ((TestFailure)tapiFailure).getDescription(), ((TestFailure)tapiFailure).getCauses(), ((TestAssertionFailure)xmlFailure).getExpectedText(), ((TestAssertionFailure)xmlFailure).getActualText(), ((TestAssertionFailure)xmlFailure).getExpectedFile(), ((TestAssertionFailure)xmlFailure).getActualFile());
                FailureResult failureResult = new FailureResult(tapiOperationResult.getStartTime(), tapiOperationResult.getEndTime(), CollectionsKt.listOf((Object)failure));
                return new ExternalSystemFinishEvent(tapiEvent.getEventId(), tapiEvent.getParentEventId(), tapiEvent.getDescriptor(), (OperationResult)failureResult);
            }
        }
        return tapiEvent;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/events/GradleFileComparisonEventPatcher$Companion;", "", "<init>", "()V", "FILE_COMPARISON_FAILURE", "", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003j\u0004\u0018\u0001`\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003j\u0004\u0018\u0001`\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR!\u0010\u0002\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003j\u0004\u0018\u0001`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u0006\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003j\u0004\u0018\u0001`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/events/GradleFileComparisonEventPatcher$TestEventData;", "", "xmlTestEvent", "Lcom/intellij/openapi/externalSystem/model/task/event/ExternalSystemFinishEvent;", "Lcom/intellij/openapi/externalSystem/model/task/event/TestOperationDescriptor;", "Lorg/jetbrains/plugins/gradle/execution/test/runner/events/TestFinishEvent;", "tapiTestEvent", "<init>", "(Lcom/intellij/openapi/externalSystem/model/task/event/ExternalSystemFinishEvent;Lcom/intellij/openapi/externalSystem/model/task/event/ExternalSystemFinishEvent;)V", "getXmlTestEvent", "()Lcom/intellij/openapi/externalSystem/model/task/event/ExternalSystemFinishEvent;", "getTapiTestEvent", "intellij.gradle.java"})
    private static final class TestEventData {
        @Nullable
        private final ExternalSystemFinishEvent<? extends TestOperationDescriptor> xmlTestEvent;
        @Nullable
        private final ExternalSystemFinishEvent<? extends TestOperationDescriptor> tapiTestEvent;

        public TestEventData(@Nullable ExternalSystemFinishEvent<? extends TestOperationDescriptor> xmlTestEvent, @Nullable ExternalSystemFinishEvent<? extends TestOperationDescriptor> tapiTestEvent) {
            this.xmlTestEvent = xmlTestEvent;
            this.tapiTestEvent = tapiTestEvent;
        }

        @Nullable
        public final ExternalSystemFinishEvent<? extends TestOperationDescriptor> getXmlTestEvent() {
            return this.xmlTestEvent;
        }

        @Nullable
        public final ExternalSystemFinishEvent<? extends TestOperationDescriptor> getTapiTestEvent() {
            return this.tapiTestEvent;
        }
    }
}

