/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.shared.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00072\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0007R(\u0010\u0004\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006j\u0004\u0018\u0001`\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/vcs/impl/shared/ui/ToolWindowLazyContent;", "", "<init>", "()V", "CONTENT_SUPPLIER", "Lcom/intellij/openapi/util/Key;", "Lkotlin/Function1;", "Lcom/intellij/ui/content/Content;", "", "Lcom/intellij/platform/vcs/impl/shared/ui/ContentSupplier;", "setContentSupplier", "content", "supplier", "installInitializer", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "initLazyContent", "ContentInitializer", "intellij.platform.vcs.impl.shared"})
@ApiStatus.Internal
public final class ToolWindowLazyContent {
    @NotNull
    public static final ToolWindowLazyContent INSTANCE = new ToolWindowLazyContent();
    @NotNull
    private static final Key<Function1<Content, Unit>> CONTENT_SUPPLIER;

    private ToolWindowLazyContent() {
    }

    public final void setContentSupplier(@NotNull Content content, @NotNull Function1<? super Content, Unit> supplier) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        content.putUserData(CONTENT_SUPPLIER, supplier);
    }

    public final void installInitializer(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        ContentInitializer listener = new ContentInitializer(toolWindow);
        toolWindow.getContentManager().addContentManagerListener((ContentManagerListener)listener);
        Disposer.register((Disposable)toolWindow.getDisposable(), () -> ToolWindowLazyContent.installInitializer$lambda$0(toolWindow, listener));
        MessageBus messageBus = toolWindow.getProject().getMessageBus();
        Disposable disposable = toolWindow.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        MessageBusConnection messageBusConnection = messageBus.connect(disposable);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)listener);
    }

    public final void initLazyContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Function1 function1 = (Function1)content.getUserData(CONTENT_SUPPLIER);
        if (function1 == null) {
            return;
        }
        Function1 provider = function1;
        content.putUserData(CONTENT_SUPPLIER, null);
        ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> ToolWindowLazyContent.initLazyContent$lambda$0(provider, content));
    }

    private static final void installInitializer$lambda$0(ToolWindow $toolWindow, ContentInitializer $listener) {
        $toolWindow.getContentManager().removeContentManagerListener((ContentManagerListener)$listener);
    }

    private static final Unit initLazyContent$lambda$0(Function1 $provider, Content $content) {
        $provider.invoke((Object)$content);
        IJSwingUtilities.updateComponentTreeUI((Component)$content.getComponent());
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"CONTENT_SUPPLIER");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CONTENT_SUPPLIER = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/vcs/impl/shared/ui/ToolWindowLazyContent$ContentInitializer;", "Lcom/intellij/ui/content/ContentManagerListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "<init>", "(Lcom/intellij/openapi/wm/ToolWindow;)V", "stateChanged", "", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "selectionChanged", "event", "Lcom/intellij/ui/content/ContentManagerEvent;", "intellij.platform.vcs.impl.shared"})
    private static final class ContentInitializer
    implements ContentManagerListener,
    ToolWindowManagerListener {
        @NotNull
        private final ToolWindow toolWindow;

        public ContentInitializer(@NotNull ToolWindow toolWindow) {
            Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
            this.toolWindow = toolWindow;
        }

        public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
            Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
            if (this.toolWindow.isVisible()) {
                Content content = this.toolWindow.getContentManager().getSelectedContent();
                if (content == null) {
                    return;
                }
                Content content2 = content;
                INSTANCE.initLazyContent(content2);
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (this.toolWindow.isVisible()) {
                Content content = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                INSTANCE.initLazyContent(content);
            }
        }
    }
}

