/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.errors;

import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.streams.errors.ErrorHandlerContext;
import org.apache.kafka.streams.processor.api.Record;

public interface ProcessingExceptionHandler
extends Configurable {
    @Deprecated
    default public ProcessingHandlerResponse handle(ErrorHandlerContext context, Record<?, ?> record, Exception exception) {
        throw new UnsupportedOperationException();
    }

    default public Response handleError(ErrorHandlerContext context, Record<?, ?> record, Exception exception) {
        return new Response(Result.from(this.handle(context, record, exception)), Collections.emptyList());
    }

    public static class Response {
        private final Result result;
        private final List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords;

        private Response(Result result, List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords) {
            this.result = result;
            this.deadLetterQueueRecords = deadLetterQueueRecords;
        }

        public static Response fail(List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords) {
            return new Response(Result.FAIL, deadLetterQueueRecords);
        }

        public static Response fail() {
            return Response.fail(Collections.emptyList());
        }

        public static Response resume(List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords) {
            return new Response(Result.RESUME, deadLetterQueueRecords);
        }

        public static Response resume() {
            return Response.resume(Collections.emptyList());
        }

        public Result result() {
            return this.result;
        }

        public List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords() {
            if (this.deadLetterQueueRecords == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.deadLetterQueueRecords);
        }
    }

    @Deprecated
    public static enum ProcessingHandlerResponse {
        CONTINUE(1, "CONTINUE"),
        FAIL(2, "FAIL");

        public final String name;
        public final int id;

        private ProcessingHandlerResponse(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public static enum Result {
        RESUME(1, "RESUME"),
        FAIL(2, "FAIL");

        public final String name;
        public final int id;

        private Result(int id, String name) {
            this.id = id;
            this.name = name;
        }

        private static Result from(ProcessingHandlerResponse value) {
            switch (value.ordinal()) {
                case 1: {
                    return FAIL;
                }
                case 0: {
                    return RESUME;
                }
            }
            throw new IllegalArgumentException("No Result enum found for old value: " + String.valueOf((Object)value));
        }
    }
}

