/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collection;
import java.util.List;
import org.rocksdb.AbstractCompactionFilter;
import org.rocksdb.AbstractCompactionFilterFactory;
import org.rocksdb.AbstractComparator;
import org.rocksdb.AbstractEventListener;
import org.rocksdb.AbstractSlice;
import org.rocksdb.AbstractWalFilter;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionOptionsFIFO;
import org.rocksdb.CompactionOptionsUniversal;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.ConcurrentTaskLimiter;
import org.rocksdb.DBOptions;
import org.rocksdb.DbPath;
import org.rocksdb.Env;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.LoggerInterface;
import org.rocksdb.MemTableConfig;
import org.rocksdb.MergeOperator;
import org.rocksdb.Options;
import org.rocksdb.PrepopulateBlobCache;
import org.rocksdb.RateLimiter;
import org.rocksdb.SstFileManager;
import org.rocksdb.SstPartitionerFactory;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WALRecoveryMode;
import org.rocksdb.WalFilter;
import org.rocksdb.WriteBufferManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter
extends Options {
    private static final Logger log = LoggerFactory.getLogger(RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter.class);
    private final DBOptions dbOptions;
    private final ColumnFamilyOptions columnFamilyOptions;

    RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter(DBOptions dbOptions, ColumnFamilyOptions columnFamilyOptions) {
        this.dbOptions = dbOptions;
        this.columnFamilyOptions = columnFamilyOptions;
    }

    public Options setIncreaseParallelism(int totalThreads) {
        this.dbOptions.setIncreaseParallelism(totalThreads);
        return this;
    }

    public Options setCreateIfMissing(boolean flag) {
        this.dbOptions.setCreateIfMissing(flag);
        return this;
    }

    public Options setCreateMissingColumnFamilies(boolean flag) {
        this.dbOptions.setCreateMissingColumnFamilies(flag);
        return this;
    }

    public Options setEnv(Env env) {
        this.dbOptions.setEnv(env);
        return this;
    }

    public Env getEnv() {
        return this.dbOptions.getEnv();
    }

    public Options prepareForBulkLoad() {
        super.prepareForBulkLoad();
        return this;
    }

    public boolean createIfMissing() {
        return this.dbOptions.createIfMissing();
    }

    public boolean createMissingColumnFamilies() {
        return this.dbOptions.createMissingColumnFamilies();
    }

    public Options optimizeForSmallDb() {
        this.dbOptions.optimizeForSmallDb();
        this.columnFamilyOptions.optimizeForSmallDb();
        return this;
    }

    public Options optimizeForPointLookup(long blockCacheSizeMb) {
        this.columnFamilyOptions.optimizeForPointLookup(blockCacheSizeMb);
        return this;
    }

    public Options optimizeLevelStyleCompaction() {
        this.columnFamilyOptions.optimizeLevelStyleCompaction();
        return this;
    }

    public Options optimizeLevelStyleCompaction(long memtableMemoryBudget) {
        this.columnFamilyOptions.optimizeLevelStyleCompaction(memtableMemoryBudget);
        return this;
    }

    public Options optimizeUniversalStyleCompaction() {
        this.columnFamilyOptions.optimizeUniversalStyleCompaction();
        return this;
    }

    public Options optimizeUniversalStyleCompaction(long memtableMemoryBudget) {
        this.columnFamilyOptions.optimizeUniversalStyleCompaction(memtableMemoryBudget);
        return this;
    }

    public Options setComparator(BuiltinComparator builtinComparator) {
        this.columnFamilyOptions.setComparator(builtinComparator);
        return this;
    }

    public Options setComparator(AbstractComparator comparator) {
        this.columnFamilyOptions.setComparator(comparator);
        return this;
    }

    public Options setMergeOperatorName(String name) {
        this.columnFamilyOptions.setMergeOperatorName(name);
        return this;
    }

    public Options setMergeOperator(MergeOperator mergeOperator) {
        this.columnFamilyOptions.setMergeOperator(mergeOperator);
        return this;
    }

    public Options setWriteBufferSize(long writeBufferSize) {
        this.columnFamilyOptions.setWriteBufferSize(writeBufferSize);
        return this;
    }

    public long writeBufferSize() {
        return this.columnFamilyOptions.writeBufferSize();
    }

    public Options setMaxWriteBufferNumber(int maxWriteBufferNumber) {
        this.columnFamilyOptions.setMaxWriteBufferNumber(maxWriteBufferNumber);
        return this;
    }

    public int maxWriteBufferNumber() {
        return this.columnFamilyOptions.maxWriteBufferNumber();
    }

    public boolean errorIfExists() {
        return this.dbOptions.errorIfExists();
    }

    public Options setErrorIfExists(boolean errorIfExists) {
        this.dbOptions.setErrorIfExists(errorIfExists);
        return this;
    }

    public boolean paranoidChecks() {
        boolean dbOptionsParanoidChecks;
        boolean columnFamilyParanoidFileChecks = this.columnFamilyOptions.paranoidFileChecks();
        if (columnFamilyParanoidFileChecks != (dbOptionsParanoidChecks = this.dbOptions.paranoidChecks())) {
            throw new IllegalStateException("Config for paranoid checks for RockDB and ColumnFamilies should be the same.");
        }
        return dbOptionsParanoidChecks;
    }

    public Options setParanoidChecks(boolean paranoidChecks) {
        this.columnFamilyOptions.paranoidFileChecks();
        this.dbOptions.setParanoidChecks(paranoidChecks);
        return this;
    }

    public int maxOpenFiles() {
        return this.dbOptions.maxOpenFiles();
    }

    public Options setMaxFileOpeningThreads(int maxFileOpeningThreads) {
        this.dbOptions.setMaxFileOpeningThreads(maxFileOpeningThreads);
        return this;
    }

    public int maxFileOpeningThreads() {
        return this.dbOptions.maxFileOpeningThreads();
    }

    public Options setMaxTotalWalSize(long maxTotalWalSize) {
        this.logIgnoreWalOption("maxTotalWalSize");
        return this;
    }

    public long maxTotalWalSize() {
        return this.dbOptions.maxTotalWalSize();
    }

    public Options setMaxOpenFiles(int maxOpenFiles) {
        this.dbOptions.setMaxOpenFiles(maxOpenFiles);
        return this;
    }

    public boolean useFsync() {
        return this.dbOptions.useFsync();
    }

    public Options setUseFsync(boolean useFsync) {
        this.dbOptions.setUseFsync(useFsync);
        return this;
    }

    public Options setDbPaths(Collection<DbPath> dbPaths) {
        this.dbOptions.setDbPaths(dbPaths);
        return this;
    }

    public List<DbPath> dbPaths() {
        return this.dbOptions.dbPaths();
    }

    public String dbLogDir() {
        return this.dbOptions.dbLogDir();
    }

    public Options setDbLogDir(String dbLogDir) {
        this.dbOptions.setDbLogDir(dbLogDir);
        return this;
    }

    public String walDir() {
        return this.dbOptions.walDir();
    }

    public Options setWalDir(String walDir) {
        this.logIgnoreWalOption("walDir");
        return this;
    }

    public long deleteObsoleteFilesPeriodMicros() {
        return this.dbOptions.deleteObsoleteFilesPeriodMicros();
    }

    public Options setDeleteObsoleteFilesPeriodMicros(long micros) {
        this.dbOptions.setDeleteObsoleteFilesPeriodMicros(micros);
        return this;
    }

    public Options setStatistics(Statistics statistics) {
        this.dbOptions.setStatistics(statistics);
        return this;
    }

    public Statistics statistics() {
        return this.dbOptions.statistics();
    }

    public Options setMaxSubcompactions(int maxSubcompactions) {
        this.dbOptions.setMaxSubcompactions(maxSubcompactions);
        return this;
    }

    public int maxSubcompactions() {
        return this.dbOptions.maxSubcompactions();
    }

    public int maxBackgroundJobs() {
        return this.dbOptions.maxBackgroundJobs();
    }

    public Options setMaxBackgroundJobs(int maxBackgroundJobs) {
        this.dbOptions.setMaxBackgroundJobs(maxBackgroundJobs);
        return this;
    }

    public long maxLogFileSize() {
        return this.dbOptions.maxLogFileSize();
    }

    public Options setMaxLogFileSize(long maxLogFileSize) {
        this.dbOptions.setMaxLogFileSize(maxLogFileSize);
        return this;
    }

    public long logFileTimeToRoll() {
        return this.dbOptions.logFileTimeToRoll();
    }

    public Options setLogFileTimeToRoll(long logFileTimeToRoll) {
        this.dbOptions.setLogFileTimeToRoll(logFileTimeToRoll);
        return this;
    }

    public long keepLogFileNum() {
        return this.dbOptions.keepLogFileNum();
    }

    public Options setKeepLogFileNum(long keepLogFileNum) {
        this.dbOptions.setKeepLogFileNum(keepLogFileNum);
        return this;
    }

    public Options setRecycleLogFileNum(long recycleLogFileNum) {
        this.dbOptions.setRecycleLogFileNum(recycleLogFileNum);
        return this;
    }

    public long recycleLogFileNum() {
        return this.dbOptions.recycleLogFileNum();
    }

    public long maxManifestFileSize() {
        return this.dbOptions.maxManifestFileSize();
    }

    public Options setMaxManifestFileSize(long maxManifestFileSize) {
        this.dbOptions.setMaxManifestFileSize(maxManifestFileSize);
        return this;
    }

    public Options setMaxTableFilesSizeFIFO(long maxTableFilesSize) {
        this.columnFamilyOptions.setMaxTableFilesSizeFIFO(maxTableFilesSize);
        return this;
    }

    public long maxTableFilesSizeFIFO() {
        return this.columnFamilyOptions.maxTableFilesSizeFIFO();
    }

    public int tableCacheNumshardbits() {
        return this.dbOptions.tableCacheNumshardbits();
    }

    public Options setTableCacheNumshardbits(int tableCacheNumshardbits) {
        this.dbOptions.setTableCacheNumshardbits(tableCacheNumshardbits);
        return this;
    }

    public long walTtlSeconds() {
        return this.dbOptions.walTtlSeconds();
    }

    public Options setWalTtlSeconds(long walTtlSeconds) {
        this.logIgnoreWalOption("walTtlSeconds");
        return this;
    }

    public long walSizeLimitMB() {
        return this.dbOptions.walSizeLimitMB();
    }

    public Options setWalSizeLimitMB(long sizeLimitMB) {
        this.logIgnoreWalOption("walSizeLimitMB");
        return this;
    }

    public long manifestPreallocationSize() {
        return this.dbOptions.manifestPreallocationSize();
    }

    public Options setManifestPreallocationSize(long size) {
        this.dbOptions.setManifestPreallocationSize(size);
        return this;
    }

    public Options setUseDirectReads(boolean useDirectReads) {
        this.dbOptions.setUseDirectReads(useDirectReads);
        return this;
    }

    public boolean useDirectReads() {
        return this.dbOptions.useDirectReads();
    }

    public Options setUseDirectIoForFlushAndCompaction(boolean useDirectIoForFlushAndCompaction) {
        this.dbOptions.setUseDirectIoForFlushAndCompaction(useDirectIoForFlushAndCompaction);
        return this;
    }

    public boolean useDirectIoForFlushAndCompaction() {
        return this.dbOptions.useDirectIoForFlushAndCompaction();
    }

    public Options setAllowFAllocate(boolean allowFAllocate) {
        this.dbOptions.setAllowFAllocate(allowFAllocate);
        return this;
    }

    public boolean allowFAllocate() {
        return this.dbOptions.allowFAllocate();
    }

    public boolean allowMmapReads() {
        return this.dbOptions.allowMmapReads();
    }

    public Options setAllowMmapReads(boolean allowMmapReads) {
        this.dbOptions.setAllowMmapReads(allowMmapReads);
        return this;
    }

    public boolean allowMmapWrites() {
        return this.dbOptions.allowMmapWrites();
    }

    public Options setAllowMmapWrites(boolean allowMmapWrites) {
        this.dbOptions.setAllowMmapWrites(allowMmapWrites);
        return this;
    }

    public boolean isFdCloseOnExec() {
        return this.dbOptions.isFdCloseOnExec();
    }

    public Options setIsFdCloseOnExec(boolean isFdCloseOnExec) {
        this.dbOptions.setIsFdCloseOnExec(isFdCloseOnExec);
        return this;
    }

    public int statsDumpPeriodSec() {
        return this.dbOptions.statsDumpPeriodSec();
    }

    public Options setStatsDumpPeriodSec(int statsDumpPeriodSec) {
        this.dbOptions.setStatsDumpPeriodSec(statsDumpPeriodSec);
        return this;
    }

    public boolean adviseRandomOnOpen() {
        return this.dbOptions.adviseRandomOnOpen();
    }

    public Options setAdviseRandomOnOpen(boolean adviseRandomOnOpen) {
        this.dbOptions.setAdviseRandomOnOpen(adviseRandomOnOpen);
        return this;
    }

    public Options setDbWriteBufferSize(long dbWriteBufferSize) {
        this.dbOptions.setDbWriteBufferSize(dbWriteBufferSize);
        return this;
    }

    public long dbWriteBufferSize() {
        return this.dbOptions.dbWriteBufferSize();
    }

    public Options setCompactionReadaheadSize(long compactionReadaheadSize) {
        this.dbOptions.setCompactionReadaheadSize(compactionReadaheadSize);
        return this;
    }

    public long compactionReadaheadSize() {
        return this.dbOptions.compactionReadaheadSize();
    }

    @Deprecated(since="4.2", forRemoval=true)
    public Options setRandomAccessMaxBufferSize(long ignored) {
        log.warn("random_access_max_buffer_size has been removed in RocksDB v9.11.1. See https://github.com/facebook/rocksdb/pull/13288");
        return this;
    }

    @Deprecated(since="4.2", forRemoval=true)
    public long randomAccessMaxBufferSize() {
        log.warn("random_access_max_buffer_size has been removed in RocksDB v9.11.1. See https://github.com/facebook/rocksdb/pull/13288");
        return 0L;
    }

    public Options setWritableFileMaxBufferSize(long writableFileMaxBufferSize) {
        this.dbOptions.setWritableFileMaxBufferSize(writableFileMaxBufferSize);
        return this;
    }

    public long writableFileMaxBufferSize() {
        return this.dbOptions.writableFileMaxBufferSize();
    }

    public boolean useAdaptiveMutex() {
        return this.dbOptions.useAdaptiveMutex();
    }

    public Options setUseAdaptiveMutex(boolean useAdaptiveMutex) {
        this.dbOptions.setUseAdaptiveMutex(useAdaptiveMutex);
        return this;
    }

    public long bytesPerSync() {
        return this.dbOptions.bytesPerSync();
    }

    public Options setBytesPerSync(long bytesPerSync) {
        this.dbOptions.setBytesPerSync(bytesPerSync);
        return this;
    }

    public Options setWalBytesPerSync(long walBytesPerSync) {
        this.logIgnoreWalOption("walBytesPerSync");
        return this;
    }

    public long walBytesPerSync() {
        return this.dbOptions.walBytesPerSync();
    }

    public Options setEnableThreadTracking(boolean enableThreadTracking) {
        this.dbOptions.setEnableThreadTracking(enableThreadTracking);
        return this;
    }

    public boolean enableThreadTracking() {
        return this.dbOptions.enableThreadTracking();
    }

    public Options setDelayedWriteRate(long delayedWriteRate) {
        this.dbOptions.setDelayedWriteRate(delayedWriteRate);
        return this;
    }

    public long delayedWriteRate() {
        return this.dbOptions.delayedWriteRate();
    }

    public Options setAllowConcurrentMemtableWrite(boolean allowConcurrentMemtableWrite) {
        this.dbOptions.setAllowConcurrentMemtableWrite(allowConcurrentMemtableWrite);
        return this;
    }

    public boolean allowConcurrentMemtableWrite() {
        return this.dbOptions.allowConcurrentMemtableWrite();
    }

    public Options setEnableWriteThreadAdaptiveYield(boolean enableWriteThreadAdaptiveYield) {
        this.dbOptions.setEnableWriteThreadAdaptiveYield(enableWriteThreadAdaptiveYield);
        return this;
    }

    public boolean enableWriteThreadAdaptiveYield() {
        return this.dbOptions.enableWriteThreadAdaptiveYield();
    }

    public Options setWriteThreadMaxYieldUsec(long writeThreadMaxYieldUsec) {
        this.dbOptions.setWriteThreadMaxYieldUsec(writeThreadMaxYieldUsec);
        return this;
    }

    public long writeThreadMaxYieldUsec() {
        return this.dbOptions.writeThreadMaxYieldUsec();
    }

    public Options setWriteThreadSlowYieldUsec(long writeThreadSlowYieldUsec) {
        this.dbOptions.setWriteThreadSlowYieldUsec(writeThreadSlowYieldUsec);
        return this;
    }

    public long writeThreadSlowYieldUsec() {
        return this.dbOptions.writeThreadSlowYieldUsec();
    }

    public Options setSkipStatsUpdateOnDbOpen(boolean skipStatsUpdateOnDbOpen) {
        this.dbOptions.setSkipStatsUpdateOnDbOpen(skipStatsUpdateOnDbOpen);
        return this;
    }

    public boolean skipStatsUpdateOnDbOpen() {
        return this.dbOptions.skipStatsUpdateOnDbOpen();
    }

    public Options setWalRecoveryMode(WALRecoveryMode walRecoveryMode) {
        this.logIgnoreWalOption("walRecoveryMode");
        return this;
    }

    public WALRecoveryMode walRecoveryMode() {
        return this.dbOptions.walRecoveryMode();
    }

    public Options setAllow2pc(boolean allow2pc) {
        this.dbOptions.setAllow2pc(allow2pc);
        return this;
    }

    public boolean allow2pc() {
        return this.dbOptions.allow2pc();
    }

    public Options setRowCache(Cache rowCache) {
        this.dbOptions.setRowCache(rowCache);
        return this;
    }

    public Cache rowCache() {
        return this.dbOptions.rowCache();
    }

    public Options setFailIfOptionsFileError(boolean failIfOptionsFileError) {
        this.dbOptions.setFailIfOptionsFileError(failIfOptionsFileError);
        return this;
    }

    public boolean failIfOptionsFileError() {
        return this.dbOptions.failIfOptionsFileError();
    }

    public Options setDumpMallocStats(boolean dumpMallocStats) {
        this.dbOptions.setDumpMallocStats(dumpMallocStats);
        return this;
    }

    public boolean dumpMallocStats() {
        return this.dbOptions.dumpMallocStats();
    }

    public Options setAvoidFlushDuringRecovery(boolean avoidFlushDuringRecovery) {
        this.dbOptions.setAvoidFlushDuringRecovery(avoidFlushDuringRecovery);
        return this;
    }

    public boolean avoidFlushDuringRecovery() {
        return this.dbOptions.avoidFlushDuringRecovery();
    }

    public Options setAvoidFlushDuringShutdown(boolean avoidFlushDuringShutdown) {
        this.dbOptions.setAvoidFlushDuringShutdown(avoidFlushDuringShutdown);
        return this;
    }

    public boolean avoidFlushDuringShutdown() {
        return this.dbOptions.avoidFlushDuringShutdown();
    }

    public MemTableConfig memTableConfig() {
        return this.columnFamilyOptions.memTableConfig();
    }

    public Options setMemTableConfig(MemTableConfig config) {
        this.columnFamilyOptions.setMemTableConfig(config);
        return this;
    }

    @Deprecated(since="4.2", forRemoval=true)
    public Options setRateLimiter(RateLimiter rateLimiter) {
        log.warn("rate_limiter has been deprecated in RocksDB v7.6.0. See https://github.com/facebook/rocksdb/pull/10378");
        this.dbOptions.setRateLimiter(rateLimiter);
        return this;
    }

    public Options setSstFileManager(SstFileManager sstFileManager) {
        this.dbOptions.setSstFileManager(sstFileManager);
        return this;
    }

    public Options setLogger(LoggerInterface logger) {
        this.dbOptions.setLogger(logger);
        return this;
    }

    public Options setInfoLogLevel(InfoLogLevel infoLogLevel) {
        this.dbOptions.setInfoLogLevel(infoLogLevel);
        return this;
    }

    public InfoLogLevel infoLogLevel() {
        return this.dbOptions.infoLogLevel();
    }

    public String memTableFactoryName() {
        return this.columnFamilyOptions.memTableFactoryName();
    }

    public TableFormatConfig tableFormatConfig() {
        return this.columnFamilyOptions.tableFormatConfig();
    }

    public Options setTableFormatConfig(TableFormatConfig config) {
        this.columnFamilyOptions.setTableFormatConfig(config);
        return this;
    }

    public String tableFactoryName() {
        return this.columnFamilyOptions.tableFactoryName();
    }

    public Options useFixedLengthPrefixExtractor(int n) {
        this.columnFamilyOptions.useFixedLengthPrefixExtractor(n);
        return this;
    }

    public Options useCappedPrefixExtractor(int n) {
        this.columnFamilyOptions.useCappedPrefixExtractor(n);
        return this;
    }

    public CompressionType compressionType() {
        return this.columnFamilyOptions.compressionType();
    }

    public Options setCompressionPerLevel(List<CompressionType> compressionLevels) {
        this.columnFamilyOptions.setCompressionPerLevel(compressionLevels);
        return this;
    }

    public List<CompressionType> compressionPerLevel() {
        return this.columnFamilyOptions.compressionPerLevel();
    }

    public Options setCompressionType(CompressionType compressionType) {
        this.columnFamilyOptions.setCompressionType(compressionType);
        return this;
    }

    public Options setMemtableMaxRangeDeletions(int n) {
        this.columnFamilyOptions.setMemtableMaxRangeDeletions(n);
        return this;
    }

    public int memtableMaxRangeDeletions() {
        return this.columnFamilyOptions.memtableMaxRangeDeletions();
    }

    public Options setBottommostCompressionType(CompressionType bottommostCompressionType) {
        this.columnFamilyOptions.setBottommostCompressionType(bottommostCompressionType);
        return this;
    }

    public CompressionType bottommostCompressionType() {
        return this.columnFamilyOptions.bottommostCompressionType();
    }

    public Options setCompressionOptions(CompressionOptions compressionOptions) {
        this.columnFamilyOptions.setCompressionOptions(compressionOptions);
        return this;
    }

    public CompressionOptions compressionOptions() {
        return this.columnFamilyOptions.compressionOptions();
    }

    public CompactionStyle compactionStyle() {
        return this.columnFamilyOptions.compactionStyle();
    }

    public Options setCompactionStyle(CompactionStyle compactionStyle) {
        this.columnFamilyOptions.setCompactionStyle(compactionStyle);
        return this;
    }

    public int numLevels() {
        return this.columnFamilyOptions.numLevels();
    }

    public Options setNumLevels(int numLevels) {
        this.columnFamilyOptions.setNumLevels(numLevels);
        return this;
    }

    public int levelZeroFileNumCompactionTrigger() {
        return this.columnFamilyOptions.levelZeroFileNumCompactionTrigger();
    }

    public Options setLevelZeroFileNumCompactionTrigger(int numFiles) {
        this.columnFamilyOptions.setLevelZeroFileNumCompactionTrigger(numFiles);
        return this;
    }

    public int levelZeroSlowdownWritesTrigger() {
        return this.columnFamilyOptions.levelZeroSlowdownWritesTrigger();
    }

    public Options setLevelZeroSlowdownWritesTrigger(int numFiles) {
        this.columnFamilyOptions.setLevelZeroSlowdownWritesTrigger(numFiles);
        return this;
    }

    public int levelZeroStopWritesTrigger() {
        return this.columnFamilyOptions.levelZeroStopWritesTrigger();
    }

    public Options setLevelZeroStopWritesTrigger(int numFiles) {
        this.columnFamilyOptions.setLevelZeroStopWritesTrigger(numFiles);
        return this;
    }

    public long targetFileSizeBase() {
        return this.columnFamilyOptions.targetFileSizeBase();
    }

    public Options setTargetFileSizeBase(long targetFileSizeBase) {
        this.columnFamilyOptions.setTargetFileSizeBase(targetFileSizeBase);
        return this;
    }

    public int targetFileSizeMultiplier() {
        return this.columnFamilyOptions.targetFileSizeMultiplier();
    }

    public Options setTargetFileSizeMultiplier(int multiplier) {
        this.columnFamilyOptions.setTargetFileSizeMultiplier(multiplier);
        return this;
    }

    public Options setMaxBytesForLevelBase(long maxBytesForLevelBase) {
        this.columnFamilyOptions.setMaxBytesForLevelBase(maxBytesForLevelBase);
        return this;
    }

    public long maxBytesForLevelBase() {
        return this.columnFamilyOptions.maxBytesForLevelBase();
    }

    public Options setLevelCompactionDynamicLevelBytes(boolean enableLevelCompactionDynamicLevelBytes) {
        this.columnFamilyOptions.setLevelCompactionDynamicLevelBytes(enableLevelCompactionDynamicLevelBytes);
        return this;
    }

    public boolean levelCompactionDynamicLevelBytes() {
        return this.columnFamilyOptions.levelCompactionDynamicLevelBytes();
    }

    public double maxBytesForLevelMultiplier() {
        return this.columnFamilyOptions.maxBytesForLevelMultiplier();
    }

    public Options setMaxBytesForLevelMultiplier(double multiplier) {
        this.columnFamilyOptions.setMaxBytesForLevelMultiplier(multiplier);
        return this;
    }

    public long maxCompactionBytes() {
        return this.columnFamilyOptions.maxCompactionBytes();
    }

    public Options setMaxCompactionBytes(long maxCompactionBytes) {
        this.columnFamilyOptions.setMaxCompactionBytes(maxCompactionBytes);
        return this;
    }

    public long arenaBlockSize() {
        return this.columnFamilyOptions.arenaBlockSize();
    }

    public Options setArenaBlockSize(long arenaBlockSize) {
        this.columnFamilyOptions.setArenaBlockSize(arenaBlockSize);
        return this;
    }

    public boolean disableAutoCompactions() {
        return this.columnFamilyOptions.disableAutoCompactions();
    }

    public Options setDisableAutoCompactions(boolean disableAutoCompactions) {
        this.columnFamilyOptions.setDisableAutoCompactions(disableAutoCompactions);
        return this;
    }

    public long maxSequentialSkipInIterations() {
        return this.columnFamilyOptions.maxSequentialSkipInIterations();
    }

    public Options setMaxSequentialSkipInIterations(long maxSequentialSkipInIterations) {
        this.columnFamilyOptions.setMaxSequentialSkipInIterations(maxSequentialSkipInIterations);
        return this;
    }

    public boolean inplaceUpdateSupport() {
        return this.columnFamilyOptions.inplaceUpdateSupport();
    }

    public Options setInplaceUpdateSupport(boolean inplaceUpdateSupport) {
        this.columnFamilyOptions.setInplaceUpdateSupport(inplaceUpdateSupport);
        return this;
    }

    public long inplaceUpdateNumLocks() {
        return this.columnFamilyOptions.inplaceUpdateNumLocks();
    }

    public Options setInplaceUpdateNumLocks(long inplaceUpdateNumLocks) {
        this.columnFamilyOptions.setInplaceUpdateNumLocks(inplaceUpdateNumLocks);
        return this;
    }

    public double memtablePrefixBloomSizeRatio() {
        return this.columnFamilyOptions.memtablePrefixBloomSizeRatio();
    }

    public Options setMemtablePrefixBloomSizeRatio(double memtablePrefixBloomSizeRatio) {
        this.columnFamilyOptions.setMemtablePrefixBloomSizeRatio(memtablePrefixBloomSizeRatio);
        return this;
    }

    public int bloomLocality() {
        return this.columnFamilyOptions.bloomLocality();
    }

    public Options setBloomLocality(int bloomLocality) {
        this.columnFamilyOptions.setBloomLocality(bloomLocality);
        return this;
    }

    public long maxSuccessiveMerges() {
        return this.columnFamilyOptions.maxSuccessiveMerges();
    }

    public Options setMaxSuccessiveMerges(long maxSuccessiveMerges) {
        this.columnFamilyOptions.setMaxSuccessiveMerges(maxSuccessiveMerges);
        return this;
    }

    public int minWriteBufferNumberToMerge() {
        return this.columnFamilyOptions.minWriteBufferNumberToMerge();
    }

    public Options setMinWriteBufferNumberToMerge(int minWriteBufferNumberToMerge) {
        this.columnFamilyOptions.setMinWriteBufferNumberToMerge(minWriteBufferNumberToMerge);
        return this;
    }

    public Options setOptimizeFiltersForHits(boolean optimizeFiltersForHits) {
        this.columnFamilyOptions.setOptimizeFiltersForHits(optimizeFiltersForHits);
        return this;
    }

    public boolean optimizeFiltersForHits() {
        return this.columnFamilyOptions.optimizeFiltersForHits();
    }

    public Options setMemtableHugePageSize(long memtableHugePageSize) {
        this.columnFamilyOptions.setMemtableHugePageSize(memtableHugePageSize);
        return this;
    }

    public long memtableHugePageSize() {
        return this.columnFamilyOptions.memtableHugePageSize();
    }

    public Options setSoftPendingCompactionBytesLimit(long softPendingCompactionBytesLimit) {
        this.columnFamilyOptions.setSoftPendingCompactionBytesLimit(softPendingCompactionBytesLimit);
        return this;
    }

    public long softPendingCompactionBytesLimit() {
        return this.columnFamilyOptions.softPendingCompactionBytesLimit();
    }

    public Options setHardPendingCompactionBytesLimit(long hardPendingCompactionBytesLimit) {
        this.columnFamilyOptions.setHardPendingCompactionBytesLimit(hardPendingCompactionBytesLimit);
        return this;
    }

    public long hardPendingCompactionBytesLimit() {
        return this.columnFamilyOptions.hardPendingCompactionBytesLimit();
    }

    public Options setLevel0FileNumCompactionTrigger(int level0FileNumCompactionTrigger) {
        this.columnFamilyOptions.setLevel0FileNumCompactionTrigger(level0FileNumCompactionTrigger);
        return this;
    }

    public int level0FileNumCompactionTrigger() {
        return this.columnFamilyOptions.level0FileNumCompactionTrigger();
    }

    public Options setLevel0SlowdownWritesTrigger(int level0SlowdownWritesTrigger) {
        this.columnFamilyOptions.setLevel0SlowdownWritesTrigger(level0SlowdownWritesTrigger);
        return this;
    }

    public int level0SlowdownWritesTrigger() {
        return this.columnFamilyOptions.level0SlowdownWritesTrigger();
    }

    public Options setLevel0StopWritesTrigger(int level0StopWritesTrigger) {
        this.columnFamilyOptions.setLevel0StopWritesTrigger(level0StopWritesTrigger);
        return this;
    }

    public int level0StopWritesTrigger() {
        return this.columnFamilyOptions.level0StopWritesTrigger();
    }

    public Options setMaxBytesForLevelMultiplierAdditional(int[] maxBytesForLevelMultiplierAdditional) {
        this.columnFamilyOptions.setMaxBytesForLevelMultiplierAdditional(maxBytesForLevelMultiplierAdditional);
        return this;
    }

    public int[] maxBytesForLevelMultiplierAdditional() {
        return this.columnFamilyOptions.maxBytesForLevelMultiplierAdditional();
    }

    public Options setParanoidFileChecks(boolean paranoidFileChecks) {
        this.columnFamilyOptions.setParanoidFileChecks(paranoidFileChecks);
        return this;
    }

    public boolean paranoidFileChecks() {
        return this.columnFamilyOptions.paranoidFileChecks();
    }

    public Options setMaxWriteBufferNumberToMaintain(int maxWriteBufferNumberToMaintain) {
        this.columnFamilyOptions.setMaxWriteBufferNumberToMaintain(maxWriteBufferNumberToMaintain);
        return this;
    }

    public int maxWriteBufferNumberToMaintain() {
        return this.columnFamilyOptions.maxWriteBufferNumberToMaintain();
    }

    public Options setCompactionPriority(CompactionPriority compactionPriority) {
        this.columnFamilyOptions.setCompactionPriority(compactionPriority);
        return this;
    }

    public CompactionPriority compactionPriority() {
        return this.columnFamilyOptions.compactionPriority();
    }

    public Options setReportBgIoStats(boolean reportBgIoStats) {
        this.columnFamilyOptions.setReportBgIoStats(reportBgIoStats);
        return this;
    }

    public boolean reportBgIoStats() {
        return this.columnFamilyOptions.reportBgIoStats();
    }

    public Options setCompactionOptionsUniversal(CompactionOptionsUniversal compactionOptionsUniversal) {
        this.columnFamilyOptions.setCompactionOptionsUniversal(compactionOptionsUniversal);
        return this;
    }

    public CompactionOptionsUniversal compactionOptionsUniversal() {
        return this.columnFamilyOptions.compactionOptionsUniversal();
    }

    public Options setCompactionOptionsFIFO(CompactionOptionsFIFO compactionOptionsFIFO) {
        this.columnFamilyOptions.setCompactionOptionsFIFO(compactionOptionsFIFO);
        return this;
    }

    public CompactionOptionsFIFO compactionOptionsFIFO() {
        return this.columnFamilyOptions.compactionOptionsFIFO();
    }

    public Options setForceConsistencyChecks(boolean forceConsistencyChecks) {
        this.columnFamilyOptions.setForceConsistencyChecks(forceConsistencyChecks);
        return this;
    }

    public boolean forceConsistencyChecks() {
        return this.columnFamilyOptions.forceConsistencyChecks();
    }

    public Options setWriteBufferManager(WriteBufferManager writeBufferManager) {
        this.dbOptions.setWriteBufferManager(writeBufferManager);
        return this;
    }

    public WriteBufferManager writeBufferManager() {
        return this.dbOptions.writeBufferManager();
    }

    public Options setMaxWriteBatchGroupSizeBytes(long maxWriteBatchGroupSizeBytes) {
        this.dbOptions.setMaxWriteBatchGroupSizeBytes(maxWriteBatchGroupSizeBytes);
        return this;
    }

    public long maxWriteBatchGroupSizeBytes() {
        return this.dbOptions.maxWriteBatchGroupSizeBytes();
    }

    public Options oldDefaults(int majorVersion, int minorVersion) {
        this.columnFamilyOptions.oldDefaults(majorVersion, minorVersion);
        return this;
    }

    public Options optimizeForSmallDb(Cache cache) {
        return super.optimizeForSmallDb(cache);
    }

    public AbstractCompactionFilter<? extends AbstractSlice<?>> compactionFilter() {
        return this.columnFamilyOptions.compactionFilter();
    }

    public AbstractCompactionFilterFactory<? extends AbstractCompactionFilter<?>> compactionFilterFactory() {
        return this.columnFamilyOptions.compactionFilterFactory();
    }

    public Options setStatsPersistPeriodSec(int statsPersistPeriodSec) {
        this.dbOptions.setStatsPersistPeriodSec(statsPersistPeriodSec);
        return this;
    }

    public int statsPersistPeriodSec() {
        return this.dbOptions.statsPersistPeriodSec();
    }

    public Options setStatsHistoryBufferSize(long statsHistoryBufferSize) {
        this.dbOptions.setStatsHistoryBufferSize(statsHistoryBufferSize);
        return this;
    }

    public long statsHistoryBufferSize() {
        return this.dbOptions.statsHistoryBufferSize();
    }

    public Options setStrictBytesPerSync(boolean strictBytesPerSync) {
        this.dbOptions.setStrictBytesPerSync(strictBytesPerSync);
        return this;
    }

    public boolean strictBytesPerSync() {
        return this.dbOptions.strictBytesPerSync();
    }

    public Options setListeners(List<AbstractEventListener> listeners) {
        this.dbOptions.setListeners(listeners);
        return this;
    }

    public List<AbstractEventListener> listeners() {
        return this.dbOptions.listeners();
    }

    public Options setEnablePipelinedWrite(boolean enablePipelinedWrite) {
        this.dbOptions.setEnablePipelinedWrite(enablePipelinedWrite);
        return this;
    }

    public boolean enablePipelinedWrite() {
        return this.dbOptions.enablePipelinedWrite();
    }

    public Options setUnorderedWrite(boolean unorderedWrite) {
        this.dbOptions.setUnorderedWrite(unorderedWrite);
        return this;
    }

    public boolean unorderedWrite() {
        return this.dbOptions.unorderedWrite();
    }

    public Options setSkipCheckingSstFileSizesOnDbOpen(boolean skipCheckingSstFileSizesOnDbOpen) {
        this.dbOptions.setSkipCheckingSstFileSizesOnDbOpen(skipCheckingSstFileSizesOnDbOpen);
        return this;
    }

    public boolean skipCheckingSstFileSizesOnDbOpen() {
        return this.dbOptions.skipCheckingSstFileSizesOnDbOpen();
    }

    public Options setWalFilter(AbstractWalFilter walFilter) {
        this.logIgnoreWalOption("walFilter");
        return this;
    }

    public WalFilter walFilter() {
        return this.dbOptions.walFilter();
    }

    public Options setAllowIngestBehind(boolean allowIngestBehind) {
        this.dbOptions.setAllowIngestBehind(allowIngestBehind);
        return this;
    }

    public boolean allowIngestBehind() {
        return this.dbOptions.allowIngestBehind();
    }

    public Options setTwoWriteQueues(boolean twoWriteQueues) {
        this.dbOptions.setTwoWriteQueues(twoWriteQueues);
        return this;
    }

    public boolean twoWriteQueues() {
        return this.dbOptions.twoWriteQueues();
    }

    public Options setManualWalFlush(boolean manualWalFlush) {
        this.logIgnoreWalOption("manualWalFlush");
        return this;
    }

    public boolean manualWalFlush() {
        return this.dbOptions.manualWalFlush();
    }

    public Options setCfPaths(Collection<DbPath> cfPaths) {
        this.columnFamilyOptions.setCfPaths(cfPaths);
        return this;
    }

    public List<DbPath> cfPaths() {
        return this.columnFamilyOptions.cfPaths();
    }

    public Options setBottommostCompressionOptions(CompressionOptions bottommostCompressionOptions) {
        this.columnFamilyOptions.setBottommostCompressionOptions(bottommostCompressionOptions);
        return this;
    }

    public CompressionOptions bottommostCompressionOptions() {
        return this.columnFamilyOptions.bottommostCompressionOptions();
    }

    public Options setTtl(long ttl) {
        this.columnFamilyOptions.setTtl(ttl);
        return this;
    }

    public long ttl() {
        return this.columnFamilyOptions.ttl();
    }

    public Options setPeriodicCompactionSeconds(long periodicCompactionSeconds) {
        this.columnFamilyOptions.setPeriodicCompactionSeconds(periodicCompactionSeconds);
        return this;
    }

    public long periodicCompactionSeconds() {
        return this.columnFamilyOptions.periodicCompactionSeconds();
    }

    public Options setAtomicFlush(boolean atomicFlush) {
        this.dbOptions.setAtomicFlush(atomicFlush);
        return this;
    }

    public boolean atomicFlush() {
        return this.dbOptions.atomicFlush();
    }

    public Options setAvoidUnnecessaryBlockingIO(boolean avoidUnnecessaryBlockingIO) {
        this.dbOptions.setAvoidUnnecessaryBlockingIO(avoidUnnecessaryBlockingIO);
        return this;
    }

    public boolean avoidUnnecessaryBlockingIO() {
        return this.dbOptions.avoidUnnecessaryBlockingIO();
    }

    public Options setPersistStatsToDisk(boolean persistStatsToDisk) {
        this.dbOptions.setPersistStatsToDisk(persistStatsToDisk);
        return this;
    }

    public boolean persistStatsToDisk() {
        return this.dbOptions.persistStatsToDisk();
    }

    public Options setWriteDbidToManifest(boolean writeDbidToManifest) {
        this.dbOptions.setWriteDbidToManifest(writeDbidToManifest);
        return this;
    }

    public boolean writeDbidToManifest() {
        return this.dbOptions.writeDbidToManifest();
    }

    public Options setLogReadaheadSize(long logReadaheadSize) {
        this.dbOptions.setLogReadaheadSize(logReadaheadSize);
        return this;
    }

    public long logReadaheadSize() {
        return this.dbOptions.logReadaheadSize();
    }

    public Options setBestEffortsRecovery(boolean bestEffortsRecovery) {
        this.dbOptions.setBestEffortsRecovery(bestEffortsRecovery);
        return this;
    }

    public boolean bestEffortsRecovery() {
        return this.dbOptions.bestEffortsRecovery();
    }

    public Options setMaxBgErrorResumeCount(int maxBgerrorResumeCount) {
        this.dbOptions.setMaxBgErrorResumeCount(maxBgerrorResumeCount);
        return this;
    }

    public int maxBgerrorResumeCount() {
        return this.dbOptions.maxBgerrorResumeCount();
    }

    public Options setBgerrorResumeRetryInterval(long bgerrorResumeRetryInterval) {
        this.dbOptions.setBgerrorResumeRetryInterval(bgerrorResumeRetryInterval);
        return this;
    }

    public long bgerrorResumeRetryInterval() {
        return this.dbOptions.bgerrorResumeRetryInterval();
    }

    public Options setSstPartitionerFactory(SstPartitionerFactory sstPartitionerFactory) {
        this.columnFamilyOptions.setSstPartitionerFactory(sstPartitionerFactory);
        return this;
    }

    public SstPartitionerFactory sstPartitionerFactory() {
        return this.columnFamilyOptions.sstPartitionerFactory();
    }

    public Options setCompactionThreadLimiter(ConcurrentTaskLimiter compactionThreadLimiter) {
        this.columnFamilyOptions.setCompactionThreadLimiter(compactionThreadLimiter);
        return this;
    }

    public ConcurrentTaskLimiter compactionThreadLimiter() {
        return this.columnFamilyOptions.compactionThreadLimiter();
    }

    public Options setCompactionFilter(AbstractCompactionFilter<? extends AbstractSlice<?>> compactionFilter) {
        this.columnFamilyOptions.setCompactionFilter(compactionFilter);
        return this;
    }

    public Options setCompactionFilterFactory(AbstractCompactionFilterFactory<? extends AbstractCompactionFilter<?>> compactionFilterFactory) {
        this.columnFamilyOptions.setCompactionFilterFactory(compactionFilterFactory);
        return this;
    }

    public Options setBlobCompactionReadaheadSize(long blobCompactionReadaheadSize) {
        this.columnFamilyOptions.setBlobCompactionReadaheadSize(blobCompactionReadaheadSize);
        return this;
    }

    public long blobCompactionReadaheadSize() {
        return this.columnFamilyOptions.blobCompactionReadaheadSize();
    }

    public Options setMemtableWholeKeyFiltering(boolean memtableWholeKeyFiltering) {
        this.columnFamilyOptions.setMemtableWholeKeyFiltering(memtableWholeKeyFiltering);
        return this;
    }

    public boolean memtableWholeKeyFiltering() {
        return this.columnFamilyOptions.memtableWholeKeyFiltering();
    }

    public Options setExperimentalMempurgeThreshold(double experimentalMempurgeThreshold) {
        this.columnFamilyOptions.setExperimentalMempurgeThreshold(experimentalMempurgeThreshold);
        return this;
    }

    public double experimentalMempurgeThreshold() {
        return this.columnFamilyOptions.experimentalMempurgeThreshold();
    }

    public Options setEnableBlobFiles(boolean enableBlobFiles) {
        this.columnFamilyOptions.setEnableBlobFiles(enableBlobFiles);
        return this;
    }

    public boolean enableBlobFiles() {
        return this.columnFamilyOptions.enableBlobFiles();
    }

    public Options setMinBlobSize(long minBlobSize) {
        this.columnFamilyOptions.setMinBlobSize(minBlobSize);
        return this;
    }

    public long minBlobSize() {
        return this.columnFamilyOptions.minBlobSize();
    }

    public Options setBlobFileSize(long blobFileSize) {
        this.columnFamilyOptions.setBlobFileSize(blobFileSize);
        return this;
    }

    public long blobFileSize() {
        return this.columnFamilyOptions.blobFileSize();
    }

    public Options setBlobCompressionType(CompressionType compressionType) {
        this.columnFamilyOptions.setBlobCompressionType(compressionType);
        return this;
    }

    public CompressionType blobCompressionType() {
        return this.columnFamilyOptions.blobCompressionType();
    }

    public Options setEnableBlobGarbageCollection(boolean enableBlobGarbageCollection) {
        this.columnFamilyOptions.setEnableBlobGarbageCollection(enableBlobGarbageCollection);
        return this;
    }

    public boolean enableBlobGarbageCollection() {
        return this.columnFamilyOptions.enableBlobGarbageCollection();
    }

    public Options setBlobGarbageCollectionAgeCutoff(double blobGarbageCollectionAgeCutoff) {
        this.columnFamilyOptions.setBlobGarbageCollectionAgeCutoff(blobGarbageCollectionAgeCutoff);
        return this;
    }

    public double blobGarbageCollectionAgeCutoff() {
        return this.columnFamilyOptions.blobGarbageCollectionAgeCutoff();
    }

    public Options setBlobGarbageCollectionForceThreshold(double blobGarbageCollectionForceThreshold) {
        this.columnFamilyOptions.setBlobGarbageCollectionForceThreshold(blobGarbageCollectionForceThreshold);
        return this;
    }

    public double blobGarbageCollectionForceThreshold() {
        return this.columnFamilyOptions.blobGarbageCollectionForceThreshold();
    }

    public Options setPrepopulateBlobCache(PrepopulateBlobCache prepopulateBlobCache) {
        this.columnFamilyOptions.setPrepopulateBlobCache(prepopulateBlobCache);
        return this;
    }

    public PrepopulateBlobCache prepopulateBlobCache() {
        return this.columnFamilyOptions.prepopulateBlobCache();
    }

    public Options setBlobFileStartingLevel(int blobFileStartingLevel) {
        this.columnFamilyOptions.setBlobFileStartingLevel(blobFileStartingLevel);
        return this;
    }

    public int blobFileStartingLevel() {
        return this.columnFamilyOptions.blobFileStartingLevel();
    }

    public Options setDailyOffpeakTimeUTC(String offpeakTimeUTC) {
        this.dbOptions.setDailyOffpeakTimeUTC(offpeakTimeUTC);
        return this;
    }

    public String dailyOffpeakTimeUTC() {
        return this.dbOptions.dailyOffpeakTimeUTC();
    }

    public void close() {
        this.dbOptions.close();
        this.columnFamilyOptions.close();
        super.close();
    }

    private void logIgnoreWalOption(String option) {
        log.warn("WAL is explicitly disabled by Streams in RocksDB. Setting option '{}' will be ignored", (Object)option);
    }
}

