/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.image.node.ClientQuotaImageNode;
import org.apache.kafka.image.writer.ImageWriter;

public record ClientQuotaImage(Map<String, Double> quotas) {
    public static final ClientQuotaImage EMPTY = new ClientQuotaImage(Map.of());

    public ClientQuotaImage {
        quotas = Collections.unmodifiableMap(quotas);
    }

    public void write(ClientQuotaEntity entity, ImageWriter writer) {
        for (Map.Entry<String, Double> entry : this.quotas.entrySet()) {
            writer.write(0, new ClientQuotaRecord().setEntity(ClientQuotaImage.entityToData(entity)).setKey(entry.getKey()).setValue(entry.getValue()).setRemove(false));
        }
    }

    public static List<ClientQuotaRecord.EntityData> entityToData(ClientQuotaEntity entity) {
        ArrayList<ClientQuotaRecord.EntityData> entityData = new ArrayList<ClientQuotaRecord.EntityData>(entity.entries().size());
        for (Map.Entry entry : entity.entries().entrySet()) {
            entityData.add(new ClientQuotaRecord.EntityData().setEntityType((String)entry.getKey()).setEntityName((String)entry.getValue()));
        }
        return entityData;
    }

    public static ClientQuotaEntity dataToEntity(List<ClientQuotaRecord.EntityData> entityData) {
        HashMap<String, String> entries = new HashMap<String, String>();
        for (ClientQuotaRecord.EntityData data : entityData) {
            entries.put(data.entityType(), data.entityName());
        }
        return new ClientQuotaEntity(Collections.unmodifiableMap(entries));
    }

    public List<DescribeClientQuotasResponseData.ValueData> toDescribeValues() {
        ArrayList<DescribeClientQuotasResponseData.ValueData> values = new ArrayList<DescribeClientQuotasResponseData.ValueData>(this.quotas.size());
        for (Map.Entry<String, Double> entry : this.quotas.entrySet()) {
            values.add(new DescribeClientQuotasResponseData.ValueData().setKey(entry.getKey()).setValue(entry.getValue().doubleValue()));
        }
        return values;
    }

    public boolean isEmpty() {
        return this.quotas.isEmpty();
    }

    @Override
    public String toString() {
        return new ClientQuotaImageNode(this).stringify();
    }
}

