/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.document.SuggestScoreDocPriorityQueue;
import org.apache.lucene.search.suggest.document.TopSuggestDocs;

public class TopSuggestDocsCollector
extends SimpleCollector {
    private final SuggestScoreDocPriorityQueue priorityQueue;
    private final int num;
    private final List<TopSuggestDocs.SuggestScoreDoc> pendingResults;
    final CharArraySet seenSurfaceForms;
    protected int docBase;

    public TopSuggestDocsCollector(int num, boolean skipDuplicates) {
        if (num <= 0) {
            throw new IllegalArgumentException("'num' must be > 0");
        }
        this.num = num;
        this.priorityQueue = new SuggestScoreDocPriorityQueue(num);
        if (skipDuplicates) {
            this.seenSurfaceForms = new CharArraySet(num, false);
            this.pendingResults = new ArrayList<TopSuggestDocs.SuggestScoreDoc>();
        } else {
            this.seenSurfaceForms = null;
            this.pendingResults = null;
        }
    }

    protected boolean doSkipDuplicates() {
        return this.seenSurfaceForms != null;
    }

    public int getCountToCollect() {
        return this.num;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docBase = context.docBase;
    }

    public void finish() throws IOException {
        if (this.seenSurfaceForms != null) {
            Collections.addAll(this.pendingResults, this.priorityQueue.getResults());
            this.seenSurfaceForms.clear();
        }
    }

    public void collect(int docID, CharSequence key, CharSequence context, float score) throws IOException {
        TopSuggestDocs.SuggestScoreDoc current = new TopSuggestDocs.SuggestScoreDoc(this.docBase + docID, key, context, score);
        if (current == this.priorityQueue.insertWithOverflow(current)) {
            throw new CollectionTerminatedException();
        }
    }

    public TopSuggestDocs get() throws IOException {
        TopSuggestDocs.SuggestScoreDoc[] suggestScoreDocs;
        if (this.seenSurfaceForms != null) {
            assert (this.seenSurfaceForms.isEmpty());
            this.pendingResults.sort((a, b) -> {
                int cmp = Float.compare(b.score, a.score);
                if (cmp == 0 && (cmp = Lookup.CHARSEQUENCE_COMPARATOR.compare(a.key, b.key)) == 0) {
                    cmp = Integer.compare(a.doc, b.doc);
                }
                return cmp;
            });
            ArrayList<TopSuggestDocs.SuggestScoreDoc> hits = new ArrayList<TopSuggestDocs.SuggestScoreDoc>();
            for (TopSuggestDocs.SuggestScoreDoc hit : this.pendingResults) {
                if (this.seenSurfaceForms.contains(hit.key)) continue;
                this.seenSurfaceForms.add(hit.key);
                hits.add(hit);
                if (hits.size() != this.num) continue;
                break;
            }
            suggestScoreDocs = hits.toArray(new TopSuggestDocs.SuggestScoreDoc[0]);
        } else {
            suggestScoreDocs = this.priorityQueue.getResults();
        }
        if (suggestScoreDocs.length > 0) {
            return new TopSuggestDocs(new TotalHits((long)suggestScoreDocs.length, TotalHits.Relation.EQUAL_TO), suggestScoreDocs);
        }
        return TopSuggestDocs.EMPTY;
    }

    public void collect(int doc) throws IOException {
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE;
    }
}

