/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.SignatureSubpacketInputStream;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.io.Streams;

public class SignaturePacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    public static final int VERSION_5 = 5;
    public static final int VERSION_6 = 6;
    private int version;
    private int signatureType;
    private long creationTime;
    private long keyID;
    private int keyAlgorithm;
    private int hashAlgorithm;
    private MPInteger[] signature;
    private byte[] fingerPrint;
    private SignatureSubpacket[] hashedData;
    private SignatureSubpacket[] unhashedData;
    private byte[] signatureEncoding;
    private byte[] salt;

    SignaturePacket(BCPGInputStream in) throws IOException {
        this(in, false);
    }

    SignaturePacket(BCPGInputStream in, boolean newPacketFormat) throws IOException {
        super(2, newPacketFormat);
        this.version = in.read();
        switch (this.version) {
            case 2: 
            case 3: {
                this.parseV2_V3(in);
                break;
            }
            case 4: 
            case 5: {
                this.parseV4_V5(in);
                break;
            }
            case 6: {
                this.parseV6(in);
                break;
            }
            default: {
                Streams.drain((InputStream)in);
                throw new UnsupportedPacketVersionException("unsupported version: " + this.version);
            }
        }
    }

    private void parseV2_V3(BCPGInputStream in) throws IOException {
        int l = in.read();
        this.signatureType = in.read();
        this.creationTime = StreamUtil.readTime(in);
        this.keyID = StreamUtil.readKeyID(in);
        this.keyAlgorithm = in.read();
        this.hashAlgorithm = in.read();
        this.fingerPrint = new byte[2];
        in.readFully(this.fingerPrint);
        this.parseSignature(in);
    }

    private void parseV4_V5(BCPGInputStream in) throws IOException {
        this.signatureType = in.read();
        this.keyAlgorithm = in.read();
        this.hashAlgorithm = in.read();
        this.parseSubpackets(in);
        this.fingerPrint = new byte[2];
        in.readFully(this.fingerPrint);
        this.parseSignature(in);
    }

    private void parseV6(BCPGInputStream in) throws IOException {
        this.signatureType = in.read();
        this.keyAlgorithm = in.read();
        this.hashAlgorithm = in.read();
        this.parseSubpackets(in);
        this.fingerPrint = new byte[2];
        in.readFully(this.fingerPrint);
        int saltSize = in.read();
        this.salt = new byte[saltSize];
        in.readFully(this.salt);
        this.parseSignature(in);
    }

    private void parseSubpackets(BCPGInputStream in) throws IOException {
        SignatureSubpacket p;
        int i;
        Vector<SignatureSubpacket> vec = this.readSignatureSubpacketVector(in);
        this.hashedData = new SignatureSubpacket[vec.size()];
        for (i = 0; i != this.hashedData.length; ++i) {
            p = vec.elementAt(i);
            if (p instanceof IssuerKeyID) {
                this.keyID = ((IssuerKeyID)p).getKeyID();
            } else if (p instanceof SignatureCreationTime) {
                this.creationTime = ((SignatureCreationTime)p).getTime().getTime();
            }
            this.hashedData[i] = p;
        }
        vec = this.readSignatureSubpacketVector(in);
        this.unhashedData = new SignatureSubpacket[vec.size()];
        for (i = 0; i != this.unhashedData.length; ++i) {
            p = vec.elementAt(i);
            if (p instanceof IssuerKeyID) {
                this.keyID = ((IssuerKeyID)p).getKeyID();
            }
            this.unhashedData[i] = p;
        }
        this.setIssuerKeyId();
        this.setCreationTime();
    }

    private Vector<SignatureSubpacket> readSignatureSubpacketVector(BCPGInputStream in) throws IOException {
        SignatureSubpacket sub;
        int hashedLength = this.version == 6 ? StreamUtil.read4OctetLength(in) : StreamUtil.read2OctetLength(in);
        byte[] hashed = new byte[hashedLength];
        in.readFully(hashed);
        SignatureSubpacketInputStream sIn = new SignatureSubpacketInputStream(new ByteArrayInputStream(hashed));
        Vector<SignatureSubpacket> vec = new Vector<SignatureSubpacket>();
        while ((sub = sIn.readPacket()) != null) {
            vec.addElement(sub);
        }
        return vec;
    }

    private void parseSignature(BCPGInputStream in) throws IOException {
        switch (this.keyAlgorithm) {
            case 1: 
            case 3: {
                MPInteger v = new MPInteger(in);
                this.signature = new MPInteger[1];
                this.signature[0] = v;
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                MPInteger r = new MPInteger(in);
                MPInteger s = new MPInteger(in);
                this.signature = new MPInteger[2];
                this.signature[0] = r;
                this.signature[1] = s;
                break;
            }
            case 28: {
                this.signatureEncoding = new byte[114];
                in.readFully(this.signatureEncoding);
                break;
            }
            case 27: {
                this.signatureEncoding = new byte[64];
                in.readFully(this.signatureEncoding);
                break;
            }
            case 19: 
            case 22: {
                MPInteger ecR = new MPInteger(in);
                MPInteger ecS = new MPInteger(in);
                this.signature = new MPInteger[2];
                this.signature[0] = ecR;
                this.signature[1] = ecS;
                break;
            }
            default: {
                if (this.keyAlgorithm >= 100 && this.keyAlgorithm <= 110) {
                    this.signature = null;
                    this.signatureEncoding = Streams.readAll((InputStream)in);
                    break;
                }
                throw new IOException("unknown signature key algorithm: " + this.keyAlgorithm);
            }
        }
    }

    public SignaturePacket(int signatureType, long keyID, int keyAlgorithm, int hashAlgorithm, SignatureSubpacket[] hashedData, SignatureSubpacket[] unhashedData, byte[] fingerPrint, MPInteger[] signature) {
        this(4, signatureType, keyID, keyAlgorithm, hashAlgorithm, hashedData, unhashedData, fingerPrint, signature);
    }

    public SignaturePacket(int version, int signatureType, long keyID, int keyAlgorithm, int hashAlgorithm, long creationTime, byte[] fingerPrint, MPInteger[] signature) {
        this(version, signatureType, keyID, keyAlgorithm, hashAlgorithm, null, null, fingerPrint, signature);
        this.creationTime = creationTime;
    }

    public SignaturePacket(int version, int signatureType, long keyID, int keyAlgorithm, int hashAlgorithm, SignatureSubpacket[] hashedData, SignatureSubpacket[] unhashedData, byte[] fingerPrint, MPInteger[] signature) {
        super(2);
        this.version = version;
        this.signatureType = signatureType;
        this.keyID = keyID;
        this.keyAlgorithm = keyAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.hashedData = hashedData;
        this.unhashedData = unhashedData;
        this.fingerPrint = fingerPrint;
        this.signature = signature;
        if (hashedData != null) {
            this.setCreationTime();
        }
    }

    public SignaturePacket(int version, int signatureType, long keyID, int keyAlgorithm, int hashAlgorithm, SignatureSubpacket[] hashedData, SignatureSubpacket[] unhashedData, byte[] fingerPrint, byte[] signatureEncoding, byte[] salt) {
        super(2);
        this.version = version;
        this.signatureType = signatureType;
        this.keyID = keyID;
        this.keyAlgorithm = keyAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.hashedData = hashedData;
        this.unhashedData = unhashedData;
        this.fingerPrint = fingerPrint;
        this.signatureEncoding = Arrays.clone((byte[])signatureEncoding);
        this.salt = Arrays.clone((byte[])salt);
        if (hashedData != null) {
            this.setCreationTime();
        }
    }

    public SignaturePacket(int version, int signatureType, long keyID, int keyAlgorithm, int hashAlgorithm, SignatureSubpacket[] hashedData, SignatureSubpacket[] unhashedData, byte[] fingerPrint, MPInteger[] signature, byte[] salt) {
        super(2);
        this.version = version;
        this.signatureType = signatureType;
        this.keyID = keyID;
        this.keyAlgorithm = keyAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.hashedData = hashedData;
        this.unhashedData = unhashedData;
        this.fingerPrint = fingerPrint;
        this.signature = signature;
        this.salt = Arrays.clone((byte[])salt);
        if (hashedData != null) {
            this.setCreationTime();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getSignatureType() {
        return this.signatureType;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getFingerPrint() {
        return Arrays.clone((byte[])this.fingerPrint);
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getSignatureTrailer() {
        byte[] trailer = null;
        if (this.version == 3 || this.version == 2) {
            trailer = new byte[5];
            long time = this.creationTime / 1000L;
            trailer[0] = (byte)this.signatureType;
            Pack.intToBigEndian((int)((int)time), (byte[])trailer, (int)1);
        } else if (this.version == 4 || this.version == 5 || this.version == 6) {
            ByteArrayOutputStream sOut = new ByteArrayOutputStream();
            SignatureSubpacket[] hashed = this.getHashedSubPackets();
            try {
                sOut.write((byte)this.getVersion());
                sOut.write((byte)this.getSignatureType());
                sOut.write((byte)this.getKeyAlgorithm());
                sOut.write((byte)this.getHashAlgorithm());
                ByteArrayOutputStream hOut = new ByteArrayOutputStream();
                for (int i = 0; i != hashed.length; ++i) {
                    hashed[i].encode(hOut);
                }
                byte[] data = hOut.toByteArray();
                if (this.version != 6) {
                    StreamUtil.write2OctetLength(sOut, data.length);
                } else {
                    StreamUtil.write4OctetLength(sOut, data.length);
                }
                sOut.write(data);
                byte[] hData = sOut.toByteArray();
                sOut.write((byte)this.getVersion());
                sOut.write(-1);
                if (this.version == 5) {
                    StreamUtil.write8OctetLength(sOut, hData.length);
                } else {
                    StreamUtil.write4OctetLength(sOut, hData.length);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("exception generating trailer: " + e);
            }
            trailer = sOut.toByteArray();
        }
        return trailer;
    }

    public int getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public int getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public MPInteger[] getSignature() {
        return this.signature;
    }

    public byte[] getSignatureBytes() {
        if (this.signatureEncoding != null) {
            return Arrays.clone((byte[])this.signatureEncoding);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            BCPGOutputStream bcOut = new BCPGOutputStream(bOut);
            for (int i = 0; i != this.signature.length; ++i) {
                bcOut.writeObject(this.signature[i]);
            }
            bcOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException("internal error: " + e);
        }
        return bOut.toByteArray();
    }

    public SignatureSubpacket[] getHashedSubPackets() {
        return this.hashedData;
    }

    public SignatureSubpacket[] getUnhashedSubPackets() {
        return this.unhashedData;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream(bOut);
        pOut.write(this.version);
        if (this.version == 3 || this.version == 2) {
            pOut.write(5);
            pOut.write(this.signatureType);
            StreamUtil.writeTime(pOut, this.creationTime);
            StreamUtil.writeKeyID(pOut, this.keyID);
            pOut.write(this.keyAlgorithm);
            pOut.write(this.hashAlgorithm);
        } else if (this.version == 4 || this.version == 5 || this.version == 6) {
            pOut.write(this.signatureType);
            pOut.write(this.keyAlgorithm);
            pOut.write(this.hashAlgorithm);
            ByteArrayOutputStream sOut = new ByteArrayOutputStream();
            this.writeSignatureSubpacketArray(sOut, pOut, this.hashedData);
            sOut.reset();
            this.writeSignatureSubpacketArray(sOut, pOut, this.unhashedData);
        } else {
            throw new IOException("unknown version: " + this.version);
        }
        pOut.write(this.fingerPrint);
        if (this.version == 6) {
            pOut.write(this.salt.length);
            pOut.write(this.salt);
        }
        if (this.signature != null) {
            for (int i = 0; i != this.signature.length; ++i) {
                pOut.writeObject(this.signature[i]);
            }
        } else {
            pOut.write(this.signatureEncoding);
        }
        pOut.close();
        out.writePacket(this.hasNewPacketFormat(), 2, bOut.toByteArray());
    }

    private void writeSignatureSubpacketArray(ByteArrayOutputStream sOut, BCPGOutputStream pOut, SignatureSubpacket[] array) throws IOException {
        for (int i = 0; i != array.length; ++i) {
            array[i].encode(sOut);
        }
        byte[] data = sOut.toByteArray();
        if (this.version == 6) {
            StreamUtil.write4OctetLength(pOut, data.length);
        } else {
            StreamUtil.write2OctetLength(pOut, data.length);
        }
        pOut.write(data);
    }

    private void setCreationTime() {
        for (int i = 0; i != this.hashedData.length; ++i) {
            if (!(this.hashedData[i] instanceof SignatureCreationTime)) continue;
            this.creationTime = ((SignatureCreationTime)this.hashedData[i]).getTime().getTime();
            break;
        }
    }

    private void setIssuerKeyId() {
        SignatureSubpacket p;
        int idx;
        if (this.keyID != 0L) {
            return;
        }
        for (idx = 0; idx != this.hashedData.length; ++idx) {
            p = this.hashedData[idx];
            if (p instanceof IssuerKeyID) {
                this.keyID = ((IssuerKeyID)p).getKeyID();
                return;
            }
            if (!(p instanceof IssuerFingerprint)) continue;
            this.keyID = ((IssuerFingerprint)p).getKeyID();
            return;
        }
        for (idx = 0; idx != this.unhashedData.length; ++idx) {
            p = this.unhashedData[idx];
            if (p instanceof IssuerKeyID) {
                this.keyID = ((IssuerKeyID)p).getKeyID();
                return;
            }
            if (!(p instanceof IssuerFingerprint)) continue;
            this.keyID = ((IssuerFingerprint)p).getKeyID();
            return;
        }
    }

    public static SignaturePacket fromByteArray(byte[] data) throws IOException {
        BCPGInputStream in = new BCPGInputStream(new ByteArrayInputStream(data));
        return new SignaturePacket(in);
    }
}

