/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.neuralsearch.sparse.accessor.ClusteredPosting;
import org.opensearch.neuralsearch.sparse.accessor.ClusteredPostingReader;
import org.opensearch.neuralsearch.sparse.cache.AccountableTracker;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.cache.CacheableClusteredPostingWriter;
import org.opensearch.neuralsearch.sparse.cache.CircuitBreakerManager;
import org.opensearch.neuralsearch.sparse.cache.LruTermCache;
import org.opensearch.neuralsearch.sparse.cache.RamBytesRecorder;
import org.opensearch.neuralsearch.sparse.data.DocumentCluster;
import org.opensearch.neuralsearch.sparse.data.PostingClusters;

public class ClusteredPostingCacheItem
extends AccountableTracker
implements ClusteredPosting {
    @Generated
    private static final Logger log = LogManager.getLogger(ClusteredPostingCacheItem.class);
    private final CacheKey cacheKey;
    private final Map<BytesRef, PostingClusters> clusteredPostings = new ConcurrentHashMap<BytesRef, PostingClusters>();
    private final RamBytesRecorder globalTracker;
    private final ClusteredPostingReader reader = new CacheClusteredPostingReader();
    private final CacheableClusteredPostingWriter writer = new CacheClusteredPostingWriter();

    public CacheableClusteredPostingWriter getWriter(Consumer<Long> circuitBreakerHandler) {
        return new CacheClusteredPostingWriter(circuitBreakerHandler);
    }

    public ClusteredPostingCacheItem(CacheKey cacheKey, RamBytesRecorder globalTracker) {
        this.cacheKey = cacheKey;
        this.globalTracker = globalTracker;
        this.recordUsedBytes(RamUsageEstimator.shallowSizeOf(this.clusteredPostings));
        globalTracker.recordWithoutValidation(this.ramBytesUsed(), CircuitBreakerManager::addWithoutBreaking);
    }

    @Override
    @Generated
    public ClusteredPostingReader getReader() {
        return this.reader;
    }

    @Override
    @Generated
    public CacheableClusteredPostingWriter getWriter() {
        return this.writer;
    }

    private class CacheClusteredPostingWriter
    implements CacheableClusteredPostingWriter {
        private final Consumer<Long> circuitBreakerTriggerHandler;

        private CacheClusteredPostingWriter() {
            this.circuitBreakerTriggerHandler = ramBytesUsed -> LruTermCache.getInstance().evict((long)ramBytesUsed);
        }

        private CacheClusteredPostingWriter(Consumer<Long> circuitBreakerTriggerHandler) {
            this.circuitBreakerTriggerHandler = circuitBreakerTriggerHandler;
        }

        @Override
        public void insert(BytesRef term, List<DocumentCluster> clusters) {
            if (clusters == null || clusters.isEmpty() || term == null) {
                return;
            }
            BytesRef clonedTerm = term.clone();
            PostingClusters postingClusters = new PostingClusters(clusters);
            long ramBytesUsed = postingClusters.ramBytesUsed() + RamUsageEstimator.shallowSizeOf((Object)clonedTerm) + (long)clonedTerm.bytes.length;
            if (!ClusteredPostingCacheItem.this.globalTracker.record(ramBytesUsed)) {
                if (this.circuitBreakerTriggerHandler != null) {
                    this.circuitBreakerTriggerHandler.accept(ramBytesUsed);
                }
                if (!ClusteredPostingCacheItem.this.globalTracker.record(ramBytesUsed)) {
                    return;
                }
            }
            PostingClusters existingClusters = ClusteredPostingCacheItem.this.clusteredPostings.putIfAbsent(clonedTerm, postingClusters);
            LruTermCache.TermKey termKey = new LruTermCache.TermKey(ClusteredPostingCacheItem.this.cacheKey, clonedTerm);
            LruTermCache.getInstance().updateAccess(termKey);
            if (existingClusters == null) {
                ClusteredPostingCacheItem.this.recordUsedBytes(ramBytesUsed);
            } else {
                ClusteredPostingCacheItem.this.globalTracker.recordWithoutValidation(-ramBytesUsed, CircuitBreakerManager::addWithoutBreaking);
            }
        }

        @Override
        public long erase(BytesRef term) {
            if (term == null) {
                return 0L;
            }
            PostingClusters postingClusters = ClusteredPostingCacheItem.this.clusteredPostings.get(term);
            if (postingClusters == null) {
                return 0L;
            }
            BytesRef clonedTerm = term.clone();
            long ramBytesReleased = postingClusters.ramBytesUsed() + RamUsageEstimator.shallowSizeOf((Object)clonedTerm) + (long)clonedTerm.bytes.length;
            if (ClusteredPostingCacheItem.this.clusteredPostings.remove(clonedTerm) != null) {
                ClusteredPostingCacheItem.this.recordUsedBytes(-ramBytesReleased);
                ClusteredPostingCacheItem.this.globalTracker.recordWithoutValidation(-ramBytesReleased, CircuitBreakerManager::addWithoutBreaking);
                return ramBytesReleased;
            }
            return 0L;
        }
    }

    private class CacheClusteredPostingReader
    implements ClusteredPostingReader {
        private CacheClusteredPostingReader() {
        }

        @Override
        public PostingClusters read(BytesRef term) {
            PostingClusters clusters = ClusteredPostingCacheItem.this.clusteredPostings.get(term);
            if (clusters != null) {
                LruTermCache.TermKey termKey = new LruTermCache.TermKey(ClusteredPostingCacheItem.this.cacheKey, term.clone());
                LruTermCache.getInstance().updateAccess(termKey);
            }
            return clusters;
        }

        @Override
        public Set<BytesRef> getTerms() {
            return ClusteredPostingCacheItem.this.clusteredPostings.keySet();
        }

        @Override
        public long size() {
            return ClusteredPostingCacheItem.this.clusteredPostings.size();
        }
    }
}

