/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.opensearch.snapshot.RestoreSnapshotResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class RestoreSnapshotRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RestoreSnapshotRequest> {
    @Nullable
    private final Time clusterManagerTimeout;
    @Nonnull
    private final List<String> ignoreIndexSettings;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean includeAliases;
    @Nullable
    private final Boolean includeGlobalState;
    @Nullable
    private final IndexSettings indexSettings;
    @Nonnull
    private final List<String> indices;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Boolean partial;
    @Nullable
    private final String renameAliasPattern;
    @Nullable
    private final String renameAliasReplacement;
    @Nullable
    private final String renamePattern;
    @Nullable
    private final String renameReplacement;
    @Nonnull
    private final String repository;
    @Nonnull
    private final String snapshot;
    @Nullable
    private final String sourceRemoteStoreRepository;
    @Nullable
    private final String storageType;
    @Nullable
    private final Boolean waitForCompletion;
    public static final JsonpDeserializer<RestoreSnapshotRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RestoreSnapshotRequest::setupRestoreSnapshotRequestDeserializer);
    public static final Endpoint<RestoreSnapshotRequest, RestoreSnapshotResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RestoreSnapshotRequest, RestoreSnapshotResponse>(request -> "POST", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_snapshot/");
        SimpleEndpoint.pathEncode(request.repository, buf);
        buf.append("/");
        SimpleEndpoint.pathEncode(request.snapshot, buf);
        buf.append("/_restore");
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, RestoreSnapshotResponse._DESERIALIZER);

    private RestoreSnapshotRequest(Builder builder) {
        super(builder);
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.ignoreIndexSettings = ApiTypeHelper.unmodifiable(builder.ignoreIndexSettings);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.includeAliases = builder.includeAliases;
        this.includeGlobalState = builder.includeGlobalState;
        this.indexSettings = builder.indexSettings;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.masterTimeout = builder.masterTimeout;
        this.partial = builder.partial;
        this.renameAliasPattern = builder.renameAliasPattern;
        this.renameAliasReplacement = builder.renameAliasReplacement;
        this.renamePattern = builder.renamePattern;
        this.renameReplacement = builder.renameReplacement;
        this.repository = ApiTypeHelper.requireNonNull(builder.repository, this, "repository");
        this.snapshot = ApiTypeHelper.requireNonNull(builder.snapshot, this, "snapshot");
        this.sourceRemoteStoreRepository = builder.sourceRemoteStoreRepository;
        this.storageType = builder.storageType;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static RestoreSnapshotRequest of(Function<Builder, ObjectBuilder<RestoreSnapshotRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nonnull
    public final List<String> ignoreIndexSettings() {
        return this.ignoreIndexSettings;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public final Boolean includeAliases() {
        return this.includeAliases;
    }

    @Nullable
    public final Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    @Nullable
    public final IndexSettings indexSettings() {
        return this.indexSettings;
    }

    @Nonnull
    public final List<String> indices() {
        return this.indices;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Boolean partial() {
        return this.partial;
    }

    @Nullable
    public final String renameAliasPattern() {
        return this.renameAliasPattern;
    }

    @Nullable
    public final String renameAliasReplacement() {
        return this.renameAliasReplacement;
    }

    @Nullable
    public final String renamePattern() {
        return this.renamePattern;
    }

    @Nullable
    public final String renameReplacement() {
        return this.renameReplacement;
    }

    @Nonnull
    public final String repository() {
        return this.repository;
    }

    @Nonnull
    public final String snapshot() {
        return this.snapshot;
    }

    @Nullable
    public final String sourceRemoteStoreRepository() {
        return this.sourceRemoteStoreRepository;
    }

    @Nullable
    public final String storageType() {
        return this.storageType;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.ignoreIndexSettings)) {
            generator.writeKey("ignore_index_settings");
            generator.writeStartArray();
            for (String item0 : this.ignoreIndexSettings) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.ignoreUnavailable != null) {
            generator.writeKey("ignore_unavailable");
            generator.write(this.ignoreUnavailable.booleanValue());
        }
        if (this.includeAliases != null) {
            generator.writeKey("include_aliases");
            generator.write(this.includeAliases.booleanValue());
        }
        if (this.includeGlobalState != null) {
            generator.writeKey("include_global_state");
            generator.write(this.includeGlobalState.booleanValue());
        }
        if (this.indexSettings != null) {
            generator.writeKey("index_settings");
            this.indexSettings.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.partial != null) {
            generator.writeKey("partial");
            generator.write(this.partial.booleanValue());
        }
        if (this.renameAliasPattern != null) {
            generator.writeKey("rename_alias_pattern");
            generator.write(this.renameAliasPattern);
        }
        if (this.renameAliasReplacement != null) {
            generator.writeKey("rename_alias_replacement");
            generator.write(this.renameAliasReplacement);
        }
        if (this.renamePattern != null) {
            generator.writeKey("rename_pattern");
            generator.write(this.renamePattern);
        }
        if (this.renameReplacement != null) {
            generator.writeKey("rename_replacement");
            generator.write(this.renameReplacement);
        }
        if (this.sourceRemoteStoreRepository != null) {
            generator.writeKey("source_remote_store_repository");
            generator.write(this.sourceRemoteStoreRepository);
        }
        if (this.storageType != null) {
            generator.writeKey("storage_type");
            generator.write(this.storageType);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRestoreSnapshotRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::ignoreIndexSettings, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ignore_index_settings");
        op.add(Builder::ignoreUnavailable, JsonpDeserializer.booleanDeserializer(), "ignore_unavailable");
        op.add(Builder::includeAliases, JsonpDeserializer.booleanDeserializer(), "include_aliases");
        op.add(Builder::includeGlobalState, JsonpDeserializer.booleanDeserializer(), "include_global_state");
        op.add(Builder::indexSettings, IndexSettings._DESERIALIZER, "index_settings");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::partial, JsonpDeserializer.booleanDeserializer(), "partial");
        op.add(Builder::renameAliasPattern, JsonpDeserializer.stringDeserializer(), "rename_alias_pattern");
        op.add(Builder::renameAliasReplacement, JsonpDeserializer.stringDeserializer(), "rename_alias_replacement");
        op.add(Builder::renamePattern, JsonpDeserializer.stringDeserializer(), "rename_pattern");
        op.add(Builder::renameReplacement, JsonpDeserializer.stringDeserializer(), "rename_replacement");
        op.add(Builder::sourceRemoteStoreRepository, JsonpDeserializer.stringDeserializer(), "source_remote_store_repository");
        op.add(Builder::storageType, JsonpDeserializer.stringDeserializer(), "storage_type");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
        if (this.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(this.waitForCompletion));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.ignoreIndexSettings);
        result = 31 * result + Objects.hashCode(this.ignoreUnavailable);
        result = 31 * result + Objects.hashCode(this.includeAliases);
        result = 31 * result + Objects.hashCode(this.includeGlobalState);
        result = 31 * result + Objects.hashCode(this.indexSettings);
        result = 31 * result + Objects.hashCode(this.indices);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + Objects.hashCode(this.partial);
        result = 31 * result + Objects.hashCode(this.renameAliasPattern);
        result = 31 * result + Objects.hashCode(this.renameAliasReplacement);
        result = 31 * result + Objects.hashCode(this.renamePattern);
        result = 31 * result + Objects.hashCode(this.renameReplacement);
        result = 31 * result + this.repository.hashCode();
        result = 31 * result + this.snapshot.hashCode();
        result = 31 * result + Objects.hashCode(this.sourceRemoteStoreRepository);
        result = 31 * result + Objects.hashCode(this.storageType);
        result = 31 * result + Objects.hashCode(this.waitForCompletion);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreSnapshotRequest other = (RestoreSnapshotRequest)o;
        return Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.ignoreIndexSettings, other.ignoreIndexSettings) && Objects.equals(this.ignoreUnavailable, other.ignoreUnavailable) && Objects.equals(this.includeAliases, other.includeAliases) && Objects.equals(this.includeGlobalState, other.includeGlobalState) && Objects.equals(this.indexSettings, other.indexSettings) && Objects.equals(this.indices, other.indices) && Objects.equals(this.masterTimeout, other.masterTimeout) && Objects.equals(this.partial, other.partial) && Objects.equals(this.renameAliasPattern, other.renameAliasPattern) && Objects.equals(this.renameAliasReplacement, other.renameAliasReplacement) && Objects.equals(this.renamePattern, other.renamePattern) && Objects.equals(this.renameReplacement, other.renameReplacement) && this.repository.equals(other.repository) && this.snapshot.equals(other.snapshot) && Objects.equals(this.sourceRemoteStoreRepository, other.sourceRemoteStoreRepository) && Objects.equals(this.storageType, other.storageType) && Objects.equals(this.waitForCompletion, other.waitForCompletion);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RestoreSnapshotRequest> {
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private List<String> ignoreIndexSettings;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean includeAliases;
        @Nullable
        private Boolean includeGlobalState;
        @Nullable
        private IndexSettings indexSettings;
        @Nullable
        private List<String> indices;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Boolean partial;
        @Nullable
        private String renameAliasPattern;
        @Nullable
        private String renameAliasReplacement;
        @Nullable
        private String renamePattern;
        @Nullable
        private String renameReplacement;
        private String repository;
        private String snapshot;
        @Nullable
        private String sourceRemoteStoreRepository;
        @Nullable
        private String storageType;
        @Nullable
        private Boolean waitForCompletion;

        public Builder() {
        }

        private Builder(RestoreSnapshotRequest o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.ignoreIndexSettings = Builder._listCopy(o.ignoreIndexSettings);
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.includeAliases = o.includeAliases;
            this.includeGlobalState = o.includeGlobalState;
            this.indexSettings = o.indexSettings;
            this.indices = Builder._listCopy(o.indices);
            this.masterTimeout = o.masterTimeout;
            this.partial = o.partial;
            this.renameAliasPattern = o.renameAliasPattern;
            this.renameAliasReplacement = o.renameAliasReplacement;
            this.renamePattern = o.renamePattern;
            this.renameReplacement = o.renameReplacement;
            this.repository = o.repository;
            this.snapshot = o.snapshot;
            this.sourceRemoteStoreRepository = o.sourceRemoteStoreRepository;
            this.storageType = o.storageType;
            this.waitForCompletion = o.waitForCompletion;
        }

        private Builder(Builder o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.ignoreIndexSettings = Builder._listCopy(o.ignoreIndexSettings);
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.includeAliases = o.includeAliases;
            this.includeGlobalState = o.includeGlobalState;
            this.indexSettings = o.indexSettings;
            this.indices = Builder._listCopy(o.indices);
            this.masterTimeout = o.masterTimeout;
            this.partial = o.partial;
            this.renameAliasPattern = o.renameAliasPattern;
            this.renameAliasReplacement = o.renameAliasReplacement;
            this.renamePattern = o.renamePattern;
            this.renameReplacement = o.renameReplacement;
            this.repository = o.repository;
            this.snapshot = o.snapshot;
            this.sourceRemoteStoreRepository = o.sourceRemoteStoreRepository;
            this.storageType = o.storageType;
            this.waitForCompletion = o.waitForCompletion;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder ignoreIndexSettings(List<String> list) {
            this.ignoreIndexSettings = Builder._listAddAll(this.ignoreIndexSettings, list);
            return this;
        }

        @Nonnull
        public final Builder ignoreIndexSettings(String value, String ... values) {
            this.ignoreIndexSettings = Builder._listAdd(this.ignoreIndexSettings, value, values);
            return this;
        }

        @Nonnull
        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        @Nonnull
        public final Builder includeAliases(@Nullable Boolean value) {
            this.includeAliases = value;
            return this;
        }

        @Nonnull
        public final Builder includeGlobalState(@Nullable Boolean value) {
            this.includeGlobalState = value;
            return this;
        }

        @Nonnull
        public final Builder indexSettings(@Nullable IndexSettings value) {
            this.indexSettings = value;
            return this;
        }

        @Nonnull
        public final Builder indexSettings(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.indexSettings(fn.apply(new IndexSettings.Builder()).build());
        }

        @Nonnull
        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        @Nonnull
        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder partial(@Nullable Boolean value) {
            this.partial = value;
            return this;
        }

        @Nonnull
        public final Builder renameAliasPattern(@Nullable String value) {
            this.renameAliasPattern = value;
            return this;
        }

        @Nonnull
        public final Builder renameAliasReplacement(@Nullable String value) {
            this.renameAliasReplacement = value;
            return this;
        }

        @Nonnull
        public final Builder renamePattern(@Nullable String value) {
            this.renamePattern = value;
            return this;
        }

        @Nonnull
        public final Builder renameReplacement(@Nullable String value) {
            this.renameReplacement = value;
            return this;
        }

        @Nonnull
        public final Builder repository(String value) {
            this.repository = value;
            return this;
        }

        @Nonnull
        public final Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        @Nonnull
        public final Builder sourceRemoteStoreRepository(@Nullable String value) {
            this.sourceRemoteStoreRepository = value;
            return this;
        }

        @Nonnull
        public final Builder storageType(@Nullable String value) {
            this.storageType = value;
            return this;
        }

        @Nonnull
        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        @Nonnull
        public RestoreSnapshotRequest build() {
            this._checkSingleUse();
            return new RestoreSnapshotRequest(this);
        }
    }
}

