/*
 * Decompiled with CFR 0.152.
 */
package com.selectivem.collections;

abstract class Hashing {
    static final int NO_SPACE = Integer.MAX_VALUE;
    static final int B4 = 15;
    static final int B5 = 31;
    static final int B6 = 63;
    static final int B7 = 127;
    static final int B8 = 255;
    static final int B9 = 511;
    static final int B10 = 1023;
    static final int B11 = 2047;
    static final int B12 = 4095;
    static final int B13 = 8191;
    static final int B14 = 16383;
    static final int B15 = Short.MAX_VALUE;
    static final int B16 = 65535;

    Hashing() {
    }

    static int hashPosition(int tableSize, Object e) {
        if (e == null) {
            throw new IllegalArgumentException("null values are not supported");
        }
        int hash = e.hashCode();
        switch (tableSize) {
            case 16: {
                hash = Hashing.scramble(hash);
                int h8 = Hashing.hashTo8bit(hash);
                return h8 & 0xF ^ h8 >> 4 & 0xF;
            }
            case 64: {
                hash = Hashing.scramble(hash);
                return hash & 0x3F ^ hash >> 6 & 0x3F ^ hash >> 12 & 0x3F ^ hash >> 18 & 0x3F ^ hash >> 24 & 0xF ^ hash >> 28 & 0xF;
            }
            case 256: {
                hash = Hashing.scramble(hash);
                return Hashing.hashTo8bit(hash);
            }
            case 512: {
                hash = Hashing.scramble2(Hashing.scramble(hash));
                return hash & 0x1FF ^ hash >> 9 & 0x7F ^ hash >> 16 & 0x1FF ^ hash >> 25 & 0x7F;
            }
            case 1024: {
                hash = Hashing.scramble2(Hashing.scramble(hash));
                return hash & 0x3FF ^ hash >> 10 & 0x3F ^ hash >> 16 & 0x3FF ^ hash >> 26 & 0x3F;
            }
            case 2048: {
                hash = Hashing.scramble2(Hashing.scramble(hash));
                return hash & 0x7FF ^ hash >> 11 & 0x3FF ^ hash >> 21 & 0x7FF;
            }
            case 4096: {
                hash = Hashing.scramble2(Hashing.scramble(hash));
                return hash & 0xFFF ^ hash >> 12 & 0xFF ^ hash >> 20 & 0xFFF;
            }
            case 8192: {
                hash = Hashing.scramble2(Hashing.scramble(hash));
                return hash & 0x1FFF ^ hash >> 13 & 0x3F ^ hash >> 19 & 0x1FFF;
            }
            case 16384: {
                hash = Hashing.scramble2(Hashing.scramble(hash));
                return hash & 0x3FFF ^ hash >> 14 & 0xF ^ hash >> 18 & 0x3FFF;
            }
            case 32768: {
                hash = Hashing.scramble2(Hashing.scramble(hash));
                return hash & Short.MAX_VALUE ^ hash >> 15 & 0xFF ^ hash >> 23 & 0x1FF;
            }
            case 65536: {
                hash = Hashing.scramble2(Hashing.scramble(hash));
                return hash & 0xFFFF ^ hash >> 16 & 0xFFFF;
            }
        }
        hash = Hashing.scramble2(Hashing.scramble(hash));
        assert ((tableSize & tableSize - 1) == 0) : "tableSize must be a power of two";
        return hash & tableSize - 1;
    }

    static int hashTo8bit(int hash) {
        return hash & 0xFF ^ hash >> 8 & 0xFF ^ hash >> 16 & 0xFF ^ hash >> 24 & 0xFF;
    }

    static int scramble(int n) {
        n = (int)((long)n * 3432918353L);
        n = Integer.rotateLeft(n, 15);
        n = (int)((long)n * 461845907L);
        return n;
    }

    static int scramble2(int h) {
        h ^= h >> 16;
        h *= -2048144789;
        h ^= h >> 13;
        h *= -1028477387;
        h ^= h >> 16;
        return h;
    }

    static int hashTableSize(int elementCount) {
        if (elementCount <= 10) {
            return 16;
        }
        if (elementCount <= 45) {
            return 64;
        }
        if (elementCount <= 180) {
            return 256;
        }
        if (elementCount <= 360) {
            return 512;
        }
        if (elementCount <= 720) {
            return 1024;
        }
        if (elementCount <= 1440) {
            return 2048;
        }
        if (elementCount <= 2880) {
            return 4096;
        }
        if (elementCount <= 5750) {
            return 8192;
        }
        if (elementCount <= 11500) {
            return 16384;
        }
        if (elementCount <= 23000) {
            return 32768;
        }
        if (elementCount <= 46000) {
            return 65536;
        }
        if (elementCount <= 92000) {
            return 131072;
        }
        if (elementCount <= 180000) {
            return 262144;
        }
        return -1;
    }

    static int nextSize(int tableSize) {
        switch (tableSize) {
            case 16: {
                return 64;
            }
            case 64: {
                return 256;
            }
            case 256: {
                return 512;
            }
            case 512: {
                return 1024;
            }
        }
        if (tableSize <= 131072) {
            return tableSize * 2;
        }
        return -1;
    }

    static short maxProbingDistance(int tableSize) {
        if (tableSize <= 16) {
            return 8;
        }
        if (tableSize <= 512) {
            return 12;
        }
        if (tableSize <= 4096) {
            return 16;
        }
        if (tableSize <= 32768) {
            return 24;
        }
        return 32;
    }

    static <E> int checkTable(E[] table, Object e, int hashPosition, short maxProbingDistance) {
        if (table[hashPosition] == null) {
            return hashPosition;
        }
        if (table[hashPosition].equals(e)) {
            return -1 - hashPosition;
        }
        int max = hashPosition + maxProbingDistance;
        for (int i = hashPosition + 1; i <= max; ++i) {
            if (table[i] == null) {
                return i;
            }
            if (!table[i].equals(e)) continue;
            return -1 - i;
        }
        return Integer.MAX_VALUE;
    }
}

