/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyBroadExceptionInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyBroadExceptionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyBroadExceptionInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    public static boolean equalsException(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PyBroadExceptionInspection.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyBroadExceptionInspection.$$$reportNull$$$0(3);
        }
        PyType type = context.getType((PyTypedElement)cls);
        return ("Exception".equals(cls.getName()) || "BaseException".equals(cls.getName())) && type != null && type.isBuiltin();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyBroadExceptionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "equalsException";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        public void visitPyExceptBlock(@NotNull PyExceptPart node) {
            PyType type;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            PyExpression exceptClass = node.getExceptClass();
            if (Visitor.reRaised(node)) {
                return;
            }
            if (exceptClass == null) {
                this.registerProblem(node.getFirstChild(), PyPsiBundle.message("INSP.too.broad.exception.clause", new Object[0]));
            }
            if (exceptClass instanceof PyReferenceExpression && (type = this.myTypeEvalContext.getType((PyTypedElement)exceptClass)) instanceof PyClassType) {
                PyClass cls = ((PyClassType)type).getPyClass();
                PyExpression target = node.getTarget();
                if (PyBroadExceptionInspection.equalsException(cls, this.myTypeEvalContext) && (target == null || !Visitor.isExceptionUsed(node, target.getText()))) {
                    this.registerProblem((PsiElement)exceptClass, PyPsiBundle.message("INSP.too.broad.exception.clause", new Object[0]));
                }
            }
        }

        private static boolean reRaised(PyExceptPart node) {
            PyStatementList statementList = node.getStatementList();
            for (PyStatement st : statementList.getStatements()) {
                if (!(st instanceof PyRaiseStatement)) continue;
                return true;
            }
            return false;
        }

        private static boolean isExceptionUsed(PyExceptPart node, String text) {
            Stack stack = new Stack();
            PyStatementList statementList = node.getStatementList();
            for (PyStatement st : statementList.getStatements()) {
                stack.push((Object)st);
                while (!stack.isEmpty()) {
                    PyReferenceExpression ref;
                    PsiElement resolved;
                    PsiElement e = (PsiElement)stack.pop();
                    if (e instanceof PyReferenceExpression && (resolved = (ref = (PyReferenceExpression)e).getReference().resolve()) != null && text.equals(resolved.getText())) {
                        return true;
                    }
                    for (PsiElement psiElement : e.getChildren()) {
                        stack.push((Object)psiElement);
                    }
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyBroadExceptionInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyExceptBlock";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

