/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.ui.table.MatchResult;
import com.intellij.vcs.log.ui.table.SimpleVcsLogUserFilter;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.VcsLogSpeedSearch;
import com.intellij.vcs.log.ui.table.column.Author;
import com.intellij.vcs.log.ui.table.column.VcsLogMetadataColumn;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0014J\u001a\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\n\u0010\u0017\u001a\u00060\u001ej\u0002`\u001fH\u0014J!\u0010 \u001a\n\u0018\u00010\u001ej\u0004\u0018\u0001`!2\n\u0010\u0017\u001a\u00060\u001ej\u0002`\u001fH\u0004\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/vcs/log/ui/table/IndexSpeedSearch;", "Lcom/intellij/vcs/log/ui/table/VcsLogSpeedSearch;", "project", "Lcom/intellij/openapi/project/Project;", "index", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "component", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/index/VcsLogIndex;Lcom/intellij/vcs/log/data/VcsLogStorage;Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;)V", "userRegistry", "Lcom/intellij/vcs/log/VcsUserRegistry;", "matchResult", "Lcom/intellij/vcs/log/ui/table/MatchResult;", "matchUsers", "oldMatchResult", "newPattern", "", "isSpeedSearchEnabled", "", "isMatchingElement", "row", "", "pattern", "isMatchingMetadata", "metadata", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "getCommitMetadata", "", "Lcom/intellij/vcs/log/ui/table/VcsLogTableIndex;", "getCommitId", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "(I)Ljava/lang/Integer;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nIndexSpeedSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexSpeedSearch.kt\ncom/intellij/vcs/log/ui/table/IndexSpeedSearch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n774#2:90\n865#2,2:91\n1740#2,3:93\n*S KotlinDebug\n*F\n+ 1 IndexSpeedSearch.kt\ncom/intellij/vcs/log/ui/table/IndexSpeedSearch\n*L\n39#1:90\n39#1:91,2\n50#1:93,3\n*E\n"})
public class IndexSpeedSearch
extends VcsLogSpeedSearch {
    @NotNull
    private final VcsLogIndex index;
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final VcsUserRegistry userRegistry;
    @Nullable
    private MatchResult matchResult;

    public IndexSpeedSearch(@NotNull Project project, @NotNull VcsLogIndex index, @NotNull VcsLogStorage storage, @NotNull VcsLogGraphTable component) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super(component);
        this.index = index;
        this.storage = storage;
        Object object = project.getService(VcsUserRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        this.userRegistry = (VcsUserRegistry)object;
        this.addChangeListener(arg_0 -> IndexSpeedSearch._init_$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final MatchResult matchUsers(MatchResult oldMatchResult, String newPattern) {
        void $this$filterTo$iv$iv;
        Collection<VcsUser> collection;
        String oldPattern;
        IndexDataGetter dataGetter = this.index.getDataGetter();
        CharSequence charSequence = newPattern;
        if (charSequence == null || charSequence.length() == 0 || dataGetter == null) {
            return null;
        }
        MatchResult matchResult = oldMatchResult;
        String string = oldPattern = matchResult != null ? matchResult.pattern : null;
        if (oldPattern != null && StringsKt.contains$default((CharSequence)newPattern, (CharSequence)oldPattern, (boolean)false, (int)2, null)) {
            collection = oldMatchResult.matchingUsers;
        } else {
            Set set = this.userRegistry.getUsers();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getUsers(...)");
            collection = set;
        }
        Collection<VcsUser> usersToExamine = collection;
        Iterable $this$filter$iv = usersToExamine;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsUser user2 = (VcsUser)element$iv$iv;
            boolean bl = false;
            if (!this.compare(VcsUserUtil.getShortPresentation((VcsUser)user2), newPattern)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matchedUsers = (List)destination$iv$iv;
        if (matchedUsers.isEmpty()) {
            return null;
        }
        IntSet intSet = dataGetter.filter(CollectionsKt.listOf((Object)new SimpleVcsLogUserFilter(matchedUsers)));
        Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"filter(...)");
        IntSet matchedByUserCommits = intSet;
        return new MatchResult(newPattern, matchedByUserCommits, matchedUsers);
    }

    protected boolean isSpeedSearchEnabled() {
        if (super.isSpeedSearchEnabled()) {
            boolean bl;
            block4: {
                VisiblePack visiblePack = ((VcsLogGraphTable)((Object)this.myComponent)).getModel().getVisiblePack();
                Set<VirtualFile> set = VcsLogUtil.getAllVisibleRoots((Collection<VirtualFile>)visiblePack.getLogProviders().keySet(), visiblePack.getFilters());
                Intrinsics.checkNotNullExpressionValue(set, (String)"getAllVisibleRoots(...)");
                Iterable $this$all$iv = set;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl2 = false;
                        if (this.index.isIndexed(it)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    @Override
    protected boolean isMatchingElement(@NotNull Object row, @NotNull String pattern) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Integer n = this.getCommitId((Integer)row);
        if (n == null) {
            return false;
        }
        int commitId = n;
        if (super.isMatchingElement(row, pattern)) {
            return true;
        }
        MatchResult matchResult = this.matchResult;
        if (matchResult != null) {
            MatchResult $this$isMatchingElement_u24lambda_u240 = matchResult;
            boolean bl2 = false;
            bl = !((Collection)$this$isMatchingElement_u24lambda_u240.commitsForUsers).isEmpty() && $this$isMatchingElement_u24lambda_u240.commitsForUsers.contains(commitId);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean isMatchingMetadata(@NotNull String pattern, @Nullable VcsCommitMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        if (metadata instanceof IndexedDetails) {
            List<VcsLogMetadataColumn> list = this.getColumnsForSpeedSearch();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getColumnsForSpeedSearch(...)");
            return this.isMatchingMetadata(pattern, metadata, CollectionsKt.minus((Iterable)list, (Object)Author.INSTANCE));
        }
        return super.isMatchingMetadata(pattern, metadata);
    }

    @Override
    @Nullable
    protected VcsCommitMetadata getCommitMetadata(int row) {
        IndexDataGetter indexDataGetter = this.index.getDataGetter();
        if (indexDataGetter == null) {
            return super.getCommitMetadata(row);
        }
        IndexDataGetter dataGetter = indexDataGetter;
        Integer n = this.getCommitId(row);
        if (n == null) {
            return null;
        }
        int commitId = n;
        return (VcsCommitMetadata)new IndexedDetails(dataGetter, this.storage, commitId, 0L, 8, null);
    }

    @Nullable
    protected final Integer getCommitId(int row) {
        return ((VcsLogGraphTable)((Object)this.myComponent)).getModel().getId(row);
    }

    private static final void _init_$lambda$0(IndexSpeedSearch this$0, PropertyChangeEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (Intrinsics.areEqual((Object)evt.getPropertyName(), (Object)"enteredPrefix")) {
            Object object = evt.getNewValue();
            this$0.matchResult = this$0.matchUsers(this$0.matchResult, object instanceof String ? (String)object : null);
        }
    }
}

