/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.json.JsonBundle;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.fixes.AddMissingPropertyFix;
import com.jetbrains.jsonSchema.impl.fixes.FixPropertyNameTypoFix;
import com.jetbrains.jsonSchema.impl.fixes.RemoveDuplicateArrayItemsFix;
import com.jetbrains.jsonSchema.impl.fixes.RemoveProhibitedPropertyFix;
import com.jetbrains.jsonSchema.impl.fixes.SuggestEnumValuesFix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonValidationError {
    private final @InspectionMessage String myMessage;
    private final FixableIssueKind myFixableIssueKind;
    private final IssueData myIssueData;
    private final JsonErrorPriority myPriority;

    public IssueData getIssueData() {
        return this.myIssueData;
    }

    public JsonErrorPriority getPriority() {
        return this.myPriority;
    }

    public JsonValidationError(@InspectionMessage String message, FixableIssueKind fixableIssueKind, IssueData issueData, JsonErrorPriority priority) {
        this.myMessage = message;
        this.myFixableIssueKind = fixableIssueKind;
        this.myIssueData = issueData;
        this.myPriority = priority;
    }

    @InspectionMessage
    public String getMessage() {
        return this.myMessage;
    }

    public FixableIssueKind getFixableIssueKind() {
        return this.myFixableIssueKind;
    }

    public LocalQuickFix @NotNull [] createFixes(@Nullable JsonLikeSyntaxAdapter quickFixAdapter) {
        Object[] objectArray;
        if (quickFixAdapter == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                JsonValidationError.$$$reportNull$$$0(0);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        switch (this.myFixableIssueKind.ordinal()) {
            case 0: {
                AddMissingPropertyFix[] addMissingPropertyFixArray = new AddMissingPropertyFix[1];
                objectArray = addMissingPropertyFixArray;
                addMissingPropertyFixArray[0] = new AddMissingPropertyFix((MissingMultiplePropsIssueData)this.myIssueData, quickFixAdapter);
                break;
            }
            case 2: 
            case 3: {
                objectArray = (LocalQuickFix[])((MissingOneOfPropsIssueData)this.myIssueData).myExclusiveOptions.stream().map(d -> new AddMissingPropertyFix((MissingMultiplePropsIssueData)d, quickFixAdapter)).toArray(LocalQuickFix[]::new);
                break;
            }
            case 4: {
                objectArray = this.getProhibitedPropertyFixes(quickFixAdapter);
                break;
            }
            case 5: {
                SuggestEnumValuesFix[] suggestEnumValuesFixArray = new SuggestEnumValuesFix[1];
                objectArray = suggestEnumValuesFixArray;
                suggestEnumValuesFixArray[0] = new SuggestEnumValuesFix(quickFixAdapter);
                break;
            }
            case 8: {
                RemoveDuplicateArrayItemsFix[] removeDuplicateArrayItemsFixArray = new RemoveDuplicateArrayItemsFix[1];
                objectArray = removeDuplicateArrayItemsFixArray;
                removeDuplicateArrayItemsFixArray[0] = new RemoveDuplicateArrayItemsFix(((DuplicateArrayItemIssueData)this.myIssueData).duplicateIndices);
                break;
            }
            default: {
                objectArray = LocalQuickFix.EMPTY_ARRAY;
            }
        }
        if (objectArray == null) {
            JsonValidationError.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    private LocalQuickFix @NotNull [] getProhibitedPropertyFixes(@NotNull JsonLikeSyntaxAdapter quickFixAdapter) {
        if (quickFixAdapter == null) {
            JsonValidationError.$$$reportNull$$$0(2);
        }
        ProhibitedPropertyIssueData data = (ProhibitedPropertyIssueData)this.myIssueData;
        if (data.typoCandidates.isEmpty()) {
            RemoveProhibitedPropertyFix[] removeProhibitedPropertyFixArray = new RemoveProhibitedPropertyFix[]{new RemoveProhibitedPropertyFix(data, quickFixAdapter)};
            if (removeProhibitedPropertyFixArray == null) {
                JsonValidationError.$$$reportNull$$$0(3);
            }
            return removeProhibitedPropertyFixArray;
        }
        ArrayList<PsiUpdateModCommandQuickFix> allFixes = new ArrayList<PsiUpdateModCommandQuickFix>();
        for (String candidate : data.typoCandidates) {
            allFixes.add(new FixPropertyNameTypoFix(candidate, quickFixAdapter));
        }
        allFixes.add(new RemoveProhibitedPropertyFix(data, quickFixAdapter));
        LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])allFixes.toArray(LocalQuickFix[]::new);
        if (localQuickFixArray == null) {
            JsonValidationError.$$$reportNull$$$0(4);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonValidationError";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonValidationError";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProhibitedPropertyFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProhibitedPropertyFixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    public static interface IssueData {
    }

    public static enum FixableIssueKind {
        MissingProperty,
        MissingOptionalProperty,
        MissingOneOfProperty,
        MissingAnyOfProperty,
        ProhibitedProperty,
        NonEnumValue,
        ProhibitedType,
        TypeMismatch,
        DuplicateArrayItem,
        None;

    }

    public static final class MissingMultiplePropsIssueData
    implements IssueData {
        public final Collection<MissingPropertyIssueData> myMissingPropertyIssues;

        public MissingMultiplePropsIssueData(Collection<MissingPropertyIssueData> missingPropertyIssues) {
            this.myMissingPropertyIssues = missingPropertyIssues;
        }

        private static String getPropertyNameWithComment(MissingPropertyIssueData prop) {
            Object comment = "";
            if (prop.enumItemsCount == 1) {
                comment = " = " + prop.defaultValue.toString();
            }
            return "'" + prop.propertyName + "'" + (String)comment;
        }

        public String getMessage(boolean trimIfNeeded) {
            if (this.myMissingPropertyIssues.size() == 1) {
                MissingPropertyIssueData prop = this.myMissingPropertyIssues.iterator().next();
                return JsonBundle.message((String)"schema.validation.property", (Object[])new Object[]{MissingMultiplePropsIssueData.getPropertyNameWithComment(prop)});
            }
            Collection<MissingPropertyIssueData> namesToDisplay = this.myMissingPropertyIssues;
            boolean trimmed = false;
            if (trimIfNeeded && namesToDisplay.size() > 3) {
                namesToDisplay = new ArrayList<MissingPropertyIssueData>();
                Iterator<MissingPropertyIssueData> iterator = this.myMissingPropertyIssues.iterator();
                for (int i = 0; i < 3; ++i) {
                    namesToDisplay.add(iterator.next());
                }
                trimmed = true;
            }
            Object allNames = this.myMissingPropertyIssues.stream().map(MissingMultiplePropsIssueData::getPropertyNameWithComment).sorted((s1, s2) -> {
                boolean secondHasEq;
                boolean firstHasEq = s1.contains("=");
                if (firstHasEq == (secondHasEq = s2.contains("="))) {
                    return s1.compareTo((String)s2);
                }
                return firstHasEq ? -1 : 1;
            }).collect(Collectors.joining(", "));
            if (trimmed) {
                allNames = (String)allNames + ", ...";
            }
            return JsonBundle.message((String)"schema.validation.properties", (Object[])new Object[]{allNames});
        }
    }

    public static final class MissingOneOfPropsIssueData
    implements IssueData {
        public final Collection<MissingMultiplePropsIssueData> myExclusiveOptions;

        public MissingOneOfPropsIssueData(Collection<MissingMultiplePropsIssueData> options) {
            this.myExclusiveOptions = options;
        }
    }

    public static final class DuplicateArrayItemIssueData
    implements IssueData {
        public final int[] duplicateIndices;

        public DuplicateArrayItemIssueData(int[] indices) {
            this.duplicateIndices = indices;
        }
    }

    public static final class ProhibitedPropertyIssueData
    implements IssueData {
        @NlsSafe
        public final String propertyName;
        public final List<@NlsSafe String> typoCandidates;

        public ProhibitedPropertyIssueData(@NlsSafe String propertyName, List<@NlsSafe String> typoCandidates) {
            this.propertyName = propertyName;
            this.typoCandidates = typoCandidates;
        }
    }

    public static final class TypeMismatchIssueData
    implements IssueData {
        public final JsonSchemaType[] expectedTypes;

        public TypeMismatchIssueData(JsonSchemaType[] expectedTypes) {
            this.expectedTypes = expectedTypes;
        }
    }

    public static final class MissingPropertyIssueData
    implements IssueData {
        public final String propertyName;
        public final JsonSchemaType propertyType;
        public final Object defaultValue;
        public final int enumItemsCount;

        public MissingPropertyIssueData(String propertyName, JsonSchemaType propertyType, Object defaultValue, int enumItemsCount) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.defaultValue = defaultValue;
            this.enumItemsCount = enumItemsCount;
        }
    }
}

