/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.UsageMarker;

public class UsedMemberFilter
implements MemberVisitor {
    private final UsageMarker usageMarker;
    private final MemberVisitor memberVisitor;

    public UsedMemberFilter(UsageMarker usageMarker, MemberVisitor memberVisitor) {
        this.usageMarker = usageMarker;
        this.memberVisitor = memberVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.usageMarker.isUsed(programField)) {
            this.memberVisitor.visitProgramField(programClass, programField);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.usageMarker.isUsed(programMethod)) {
            this.memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (this.usageMarker.isUsed(libraryField)) {
            this.memberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.usageMarker.isUsed(libraryMethod)) {
            this.memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }
}

