/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraintColumn;
import org.jkiss.dbeaver.model.meta.Property;

public class PostgreTableConstraintColumn
extends AbstractTableConstraintColumn {
    @NotNull
    private PostgreTableConstraintBase<?> constraint;
    @NotNull
    private PostgreAttribute<?> tableColumn;
    private int ordinalPosition;

    public PostgreTableConstraintColumn(@NotNull PostgreTableConstraintBase<?> constraint, @NotNull PostgreAttribute<?> tableColumn, int ordinalPosition) {
        this.constraint = constraint;
        this.tableColumn = tableColumn;
        this.ordinalPosition = ordinalPosition;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.tableColumn.getName();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public PostgreAttribute<?> getAttribute() {
        return this.tableColumn;
    }

    @Property(viewable=false, order=2)
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @Nullable
    public String getDescription() {
        return this.tableColumn.getDescription();
    }

    public PostgreTableConstraintBase<?> getParentObject() {
        return this.constraint;
    }

    @NotNull
    public PostgreDataSource getDataSource() {
        return (PostgreDataSource)((PostgreTableBase)this.constraint.getTable()).getDataSource();
    }
}

