/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.nio.file.Path;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;

public class DriverFileInfo {
    private final String id;
    private final String version;
    private final DBPDriverLibrary.FileType type;
    private final Path file;
    private final String fileLocation;
    private long fileCRC;

    public DriverFileInfo(String id, String version, DBPDriverLibrary.FileType type, Path file, String fileLocation) {
        this.id = id;
        this.version = version;
        this.file = file;
        this.type = type;
        this.fileLocation = fileLocation;
    }

    DriverFileInfo(DBPDriverLibrary library) {
        this.id = library.getId();
        this.version = library.getVersion();
        this.file = library.getLocalFile();
        this.type = library.getType();
        this.fileLocation = library.getLocalFile() != null ? library.getLocalFile().toString() : library.getPath();
        this.fileCRC = library.getFileCRC();
    }

    public Path getFile() {
        return this.file;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public DBPDriverLibrary.FileType getType() {
        return this.type;
    }

    public long getFileCRC() {
        return this.fileCRC;
    }

    public void setFileCRC(long fileCRC) {
        this.fileCRC = fileCRC;
    }

    public String toString() {
        return this.file != null ? this.file.getFileName().toString() : this.id;
    }
}

