/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.utils.ArrayUtils;

public class ResultSetCellLocation {
    private final DBDAttributeBinding attribute;
    private final ResultSetRow row;
    private final int[] rowIndexes;

    public ResultSetCellLocation(@NotNull DBDAttributeBinding attribute, @NotNull ResultSetRow row) {
        this(attribute, row, null);
    }

    public ResultSetCellLocation(@NotNull DBDAttributeBinding attribute, @NotNull ResultSetRow row, @Nullable int[] rowIndexes) {
        this.attribute = ResultSetCellLocation.getLeafAttribute(attribute, rowIndexes);
        this.row = row;
        this.rowIndexes = rowIndexes;
    }

    @NotNull
    public DBDAttributeBinding getAttribute() {
        return this.attribute;
    }

    @NotNull
    public ResultSetRow getRow() {
        return this.row;
    }

    @Nullable
    public int[] getRowIndexes() {
        return this.rowIndexes;
    }

    @NotNull
    public static DBDAttributeBinding getLeafAttribute(@NotNull DBDAttributeBinding attribute, @Nullable int[] indexes) {
        DBDAttributeBinding leaf = attribute;
        if (leaf.getDataKind() == DBPDataKind.STRUCT && !ArrayUtils.isEmpty((int[])indexes)) {
            int[] nArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                List nestedBindings = leaf.getNestedBindings();
                if (nestedBindings == null || index >= nestedBindings.size()) break;
                leaf = (DBDAttributeBinding)nestedBindings.get(index);
                ++n2;
            }
        }
        return leaf;
    }
}

