/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.hints;

import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.data.hints.DBDValueHint;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.data.DBDValueHintActionHandler;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class ValueHintReference
implements DBDValueHint,
DBDValueHintActionHandler {
    @NotNull
    private final DBDAttributeBinding attribute;
    @NotNull
    private final DBDValueRow row;
    @NotNull
    private final DBSEntityAssociation association;

    public ValueHintReference(@NotNull DBDAttributeBinding attribute, @NotNull DBDValueRow row, @NotNull DBSEntityAssociation association) {
        this.attribute = attribute;
        this.row = row;
        this.association = association;
    }

    @NotNull
    public DBSEntityAssociation getAssociation() {
        return this.association;
    }

    public DBDValueHint.HintType getHintType() {
        return DBDValueHint.HintType.ACTION;
    }

    public String getHintText() {
        return null;
    }

    public String getHintDescription() {
        return "Navigate to referenced table row";
    }

    public DBPImage getHintIcon() {
        return UIIcon.LINK;
    }

    @Override
    public String getActionText() {
        DBSEntity associatedEntity = this.association.getAssociatedEntity();
        if (associatedEntity == null) {
            return null;
        }
        return "Navigate to '" + DBUtils.getObjectFullName((DBPNamedObject)associatedEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "'";
    }

    @Override
    public void performAction(final @NotNull IResultSetController controller, long state) throws DBException {
        if (CommonUtils.isBitSet((long)state, (long)65536L)) {
            EditDictionaryPage editDictionaryPage = new EditDictionaryPage(this.association.getAssociatedEntity());
            if (editDictionaryPage.edit(controller.getControl().getShell())) {
                controller.refreshData(null);
            }
            return;
        }
        final boolean newWindow = RuntimeUtils.isMacOS() ? CommonUtils.isBitSet((long)state, (long)0x400000L) : CommonUtils.isBitSet((long)state, (long)262144L);
        new AbstractJob("Navigate association"){

            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                try {
                    controller.navigateAssociation(monitor, controller.getModel(), ValueHintReference.this.association, Collections.singletonList(ValueHintReference.this.row), newWindow);
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

