/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.uparser.ContentHandler;
import io.sf.carte.uparser.TokenErrorHandler;

abstract class AbstractTokenHandler
implements ContentHandler<RuntimeException>,
TokenErrorHandler<RuntimeException> {
    static final int ENDCP = -1;
    boolean parseError = false;
    int prevcp = 32;

    protected AbstractTokenHandler() {
    }

    boolean isPrevCpWhitespace() {
        return this.prevcp == 32 || this.prevcp == 10;
    }

    void setWhitespacePrevCp() {
        if (this.prevcp != 10) {
            this.prevcp = 32;
        }
    }

    boolean isPreviousCp(int codePoint) {
        return this.prevcp == codePoint;
    }

    protected boolean isPreviousCpLF() {
        return this.prevcp == 10;
    }

    boolean isEndCp() {
        return this.prevcp == -1;
    }

    protected void setHandlerPreviousCp(int cp) {
        this.prevcp = cp;
    }

    public void handleError(int index, byte errCode, String message) throws CSSParseException {
        if (!this.isInError()) {
            if (this.isEndCp()) {
                CSSParseException ex = this.createException(index, errCode, "Unexpected end of file");
                this.reportError(ex);
            } else {
                CSSParseException ex = this.createException(index, errCode, message);
                this.handleError(ex);
            }
        }
    }

    void handleError(int index, byte errCode, String message, Throwable cause) throws CSSParseException {
        if (!this.isInError()) {
            if (this.isEndCp()) {
                CSSParseException ex = this.createException(index, errCode, "Unexpected end of file");
                ex.initCause(cause);
                this.reportError(ex);
            } else {
                CSSParseException ex = this.createException(index, errCode, message);
                ex.initCause(cause);
                this.handleError(ex);
            }
        }
    }

    protected void handleError(CSSParseException ex) throws CSSParseException {
        this.reportError(ex);
    }

    public void reportError(int index, byte errCode, String message) throws CSSParseException {
        CSSParseException ex = this.createException(index, errCode, message);
        this.reportError(ex);
    }

    public abstract void reportError(CSSParseException var1) throws CSSParseException;

    void unexpectedLeftCurlyBracketError(int index) {
        this.unexpectedCharError(index, 123);
    }

    public void unexpectedLeftSquareBracketError(int index) {
        this.unexpectedCharError(index, 91);
    }

    public void unexpectedRightCurlyBracketError(int index) {
        this.unexpectedCharError(index, 125);
    }

    public void unexpectedRightSquareBracketError(int index) {
        this.unexpectedCharError(index, 93);
    }

    void unexpectedCharError(int index, int codepoint) {
        this.handleError(index, (byte)4, "Unexpected '" + new String(Character.toChars(codepoint)) + "'");
    }

    void unexpectedTokenError(int index, CharSequence token) {
        this.handleError(index, (byte)9, "Unexpected: " + token);
    }

    public void unexpectedEOFError(int len) {
        this.unexpectedEOFError(len, "Unexpected end of stream");
    }

    public void unexpectedEOFError(int len, String message) {
        if (!this.isInError()) {
            CSSParseException ex = this.createException(len, (byte)10, message);
            this.reportError(ex);
        }
    }

    public final void handleWarning(int index, byte errCode, String message) {
        this.handleWarning(index, errCode, message, null);
    }

    public abstract void handleWarning(int var1, byte var2, String var3, Throwable var4);

    public void error(int index, byte errCode, CharSequence context) {
        this.handleError(index, errCode, "Syntax error near " + context);
    }

    public boolean isInError() {
        return this.parseError;
    }

    public void setParseError() {
        this.parseError = true;
    }

    public void resetParseError() {
        this.parseError = false;
    }

    public void resetHandler() {
        this.prevcp = 32;
    }

    public void quoted(int index, CharSequence quoted, int quote) {
        this.unexpectedTokenError(index, quoted);
    }

    public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
        this.quoted(index, quoted, quoteCp);
    }

    public void leftParenthesis(int index) {
        this.unexpectedCharError(index, 40);
    }

    public void leftSquareBracket(int index) {
        this.unexpectedLeftSquareBracketError(index);
    }

    public void rightParenthesis(int index) {
        this.unexpectedCharError(index, 41);
    }

    public void rightSquareBracket(int index) {
        this.unexpectedCharError(index, 93);
    }

    public abstract int getCurrentLine();

    public abstract int getPrevLineLength();

    abstract void setCurrentLocation(int var1);

    abstract CSSParseException createException(int var1, byte var2, String var3);
}

