/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.HSLColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.HSLColorImpl;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.dom.DOMException;

public class HSLColorValue
extends ColorValue
implements io.sf.carte.doc.style.css.HSLColorValue {
    private static final long serialVersionUID = 1L;
    private final HSLColorImpl hslColor;

    public HSLColorValue() {
        this.hslColor = new ColorValue.MyHSLColorImpl();
    }

    HSLColorValue(HSLColorImpl color) {
        this.hslColor = color;
    }

    HSLColorValue(HSLColorValue copied) {
        super(copied);
        this.hslColor = copied.hslColor.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.HSL;
    }

    @Override
    void set(StyleValue value) {
        super.set(value);
        HSLColorValue setfrom = (HSLColorValue)value;
        this.hslColor.setHue(setfrom.hslColor.getHue());
        this.hslColor.setSaturation(setfrom.hslColor.getSaturation());
        this.hslColor.setLightness(setfrom.hslColor.getLightness());
        this.hslColor.alpha = setfrom.hslColor.alpha;
    }

    @Override
    public String getCssText() {
        return this.hslColor.toString(this.commaSyntax);
    }

    @Override
    public String getMinifiedCssText(String propertyValue) {
        String rgbCss;
        String css = this.hslColor.toMinifiedString(this.commaSyntax);
        if (!this.hslColor.isNonOpaque() && this.hasConvertibleComponents() && (rgbCss = ((ColorValue.CSSRGBColor)this.toRGBColor()).toMinifiedString()).length() < css.length() - 5) {
            css = rgbCss;
        }
        return css;
    }

    @Override
    public PrimitiveValue getComponent(int index) {
        return this.hslColor.item(index);
    }

    @Override
    public void setComponent(int index, StyleValue component) {
        this.hslColor.setComponent(index, (PrimitiveValue)component);
    }

    @Override
    public HSLColorValue toHSLColorValue() throws DOMException {
        return this;
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        return this.toRGBColor(true);
    }

    @Override
    public RGBAColor toRGBColor(boolean clamp) throws DOMException {
        double[] rgb = this.hslColor.toSRGB(clamp);
        ColorValue.CSSRGBColor color = new ColorValue.CSSRGBColor();
        color.setColorComponents(rgb);
        color.setAlpha(this.hslColor.alpha.clone());
        return color;
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.hslColor.hasConvertibleComponents();
    }

    @Override
    public HSLColor getColor() {
        return this.hslColor;
    }

    HSLColorImpl getHSLColorImpl() {
        return this.hslColor;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.hslColor.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof HSLColorValue)) {
            return false;
        }
        HSLColorValue other = (HSLColorValue)obj;
        return this.hslColor.equals(other.hslColor);
    }

    @Override
    public HSLColorValue clone() {
        return new HSLColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(HSLColorValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            try {
                if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.HSLCOLOR) {
                    throw new DOMException(13, "No hsl() value: " + lunit.toString());
                }
                this.setLexicalHSL(lunit);
            }
            catch (DOMException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new DOMSyntaxException("Invalid value: " + lunit.toString());
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private void setLexicalHSL(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            ValueFactory factory = new ValueFactory();
            CSSColor from = null;
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "from".equalsIgnoreCase(lu.getStringValue())) {
                PrimitiveValue fromval = factory.createCSSPrimitiveValue(lu = ColorValue.nextLexicalUnit(lu, lunit), true);
                from = ColorValue.computeColor(fromval, factory);
                if (from.getColorModel() != CSSColorValue.ColorModel.HSL) {
                    from = from.toColorSpace("hsl");
                }
                lu = ColorValue.nextLexicalUnit(lu, lunit);
            }
            PrimitiveValue primihue = factory.createCSSPrimitiveValue(lu, true);
            if (from != null) {
                primihue = ColorValue.absoluteHue(from, primihue);
            }
            if (HSLColorValue.this.commaSyntax = (lu = lu.getNextLexicalUnit()).getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                lu = lu.getNextLexicalUnit();
            }
            PrimitiveValue primisat = factory.createCSSPrimitiveValue(lu, true);
            if (from != null) {
                primisat = HSLColorValue.this.absoluteComponent(from, primisat, false);
            }
            lu = lu.getNextLexicalUnit();
            if (HSLColorValue.this.commaSyntax) {
                if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    this.checkProxyValue(lu);
                    throw new DOMSyntaxException("Expected a second comma in: " + lunit.toString());
                }
                lu = lu.getNextLexicalUnit();
            }
            PrimitiveValue primilight = factory.createCSSPrimitiveValue(lu, true);
            if (from != null) {
                primilight = HSLColorValue.this.absoluteComponent(from, primilight, false);
            }
            lu = lu.getNextLexicalUnit();
            PrimitiveValue alpha = null;
            if (lu != null) {
                if (HSLColorValue.this.commaSyntax) {
                    if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        this.checkProxyValue(lu);
                        throw ColorValue.invalidValueException(lunit);
                    }
                } else if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    this.checkProxyValue(lu);
                    throw new DOMSyntaxException("Expected slash in: " + lunit.toString());
                }
                lu = lu.getNextLexicalUnit();
                alpha = factory.createCSSPrimitiveValue(lu, true);
                if (from != null) {
                    alpha = HSLColorValue.this.absoluteComponent(from, alpha, false);
                }
                HSLColorValue.this.hslColor.setAlpha(alpha);
                lu = lu.getNextLexicalUnit();
                if (lu != null) {
                    throw ColorValue.invalidValueException(lunit);
                }
            }
            HSLColorValue.this.hslColor.setHue(primihue);
            HSLColorValue.this.hslColor.setSaturation(primisat);
            HSLColorValue.this.hslColor.setLightness(primilight);
        }
    }
}

