/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.local;

import com.sun.jna.LastErrorException;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.ptr.IntByReference;
import ghidra.pty.PtySession;
import ghidra.pty.windows.Handle;
import ghidra.pty.windows.jna.JobApiNative;
import ghidra.util.Msg;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class LocalWindowsNativeProcessPtySession
implements PtySession {
    private final int pid;
    private final Handle processHandle;
    private final String ptyName;
    private final Handle jobHandle;

    public LocalWindowsNativeProcessPtySession(int pid, int tid, Handle processHandle, Handle threadHandle, String ptyName, Handle jobHandle) {
        this.pid = pid;
        this.processHandle = processHandle;
        this.ptyName = ptyName;
        this.jobHandle = jobHandle;
        Msg.info((Object)this, (Object)("local Windows Pty session. PID = " + pid));
    }

    protected int doWaitExited(int millis) throws TimeoutException {
        while (true) {
            switch (Kernel32.INSTANCE.WaitForSingleObject(this.processHandle.getNative(), millis)) {
                case 0: 
                case 128: {
                    IntByReference lpExitCode = new IntByReference();
                    Kernel32.INSTANCE.GetExitCodeProcess(this.processHandle.getNative(), lpExitCode);
                    if (lpExitCode.getValue() != 259) {
                        return lpExitCode.getValue();
                    }
                }
                case 258: {
                    throw new TimeoutException();
                }
                case -1: {
                    throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
                }
            }
        }
    }

    @Override
    public int waitExited() {
        try {
            return this.doWaitExited(-1);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int waitExited(long timeout, TimeUnit unit) throws TimeoutException {
        long millis = TimeUnit.MILLISECONDS.convert(timeout, unit);
        if (millis > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too long a timeout");
        }
        return this.doWaitExited((int)millis);
    }

    @Override
    public void destroyForcibly() {
        if (!JobApiNative.INSTANCE.TerminateJobObject(this.jobHandle.getNative(), 1).booleanValue()) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
    }

    @Override
    public String description() {
        return "process " + this.pid + " on " + this.ptyName;
    }
}

